/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.dataproviders;

import fi.dy.masa.servux.Reference;
import fi.dy.masa.servux.Servux;
import fi.dy.masa.servux.dataproviders.DataProviderBase;
import fi.dy.masa.servux.dataproviders.IDataProvider;
import fi.dy.masa.servux.network.IPluginServerPlayHandler;
import fi.dy.masa.servux.network.ServerPlayHandler;
import fi.dy.masa.servux.network.packet.ServuxEntitiesHandler;
import fi.dy.masa.servux.network.packet.ServuxEntitiesPacket;
import fi.dy.masa.servux.settings.IServuxSetting;
import fi.dy.masa.servux.settings.ServuxBoolSetting;
import fi.dy.masa.servux.settings.ServuxIntSetting;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class EntitiesDataProvider
extends DataProviderBase {
    public static final EntitiesDataProvider INSTANCE = new EntitiesDataProvider();
    protected static final ServuxEntitiesHandler<ServuxEntitiesPacket.Payload> HANDLER = ServuxEntitiesHandler.getInstance();
    protected final CompoundTag metadata = new CompoundTag();
    protected ServuxIntSetting permissionLevel = new ServuxIntSetting((IDataProvider)this, "permission_level", 0, 4, 0);
    protected ServuxBoolSetting nbtQueryOverride = new ServuxBoolSetting(this, "nbt_query_override", false);
    protected ServuxIntSetting nbtQueryPermissionLevel = new ServuxIntSetting((IDataProvider)this, "nbt_query_permission_level", 2, 4, 0);
    protected List<IServuxSetting<?>> settings = List.of(this.permissionLevel, this.nbtQueryOverride, this.nbtQueryPermissionLevel);
    private final List<UUID> invalidPlayers = new ArrayList<UUID>();

    protected EntitiesDataProvider() {
        super("entity_data", ServuxEntitiesHandler.CHANNEL_ID, 1, 0, "servux.provider.entity_data", "Entity Data provider for Client Side mods.");
        this.metadata.putString("name", this.getName());
        this.metadata.putString("id", this.getNetworkChannel().toString());
        this.metadata.putInt("version", this.getProtocolVersion());
        this.metadata.putString("servux", Reference.MOD_STRING);
    }

    @Override
    public List<IServuxSetting<?>> getSettings() {
        return this.settings;
    }

    @Override
    public void registerHandler() {
        ServerPlayHandler.getInstance().registerServerPlayHandler(HANDLER);
        if (!this.isRegistered()) {
            HANDLER.registerPlayPayload(ServuxEntitiesPacket.Payload.ID, ServuxEntitiesPacket.Payload.CODEC, 3);
            this.setRegistered(true);
        }
        HANDLER.registerPlayReceiver(ServuxEntitiesPacket.Payload.ID, (ServerPlayNetworking.PlayPayloadHandler<ServuxEntitiesPacket.Payload>)((ServerPlayNetworking.PlayPayloadHandler)HANDLER::receivePlayPayload));
    }

    @Override
    public void unregisterHandler() {
        HANDLER.unregisterPlayReceiver();
        ServerPlayHandler.getInstance().unregisterServerPlayHandler(HANDLER);
    }

    @Override
    public IPluginServerPlayHandler<?> getPacketHandler() {
        return HANDLER;
    }

    @Override
    public boolean isPlayerRegistered(ServerPlayer player) {
        return !this.isPlayerInvalid(player);
    }

    public void sendMetadata(ServerPlayer player) {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.hasPermission(player)) {
            Servux.debugLog("entity_data: Denying access for player {}, Insufficient Permissions", player.getName().tryCollapseToString());
            return;
        }
        Servux.debugLog("entityDataChannel: sendMetadata to player {}", player.getName().tryCollapseToString());
        if (player.connection != null) {
            HANDLER.sendPlayPayload(player.connection, new ServuxEntitiesPacket.Payload(ServuxEntitiesPacket.MetadataResponse(this.metadata)));
        } else {
            HANDLER.sendPlayPayload(player, new ServuxEntitiesPacket.Payload(ServuxEntitiesPacket.MetadataResponse(this.metadata)));
        }
    }

    public void onPacketFailure(ServerPlayer player) {
        this.setPlayerInvalid(player);
    }

    public void removePlayer(ServerPlayer player) {
        this.removeInvalidPlayer(player);
    }

    private void setPlayerInvalid(ServerPlayer player) {
        if (!this.invalidPlayers.contains(player.getUUID())) {
            this.invalidPlayers.add(player.getUUID());
        }
    }

    private boolean isPlayerInvalid(ServerPlayer player) {
        return this.invalidPlayers.contains(player.getUUID());
    }

    private void removeInvalidPlayer(ServerPlayer player) {
        this.invalidPlayers.remove(player.getUUID());
    }

    public void onBlockEntityRequest(ServerPlayer player, BlockPos pos) {
        if (!this.hasPermission(player) || !this.isEnabled()) {
            return;
        }
        BlockEntity be = player.getCommandSenderWorld().getBlockEntity(pos);
        CompoundTag nbt = be != null ? be.saveWithFullMetadata((HolderLookup.Provider)player.registryAccess()) : new CompoundTag();
        HANDLER.encodeServerData(player, ServuxEntitiesPacket.SimpleBlockResponse(pos, nbt));
    }

    public void onEntityRequest(ServerPlayer player, int entityId) {
        if (!this.hasPermission(player) || !this.isEnabled()) {
            return;
        }
        Entity entity = player.level().getEntity(entityId);
        CompoundTag nbt = new CompoundTag();
        if (entity != null) {
            if (entity instanceof Player) {
                ResourceLocation id = EntityType.getKey((EntityType)entity.getType());
                nbt = entity.saveWithoutId(nbt);
                if (id != null) {
                    nbt.putString("id", id.toString());
                }
                HANDLER.encodeServerData(player, ServuxEntitiesPacket.SimpleEntityResponse(entityId, nbt));
            } else if (entity.saveAsPassenger(nbt)) {
                HANDLER.encodeServerData(player, ServuxEntitiesPacket.SimpleEntityResponse(entityId, nbt));
            }
        }
    }

    public boolean hasNbtQueryOverride() {
        return this.isEnabled() && (Boolean)this.nbtQueryOverride.getValue() != false;
    }

    public boolean hasNbtQueryPermission(ServerPlayer player) {
        if (((Boolean)this.nbtQueryOverride.getValue()).booleanValue()) {
            return Permissions.check((Entity)player, (String)(this.permNode + ".nbt_query_override"), (int)((Integer)this.nbtQueryPermissionLevel.getValue()));
        }
        return player.hasPermissions(2);
    }

    @Override
    public boolean hasPermission(ServerPlayer player) {
        return Permissions.check((Entity)player, (String)this.permNode, (int)((Integer)this.permissionLevel.getValue()));
    }

    @Override
    public void onTickEndPre() {
    }

    @Override
    public void onTickEndPost() {
    }
}

