/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.dataproviders;

import fi.dy.masa.servux.Reference;
import fi.dy.masa.servux.Servux;
import fi.dy.masa.servux.dataproviders.DataProviderBase;
import fi.dy.masa.servux.dataproviders.IDataProvider;
import fi.dy.masa.servux.network.IPluginServerPlayHandler;
import fi.dy.masa.servux.network.ServerPlayHandler;
import fi.dy.masa.servux.network.packet.ServuxHudHandler;
import fi.dy.masa.servux.network.packet.ServuxHudPacket;
import fi.dy.masa.servux.settings.IServuxSetting;
import fi.dy.masa.servux.settings.ServuxBoolSetting;
import fi.dy.masa.servux.settings.ServuxIntSetting;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameRules;

public class HudDataProvider
extends DataProviderBase {
    public static final HudDataProvider INSTANCE = new HudDataProvider();
    protected static final ServuxHudHandler<ServuxHudPacket.Payload> HANDLER = ServuxHudHandler.getInstance();
    protected final CompoundTag metadata = new CompoundTag();
    protected ServuxIntSetting permissionLevel = new ServuxIntSetting((IDataProvider)this, "permission_level", 0, 4, 0);
    protected ServuxIntSetting updateInterval = new ServuxIntSetting((IDataProvider)this, "update_interval", 80, 1200, 20);
    protected ServuxBoolSetting shareWeatherStatus = new ServuxBoolSetting(this, "share_weather_status", false);
    protected ServuxIntSetting weatherPermissionLevel = new ServuxIntSetting((IDataProvider)this, "weather_permission_level", 0, 4, 0);
    protected ServuxBoolSetting shareSeed = new ServuxBoolSetting(this, "share_seed", false);
    protected ServuxIntSetting seedPermissionLevel = new ServuxIntSetting((IDataProvider)this, "seed_permission_level", 2, 4, 0);
    protected List<IServuxSetting<?>> settings = List.of(this.permissionLevel, this.updateInterval, this.shareWeatherStatus, this.weatherPermissionLevel, this.shareSeed, this.seedPermissionLevel);
    private BlockPos spawnPos = BlockPos.ZERO;
    private int spawnChunkRadius = -1;
    private long worldSeed = 0L;
    private int clearWeatherTime = -1;
    private int rainWeatherTime = -1;
    private int thunderWeatherTime = -1;
    private boolean isRaining;
    private boolean isThundering;
    private long lastTick;
    private long lastWeatherTick;
    private boolean refreshSpawnMetadata;
    private boolean refreshWeatherData;
    private final List<UUID> invalidPlayers = new ArrayList<UUID>();

    protected HudDataProvider() {
        super("hud_data", ServuxHudHandler.CHANNEL_ID, 1, 0, "servux.provider.hud_data", "MiniHUD Meta Data provider for various Server-Side information");
        this.metadata.putString("name", this.getName());
        this.metadata.putString("id", this.getNetworkChannel().toString());
        this.metadata.putInt("version", this.getProtocolVersion());
        this.metadata.putString("servux", Reference.MOD_STRING);
        this.metadata.putInt("spawnPosX", this.getSpawnPos().getX());
        this.metadata.putInt("spawnPosY", this.getSpawnPos().getY());
        this.metadata.putInt("spawnPosZ", this.getSpawnPos().getZ());
        this.metadata.putInt("spawnChunkRadius", this.getSpawnChunkRadius());
    }

    @Override
    public List<IServuxSetting<?>> getSettings() {
        return this.settings;
    }

    @Override
    public void registerHandler() {
        ServerPlayHandler.getInstance().registerServerPlayHandler(HANDLER);
        if (!this.isRegistered()) {
            HANDLER.registerPlayPayload(ServuxHudPacket.Payload.ID, ServuxHudPacket.Payload.CODEC, 3);
            this.setRegistered(true);
        }
        HANDLER.registerPlayReceiver(ServuxHudPacket.Payload.ID, (ServerPlayNetworking.PlayPayloadHandler<ServuxHudPacket.Payload>)((ServerPlayNetworking.PlayPayloadHandler)HANDLER::receivePlayPayload));
    }

    @Override
    public void unregisterHandler() {
        HANDLER.unregisterPlayReceiver();
        ServerPlayHandler.getInstance().unregisterServerPlayHandler(HANDLER);
    }

    @Override
    public IPluginServerPlayHandler<?> getPacketHandler() {
        return HANDLER;
    }

    @Override
    public boolean isPlayerRegistered(ServerPlayer player) {
        return !this.isPlayerInvalid(player);
    }

    @Override
    public boolean shouldTick() {
        return this.enabled;
    }

    @Override
    public void tick(MinecraftServer server, int tickCounter, ProfilerFiller profiler) {
        if (!this.isEnabled()) {
            return;
        }
        if (tickCounter % (Integer)this.updateInterval.getValue() == 0) {
            profiler.push(this.getName());
            List playerList = server.getPlayerList().getPlayers();
            this.lastTick = tickCounter;
            int radius = this.getSpawnChunkRadius();
            int rule = server.getGameRules().getInt(GameRules.RULE_SPAWN_CHUNK_RADIUS);
            if (radius != rule) {
                this.setSpawnChunkRadius(rule);
            }
            if (this.worldSeed == 0L) {
                this.checkWorldSeed(server);
            } else if (!((Boolean)this.shareSeed.getValue()).booleanValue()) {
                this.setWorldSeed(0L);
            }
            profiler.popPush(this.getName() + "_players");
            for (ServerPlayer player : playerList) {
                if (this.isPlayerInvalid(player)) continue;
                if (this.shouldRefreshWeatherData()) {
                    this.refreshWeatherData(player, null);
                }
                if (!this.shouldRefreshSpawnMetadata()) continue;
                this.refreshSpawnMetadata(player, null);
            }
            if (this.shouldRefreshWeatherData()) {
                this.lastWeatherTick = tickCounter;
                this.setRefreshWeatherDataComplete();
            }
            if (this.shouldRefreshSpawnMetadata()) {
                this.setRefreshSpawnMetadataComplete();
            }
            profiler.pop();
        }
    }

    private void setPlayerInvalid(ServerPlayer player) {
        if (!this.invalidPlayers.contains(player.getUUID())) {
            this.invalidPlayers.add(player.getUUID());
        }
    }

    private boolean isPlayerInvalid(ServerPlayer player) {
        return this.invalidPlayers.contains(player.getUUID());
    }

    private void removeInvalidPlayer(ServerPlayer player) {
        this.invalidPlayers.remove(player.getUUID());
    }

    public void tickWeather(int clearTime, int rainTime, int thunderTime, boolean isRaining, boolean isThunder) {
        if (!this.isEnabled()) {
            return;
        }
        this.clearWeatherTime = clearTime;
        this.rainWeatherTime = rainTime;
        this.thunderWeatherTime = thunderTime;
        this.isRaining = isRaining;
        this.isThundering = isThunder;
        if (this.lastTick - this.lastWeatherTick > (long)this.getTickInterval()) {
            this.refreshWeatherData = true;
        }
    }

    public void sendMetadata(ServerPlayer player) {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.hasPermission(player)) {
            Servux.debugLog("hud_service: Denying access for player {}, Insufficient Permissions", player.getName().tryCollapseToString());
            return;
        }
        this.removeInvalidPlayer(player);
        CompoundTag nbt = new CompoundTag();
        nbt.merge(this.metadata);
        if (!this.hasPermissionsForSeed(player) && nbt.contains("worldSeed")) {
            nbt.remove("worldSeed");
        }
        Servux.debugLog("hudDataChannel: sendMetadata to player {}", player.getName().tryCollapseToString());
        if (player.connection != null) {
            HANDLER.sendPlayPayload(player.connection, new ServuxHudPacket.Payload(ServuxHudPacket.MetadataResponse(this.metadata)));
        } else {
            HANDLER.sendPlayPayload(player, new ServuxHudPacket.Payload(ServuxHudPacket.MetadataResponse(this.metadata)));
        }
    }

    public void onPacketFailure(ServerPlayer player) {
        this.setPlayerInvalid(player);
    }

    public void removePlayer(ServerPlayer player) {
        this.removeInvalidPlayer(player);
    }

    public void refreshSpawnMetadata(ServerPlayer player, @Nullable CompoundTag data) {
        if (!this.isEnabled()) {
            return;
        }
        CompoundTag nbt = new CompoundTag();
        BlockPos spawnPos = INSTANCE.getSpawnPos();
        nbt.putString("id", this.getNetworkChannel().toString());
        nbt.putString("servux", Reference.MOD_STRING);
        nbt.putInt("spawnPosX", spawnPos.getX());
        nbt.putInt("spawnPosY", spawnPos.getY());
        nbt.putInt("spawnPosZ", spawnPos.getZ());
        nbt.putInt("spawnChunkRadius", INSTANCE.getSpawnChunkRadius());
        if (((Boolean)this.shareSeed.getValue()).booleanValue() && this.hasPermissionsForSeed(player)) {
            Servux.debugLog("refreshSpawnMetadata() player [{}] has seedPermissions.", player.getName().tryCollapseToString());
            nbt.putLong("worldSeed", this.worldSeed);
        } else {
            Servux.debugLog("refreshSpawnMetadata() player [{}] does not have seedPermissions.", player.getName().tryCollapseToString());
        }
        HANDLER.encodeServerData(player, ServuxHudPacket.SpawnResponse(nbt));
    }

    public void refreshWeatherData(ServerPlayer player, @Nullable CompoundTag data) {
        CompoundTag nbt = new CompoundTag();
        if (!this.hasPermissionsForWeather(player) || !this.isEnabled()) {
            return;
        }
        nbt.putString("id", this.getNetworkChannel().toString());
        nbt.putString("servux", Reference.MOD_STRING);
        if (this.isRaining && this.rainWeatherTime > -1) {
            nbt.putInt("SetRaining", this.rainWeatherTime);
            nbt.putBoolean("isRaining", true);
        } else {
            nbt.putBoolean("isRaining", false);
        }
        if (this.isThundering && this.thunderWeatherTime > -1) {
            nbt.putInt("SetThundering", this.thunderWeatherTime);
            nbt.putBoolean("isThundering", true);
        } else {
            nbt.putBoolean("isThundering", false);
        }
        if (this.clearWeatherTime > -1) {
            nbt.putInt("SetClear", this.clearWeatherTime);
        }
        HANDLER.encodeServerData(player, ServuxHudPacket.WeatherTick(nbt));
    }

    public BlockPos getSpawnPos() {
        if (this.spawnPos == null) {
            this.setSpawnPos(BlockPos.ZERO);
        }
        return this.spawnPos;
    }

    public void setSpawnPos(BlockPos spawnPos) {
        if (!this.spawnPos.equals((Object)spawnPos)) {
            this.metadata.remove("spawnPosX");
            this.metadata.remove("spawnPosY");
            this.metadata.remove("spawnPosZ");
            this.metadata.putInt("spawnPosX", spawnPos.getX());
            this.metadata.putInt("spawnPosY", spawnPos.getY());
            this.metadata.putInt("spawnPosZ", spawnPos.getZ());
            this.refreshSpawnMetadata = true;
            Servux.debugLog("setSpawnPos(): updating World Spawn [{}] -> [{}]", this.spawnPos.toShortString(), spawnPos.toShortString());
        }
        this.spawnPos = spawnPos;
    }

    public int getSpawnChunkRadius() {
        if (this.spawnChunkRadius < 0) {
            this.spawnChunkRadius = 2;
        }
        return this.spawnChunkRadius;
    }

    public void setSpawnChunkRadius(int radius) {
        if (this.spawnChunkRadius != radius) {
            this.metadata.remove("spawnChunkRadius");
            this.metadata.putInt("spawnChunkRadius", radius);
            this.refreshSpawnMetadata = true;
            Servux.debugLog("setSpawnPos(): updating Spawn Chunk Radius [{}] -> [{}]", this.spawnChunkRadius, radius);
        }
        this.spawnChunkRadius = radius;
    }

    public boolean shouldRefreshSpawnMetadata() {
        return this.refreshSpawnMetadata;
    }

    public void setRefreshSpawnMetadataComplete() {
        this.refreshSpawnMetadata = false;
        Servux.debugLog("setRefreshSpawnMetadataComplete()", new Object[0]);
    }

    public boolean shouldRefreshWeatherData() {
        return this.refreshWeatherData;
    }

    public void setRefreshWeatherDataComplete() {
        this.refreshWeatherData = false;
    }

    public long getWorldSeed() {
        return this.worldSeed;
    }

    public void setWorldSeed(long seed) {
        if (this.worldSeed != seed) {
            if (((Boolean)this.shareSeed.getValue()).booleanValue()) {
                this.metadata.remove("worldSeed");
                this.metadata.putLong("worldSeed", seed);
                this.refreshSpawnMetadata = true;
            }
            Servux.debugLog("setWorldSeed(): updating World Seed [{}] -> [{}]", this.worldSeed, seed);
        }
        this.worldSeed = seed;
    }

    public void checkWorldSeed(MinecraftServer server) {
        ServerLevel world;
        if (((Boolean)this.shareSeed.getValue()).booleanValue() && (world = server.overworld()) != null) {
            this.setWorldSeed(world.getSeed());
        }
    }

    public boolean hasPermissionsForWeather(ServerPlayer player) {
        return Permissions.check((Entity)player, (String)(this.permNode + ".weather"), (int)((Integer)this.weatherPermissionLevel.getValue()));
    }

    public boolean hasPermissionsForSeed(ServerPlayer player) {
        return Permissions.check((Entity)player, (String)(this.permNode + ".seed"), (int)((Integer)this.seedPermissionLevel.getValue()));
    }

    @Override
    public boolean hasPermission(ServerPlayer player) {
        return Permissions.check((Entity)player, (String)this.permNode, (int)((Integer)this.permissionLevel.getValue()));
    }

    @Override
    public void onTickEndPre() {
    }

    @Override
    public void onTickEndPost() {
    }
}

