/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.dataproviders;

import fi.dy.masa.servux.Reference;
import fi.dy.masa.servux.Servux;
import fi.dy.masa.servux.dataproviders.DataProviderBase;
import fi.dy.masa.servux.dataproviders.IDataProvider;
import fi.dy.masa.servux.network.IPluginServerPlayHandler;
import fi.dy.masa.servux.network.ServerPlayHandler;
import fi.dy.masa.servux.network.packet.ServuxTweaksHandler;
import fi.dy.masa.servux.network.packet.ServuxTweaksPacket;
import fi.dy.masa.servux.settings.IServuxSetting;
import fi.dy.masa.servux.settings.ServuxIntSetting;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TweaksDataProvider
extends DataProviderBase {
    public static final TweaksDataProvider INSTANCE = new TweaksDataProvider();
    protected static final ServuxTweaksHandler<ServuxTweaksPacket.Payload> HANDLER = ServuxTweaksHandler.getInstance();
    protected final CompoundTag metadata = new CompoundTag();
    protected ServuxIntSetting permissionLevel = new ServuxIntSetting((IDataProvider)this, "permission_level", 0, 4, 0);
    protected List<IServuxSetting<?>> settings = List.of(this.permissionLevel);
    private final List<UUID> invalidPlayers = new ArrayList<UUID>();

    protected TweaksDataProvider() {
        super("tweaks_data", ServuxTweaksHandler.CHANNEL_ID, 1, 0, "servux.provider.tweaks_data", "Tweaks Data provider for Client Side mods.");
        this.metadata.putString("name", this.getName());
        this.metadata.putString("id", this.getNetworkChannel().toString());
        this.metadata.putInt("version", this.getProtocolVersion());
        this.metadata.putString("servux", Reference.MOD_STRING);
    }

    @Override
    public List<IServuxSetting<?>> getSettings() {
        return this.settings;
    }

    @Override
    public void registerHandler() {
        ServerPlayHandler.getInstance().registerServerPlayHandler(HANDLER);
        if (!this.isRegistered()) {
            HANDLER.registerPlayPayload(ServuxTweaksPacket.Payload.ID, ServuxTweaksPacket.Payload.CODEC, 3);
            this.setRegistered(true);
        }
        HANDLER.registerPlayReceiver(ServuxTweaksPacket.Payload.ID, (ServerPlayNetworking.PlayPayloadHandler<ServuxTweaksPacket.Payload>)((ServerPlayNetworking.PlayPayloadHandler)HANDLER::receivePlayPayload));
    }

    @Override
    public void unregisterHandler() {
        HANDLER.unregisterPlayReceiver();
        ServerPlayHandler.getInstance().unregisterServerPlayHandler(HANDLER);
    }

    @Override
    public IPluginServerPlayHandler<?> getPacketHandler() {
        return HANDLER;
    }

    @Override
    public boolean isPlayerRegistered(ServerPlayer player) {
        return !this.isPlayerInvalid(player);
    }

    public void sendMetadata(ServerPlayer player) {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.hasPermission(player)) {
            Servux.debugLog("tweaks_service: Denying access for player {}, Insufficient Permissions", player.getName().tryCollapseToString());
            return;
        }
        Servux.debugLog("tweaksDataChannel: sendMetadata to player {}", player.getName().tryCollapseToString());
        if (player.connection != null) {
            HANDLER.sendPlayPayload(player.connection, new ServuxTweaksPacket.Payload(ServuxTweaksPacket.MetadataResponse(this.metadata)));
        } else {
            HANDLER.sendPlayPayload(player, new ServuxTweaksPacket.Payload(ServuxTweaksPacket.MetadataResponse(this.metadata)));
        }
    }

    public void onPacketFailure(ServerPlayer player) {
        this.setPlayerInvalid(player);
    }

    public void removePlayer(ServerPlayer player) {
        this.removeInvalidPlayer(player);
    }

    private void setPlayerInvalid(ServerPlayer player) {
        if (!this.invalidPlayers.contains(player.getUUID())) {
            this.invalidPlayers.add(player.getUUID());
        }
    }

    private boolean isPlayerInvalid(ServerPlayer player) {
        return this.invalidPlayers.contains(player.getUUID());
    }

    private void removeInvalidPlayer(ServerPlayer player) {
        this.invalidPlayers.remove(player.getUUID());
    }

    public void onBlockEntityRequest(ServerPlayer player, BlockPos pos) {
        if (!this.hasPermission(player) || !this.isEnabled()) {
            return;
        }
        BlockEntity be = player.getCommandSenderWorld().getBlockEntity(pos);
        CompoundTag nbt = be != null ? be.saveWithoutMetadata((HolderLookup.Provider)player.registryAccess()) : new CompoundTag();
        HANDLER.encodeServerData(player, ServuxTweaksPacket.SimpleBlockResponse(pos, nbt));
    }

    public void onEntityRequest(ServerPlayer player, int entityId) {
        if (!this.hasPermission(player)) {
            return;
        }
        Entity entity = player.level().getEntity(entityId);
        CompoundTag nbt = new CompoundTag();
        if (entity != null) {
            if (entity instanceof Player) {
                ResourceLocation id = EntityType.getKey((EntityType)entity.getType());
                nbt = entity.saveWithoutId(nbt);
                if (id != null) {
                    nbt.putString("id", id.toString());
                }
                HANDLER.encodeServerData(player, ServuxTweaksPacket.SimpleEntityResponse(entityId, nbt));
            } else if (entity.saveAsPassenger(nbt)) {
                HANDLER.encodeServerData(player, ServuxTweaksPacket.SimpleEntityResponse(entityId, nbt));
            }
        }
    }

    @Override
    public boolean hasPermission(ServerPlayer player) {
        return Permissions.check((Entity)player, (String)this.permNode, (int)((Integer)this.permissionLevel.getValue()));
    }

    @Override
    public void onTickEndPre() {
    }

    @Override
    public void onTickEndPost() {
    }
}

