/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.mixin;

import com.mojang.authlib.GameProfile;
import fi.dy.masa.servux.event.PlayerHandler;
import java.net.SocketAddress;
import java.util.UUID;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerList.class})
public abstract class MixinPlayerManager {
    @Unique
    private GameProfile profileTemp;

    @Inject(method={"canPlayerLogin(Ljava/net/SocketAddress;Lcom/mojang/authlib/GameProfile;)Lnet/minecraft/network/chat/Component;"}, at={@At(value="RETURN")})
    private void servux_onClientConnect(SocketAddress address, GameProfile profile, CallbackInfoReturnable<Component> cir) {
        ((PlayerHandler)PlayerHandler.getInstance()).onClientConnect(address, profile, (Component)cir.getReturnValue());
    }

    @Inject(method={"placeNewPlayer(Lnet/minecraft/network/Connection;Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/server/network/CommonListenerCookie;)V"}, at={@At(value="TAIL")})
    private void servux_onPlayerJoin(Connection connection, ServerPlayer player, CommonListenerCookie clientData, CallbackInfo ci) {
        ((PlayerHandler)PlayerHandler.getInstance()).onPlayerJoin(connection.getRemoteAddress(), clientData.gameProfile(), player);
    }

    @Inject(method={"respawn(Lnet/minecraft/server/level/ServerPlayer;ZLnet/minecraft/world/entity/Entity$RemovalReason;)Lnet/minecraft/server/level/ServerPlayer;"}, at={@At(value="RETURN")})
    private void servux_onPlayerRespawn(ServerPlayer player, boolean alive, Entity.RemovalReason removalReason, CallbackInfoReturnable<ServerPlayer> cir) {
        ((PlayerHandler)PlayerHandler.getInstance()).onPlayerRespawn((ServerPlayer)cir.getReturnValue(), player);
    }

    @Inject(method={"op(Lcom/mojang/authlib/GameProfile;)V"}, at={@At(value="HEAD")})
    private void servux_onCaptureGameProfileOp(GameProfile profile, CallbackInfo ci) {
        this.profileTemp = profile;
    }

    @Redirect(method={"op(Lcom/mojang/authlib/GameProfile;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;getPlayer(Ljava/util/UUID;)Lnet/minecraft/server/level/ServerPlayer;"))
    private ServerPlayer servux_onPlayerOp(PlayerList instance, UUID uuid) {
        ServerPlayer player = instance.getPlayer(uuid);
        ((PlayerHandler)PlayerHandler.getInstance()).onPlayerOp(this.profileTemp, uuid, player);
        if (this.profileTemp != null) {
            this.profileTemp = null;
        }
        return player;
    }

    @Inject(method={"deop(Lcom/mojang/authlib/GameProfile;)V"}, at={@At(value="HEAD")})
    private void servux_onGameProfileDeOp(GameProfile profile, CallbackInfo ci) {
        this.profileTemp = profile;
    }

    @Redirect(method={"deop(Lcom/mojang/authlib/GameProfile;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;getPlayer(Ljava/util/UUID;)Lnet/minecraft/server/level/ServerPlayer;"))
    private ServerPlayer servux_onPlayerDeOp(PlayerList instance, UUID uuid) {
        ServerPlayer player = instance.getPlayer(uuid);
        ((PlayerHandler)PlayerHandler.getInstance()).onPlayerDeOp(this.profileTemp, uuid, player);
        if (this.profileTemp != null) {
            this.profileTemp = null;
        }
        return player;
    }

    @Inject(method={"remove(Lnet/minecraft/server/level/ServerPlayer;)V"}, at={@At(value="HEAD")})
    private void servux_onPlayerLeave(ServerPlayer player, CallbackInfo ci) {
        ((PlayerHandler)PlayerHandler.getInstance()).onPlayerLeave(player);
    }
}

