/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.mixin.debug;

import fi.dy.masa.servux.dataproviders.DebugDataProvider;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DebugPackets.class})
public class MixinDebugInfoSender {
    @Shadow
    private static List<String> getMemoryDescriptions(LivingEntity entity, long currentTime) {
        throw new AssertionError();
    }

    @Inject(method={"sendGameTestAddMarker(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Ljava/lang/String;II)V"}, at={@At(value="HEAD")})
    private static void servux_onAddGameTestMarker(ServerLevel world, BlockPos pos, String message, int color, int duration, CallbackInfo ci) {
    }

    @Inject(method={"sendGameTestClearPacket(Lnet/minecraft/server/level/ServerLevel;)V"}, at={@At(value="HEAD")})
    private static void servux_onClearGameTestMarkers(ServerLevel world, CallbackInfo ci) {
    }

    @Inject(method={"sendPoiPacketsForChunk(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/ChunkPos;)V"}, at={@At(value="HEAD")})
    private static void servux_onChunkWatchingChange(ServerLevel world, ChunkPos pos, CallbackInfo ci) {
        DebugDataProvider.INSTANCE.sendChunkWatchingChange(world, pos);
    }

    @Inject(method={"sendPoiAddedPacket(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;)V"}, at={@At(value="HEAD")})
    private static void servux_onSendPoiAddition(ServerLevel world, BlockPos pos, CallbackInfo ci) {
        DebugDataProvider.INSTANCE.sendPoiAdditions(world, pos);
    }

    @Inject(method={"sendPoiRemovedPacket(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;)V"}, at={@At(value="HEAD")})
    private static void servux_onSendPoiRemoval(ServerLevel world, BlockPos pos, CallbackInfo ci) {
        DebugDataProvider.INSTANCE.sendPoiRemoval(world, pos);
    }

    @Inject(method={"sendPoiTicketCountPacket(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;)V"}, at={@At(value="HEAD")})
    private static void servux_onSendPointOfInterest(ServerLevel world, BlockPos pos, CallbackInfo ci) {
        DebugDataProvider.INSTANCE.sendPointOfInterest(world, pos);
    }

    @Inject(method={"sendVillageSectionsPacket(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;)V"}, at={@At(value="HEAD")})
    private static void servux_onSendPoi(ServerLevel world, BlockPos pos, CallbackInfo ci) {
        DebugDataProvider.INSTANCE.sendPoi(world, pos);
    }

    @Inject(method={"sendPathFindingPacket(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/Mob;Lnet/minecraft/world/level/pathfinder/Path;F)V"}, at={@At(value="HEAD")})
    private static void servux_onSendPathfindingData(Level world, Mob mob, @Nullable Path path, float nodeReachProximity, CallbackInfo ci) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            DebugDataProvider.INSTANCE.sendPathfindingData(serverWorld, mob, path, nodeReachProximity);
        }
    }

    @Inject(method={"sendNeighborsUpdatePacket(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V"}, at={@At(value="HEAD")})
    private static void servux_onSendNeighborUpdate(Level world, BlockPos pos, CallbackInfo ci) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            DebugDataProvider.INSTANCE.sendNeighborUpdate(serverWorld, pos);
        }
    }

    @Inject(method={"sendStructurePacket(Lnet/minecraft/world/level/WorldGenLevel;Lnet/minecraft/world/level/levelgen/structure/StructureStart;)V"}, at={@At(value="HEAD")})
    private static void servux_onSendStructureStart(WorldGenLevel world, StructureStart structureStart, CallbackInfo ci) {
        DebugDataProvider.INSTANCE.sendStructureStart(world, structureStart);
    }

    @Inject(method={"sendGoalSelector(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/Mob;Lnet/minecraft/world/entity/ai/goal/GoalSelector;)V"}, at={@At(value="HEAD")})
    private static void servux_onSendGoalSelector(Level world, Mob mob, GoalSelector goalSelector, CallbackInfo ci) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            DebugDataProvider.INSTANCE.sendGoalSelector(serverWorld, mob, goalSelector);
        }
    }

    @Inject(method={"sendRaids(Lnet/minecraft/server/level/ServerLevel;Ljava/util/Collection;)V"}, at={@At(value="HEAD")})
    private static void servux_onSendRaids(ServerLevel server, Collection<Raid> raids, CallbackInfo ci) {
        DebugDataProvider.INSTANCE.sendRaids(server, raids);
    }

    @Inject(method={"sendEntityBrain(Lnet/minecraft/world/entity/LivingEntity;)V"}, at={@At(value="HEAD")})
    private static void servux_onSendBrainDebugData(LivingEntity living, CallbackInfo ci) {
        Level level = living.level();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            DebugDataProvider.INSTANCE.sendBrainDebugData(world, living);
        }
    }

    @Inject(method={"sendBeeInfo(Lnet/minecraft/world/entity/animal/Bee;)V"}, at={@At(value="HEAD")})
    private static void servux_onSendBeeDebugData(Bee bee, CallbackInfo ci) {
        Level level = bee.level();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            DebugDataProvider.INSTANCE.sendBeeDebugData(world, bee);
        }
    }

    @Inject(method={"sendBreezeInfo(Lnet/minecraft/world/entity/monster/breeze/Breeze;)V"}, at={@At(value="HEAD")})
    private static void servux_onSendBreezeDebugData(Breeze breeze, CallbackInfo ci) {
        Level level = breeze.level();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            DebugDataProvider.INSTANCE.sendBreezeDebugData(world, breeze);
        }
    }

    @Inject(method={"sendGameEventInfo(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/Holder;Lnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="HEAD")})
    private static void servux_onSendGameEvent(Level world, Holder<GameEvent> event, Vec3 pos, CallbackInfo ci) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            DebugDataProvider.INSTANCE.sendGameEvent(serverWorld, event, pos);
        }
    }

    @Inject(method={"sendGameEventListenerInfo(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/gameevent/GameEventListener;)V"}, at={@At(value="HEAD")})
    private static void servux_onSendGameEventListener(Level world, GameEventListener eventListener, CallbackInfo ci) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            DebugDataProvider.INSTANCE.sendGameEventListener(serverWorld, eventListener);
        }
    }
}

