/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.network.packet;

import fi.dy.masa.servux.Servux;
import fi.dy.masa.servux.dataproviders.LitematicsDataProvider;
import fi.dy.masa.servux.network.IPluginServerPlayHandler;
import fi.dy.masa.servux.network.IServerPayloadData;
import fi.dy.masa.servux.network.PacketSplitter;
import fi.dy.masa.servux.network.packet.ServuxLitematicaPacket;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.util.RandomSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.DEDICATED_SERVER)
public abstract class ServuxLitematicaHandler<T extends CustomPacketPayload>
implements IPluginServerPlayHandler<T> {
    private static final ServuxLitematicaHandler<ServuxLitematicaPacket.Payload> INSTANCE = new ServuxLitematicaHandler<ServuxLitematicaPacket.Payload>(){

        public void receive(ServuxLitematicaPacket.Payload payload, ServerPlayNetworking.Context context) {
            INSTANCE.receivePlayPayload(payload, context);
        }
    };
    public static final ResourceLocation CHANNEL_ID = ResourceLocation.fromNamespaceAndPath((String)"servux", (String)"litematics");
    private boolean payloadRegistered = false;
    private final Map<UUID, Integer> failures = new HashMap<UUID, Integer>();
    private static final int MAX_FAILURES = 4;
    private final Map<UUID, Long> readingSessionKeys = new HashMap<UUID, Long>();

    public static ServuxLitematicaHandler<ServuxLitematicaPacket.Payload> getInstance() {
        return INSTANCE;
    }

    @Override
    public ResourceLocation getPayloadChannel() {
        return CHANNEL_ID;
    }

    @Override
    public boolean isPlayRegistered(ResourceLocation channel) {
        if (channel.equals((Object)CHANNEL_ID)) {
            return this.payloadRegistered;
        }
        return false;
    }

    @Override
    public void setPlayRegistered(ResourceLocation channel) {
        if (channel.equals((Object)CHANNEL_ID)) {
            this.payloadRegistered = true;
        }
    }

    @Override
    public <P extends IServerPayloadData> void decodeServerData(ResourceLocation channel, ServerPlayer player, P data) {
        ServuxLitematicaPacket packet = (ServuxLitematicaPacket)data;
        if (!channel.equals((Object)CHANNEL_ID)) {
            return;
        }
        switch (packet.getType()) {
            case PACKET_C2S_METADATA_REQUEST: {
                LitematicsDataProvider.INSTANCE.sendMetadata(player);
                break;
            }
            case PACKET_C2S_BLOCK_ENTITY_REQUEST: {
                LitematicsDataProvider.INSTANCE.onBlockEntityRequest(player, packet.getPos());
                break;
            }
            case PACKET_C2S_ENTITY_REQUEST: {
                LitematicsDataProvider.INSTANCE.onEntityRequest(player, packet.getEntityId());
                break;
            }
            case PACKET_C2S_BULK_ENTITY_NBT_REQUEST: {
                LitematicsDataProvider.INSTANCE.onBulkEntityRequest(player, packet.getChunkPos(), packet.getCompound());
                break;
            }
            case PACKET_C2S_NBT_RESPONSE_DATA: {
                long readingSessionKey;
                UUID uuid = player.getUUID();
                if (!this.readingSessionKeys.containsKey(uuid)) {
                    readingSessionKey = RandomSource.create((long)Util.getMillis()).nextLong();
                    this.readingSessionKeys.put(uuid, readingSessionKey);
                } else {
                    readingSessionKey = this.readingSessionKeys.get(uuid);
                }
                FriendlyByteBuf fullPacket = PacketSplitter.receive(this, readingSessionKey, packet.getBuffer());
                if (fullPacket == null) break;
                try {
                    this.readingSessionKeys.remove(uuid);
                    LitematicsDataProvider.INSTANCE.handleClientPasteRequest(player, fullPacket.readVarInt(), (CompoundTag)fullPacket.readNbt(NbtAccounter.unlimitedHeap()));
                }
                catch (Exception e) {
                    Servux.LOGGER.error("ServuxLitematicaHandler#decodeServerData(): Litematic Data: error reading fullBuffer [{}]", (Object)e.getLocalizedMessage());
                }
                break;
            }
            default: {
                Servux.LOGGER.warn("ServuxLitematicaHandler#decodeServerData(): Invalid packetType '{}' from player: {}, of size in bytes: {}.", (Object)packet.getPacketType(), (Object)player.getName().tryCollapseToString(), (Object)packet.getTotalSize());
            }
        }
    }

    @Override
    public void reset(ResourceLocation channel) {
        if (channel.equals((Object)CHANNEL_ID)) {
            this.failures.clear();
        }
    }

    public void resetFailures(ResourceLocation channel, ServerPlayer player) {
        if (channel.equals((Object)CHANNEL_ID)) {
            this.failures.remove(player.getUUID());
        }
    }

    @Override
    public void receivePlayPayload(T payload, ServerPlayNetworking.Context ctx) {
        if (payload.type().id().equals((Object)CHANNEL_ID)) {
            ServerPlayer player = ctx.player();
            INSTANCE.decodeServerData(CHANNEL_ID, player, ((ServuxLitematicaPacket.Payload)payload).data());
        }
    }

    @Override
    public void encodeWithSplitter(ServerPlayer player, FriendlyByteBuf buffer, ServerGamePacketListenerImpl networkHandler) {
        INSTANCE.sendPlayPayload(player, new ServuxLitematicaPacket.Payload(ServuxLitematicaPacket.ResponseS2CData(buffer)));
    }

    @Override
    public <P extends IServerPayloadData> void encodeServerData(ServerPlayer player, P data) {
        if (!LitematicsDataProvider.INSTANCE.isEnabled()) {
            return;
        }
        ServuxLitematicaPacket packet = (ServuxLitematicaPacket)data;
        if (packet.getType().equals((Object)ServuxLitematicaPacket.Type.PACKET_S2C_NBT_RESPONSE_START)) {
            FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
            buffer.writeVarInt(packet.getTransactionId());
            buffer.writeNbt((Tag)packet.getCompound());
            PacketSplitter.send(this, buffer, player, player.connection);
        } else if (!INSTANCE.sendPlayPayload(player, new ServuxLitematicaPacket.Payload(packet))) {
            UUID id = player.getUUID();
            if (!this.failures.containsKey(id)) {
                this.failures.put(id, 1);
            } else if (this.failures.get(id) > 4) {
                LitematicsDataProvider.INSTANCE.onPacketFailure(player);
            } else {
                int count = this.failures.get(id) + 1;
                this.failures.put(id, count);
            }
        }
    }
}

