/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.settings;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import fi.dy.masa.servux.dataproviders.IDataProvider;
import fi.dy.masa.servux.settings.AbstractServuxSetting;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;

public abstract class ServuxListSetting<T>
extends AbstractServuxSetting<List<T>> {
    private static final Gson GSON = new Gson();

    public ServuxListSetting(IDataProvider dataProvider, String name, Component prettyName, Component comment, List<T> defaultValue, List<String> examples, String separatorRegex) {
        this(dataProvider, name, prettyName, comment, defaultValue, examples);
    }

    public ServuxListSetting(IDataProvider dataProvider, String name, Component prettyName, Component comment, List<T> defaultValue, List<String> examples) {
        super(dataProvider, name, prettyName, comment, defaultValue, examples);
    }

    @Override
    public boolean validateString(String value) {
        JsonArray array = (JsonArray)GSON.fromJson(value, JsonArray.class);
        for (JsonElement element : array) {
            if (this.validateJsonForElement(element)) continue;
            return false;
        }
        return true;
    }

    public abstract boolean validateJsonForElement(JsonElement var1);

    @Override
    public String valueToString(Object value) {
        JsonArray array = new JsonArray();
        for (Object ele : (List)value) {
            array.add(this.writeElementToJson(ele));
        }
        return GSON.toJson((JsonElement)array);
    }

    @Override
    public List<T> valueFromString(String value) {
        return ((JsonArray)GSON.fromJson(value, JsonArray.class)).asList().stream().map(this::readElementFromJson).toList();
    }

    @Override
    public void readFromJson(JsonElement element) {
        if (element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            List list = array.asList().stream().map(this::readElementFromJson).collect(Collectors.toList());
            this.setValueNoCallback(list);
        }
    }

    public abstract T readElementFromJson(JsonElement var1);

    @Override
    public JsonElement writeToJson() {
        JsonArray array = new JsonArray();
        for (Object value : (List)this.getValue()) {
            array.add(this.writeElementToJson(value));
        }
        return array;
    }

    public abstract JsonElement writeElementToJson(T var1);
}

