/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.util;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockUtils {
    public static Optional<DirectionProperty> getFirstDirectionProperty(BlockState state) {
        for (Property prop : state.getProperties()) {
            if (!(prop instanceof DirectionProperty)) continue;
            return Optional.of((DirectionProperty)prop);
        }
        return Optional.empty();
    }

    public static Optional<Direction> getFirstPropertyFacingValue(BlockState state) {
        Optional<DirectionProperty> propOptional = BlockUtils.getFirstDirectionProperty(state);
        return propOptional.map(directionProperty -> Direction.from3DDataValue((int)((Direction)state.getValue((Property)directionProperty)).get3DDataValue()));
    }

    @Nullable
    public static Direction getPropertyFacingValue(BlockState state) {
        return state.hasProperty((Property)BlockStateProperties.FACING) ? (Direction)state.getValue((Property)BlockStateProperties.FACING) : null;
    }

    public static BlockState fixMirrorDoubleChest(BlockState state, Mirror mirror, ChestType type) {
        Direction facing = (Direction)state.getValue((Property)ChestBlock.FACING);
        Direction.Axis axis = facing.getAxis();
        if (mirror == Mirror.FRONT_BACK) {
            state = (BlockState)state.setValue((Property)ChestBlock.TYPE, (Comparable)type.getOpposite());
            if (axis == Direction.Axis.X) {
                state = (BlockState)state.setValue((Property)ChestBlock.FACING, (Comparable)facing.getOpposite());
            }
        } else if (mirror == Mirror.LEFT_RIGHT) {
            state = (BlockState)state.setValue((Property)ChestBlock.TYPE, (Comparable)type.getOpposite());
            if (axis == Direction.Axis.Z) {
                state = (BlockState)state.setValue((Property)ChestBlock.FACING, (Comparable)facing.getOpposite());
            }
        }
        return state;
    }
}

