/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.util.nbt;

import fi.dy.masa.servux.Servux;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.world.phys.Vec3;

public class NbtUtils {
    public static CompoundTag createBlockPosTag(Vec3i pos) {
        return NbtUtils.writeBlockPosToTag(pos, new CompoundTag());
    }

    public static CompoundTag writeBlockPosToTag(Vec3i pos, CompoundTag tag) {
        tag.putInt("x", pos.getX());
        tag.putInt("y", pos.getY());
        tag.putInt("z", pos.getZ());
        return tag;
    }

    @Nullable
    public static BlockPos readBlockPos(@Nullable CompoundTag tag) {
        if (tag != null && tag.contains("x", 3) && tag.contains("y", 3) && tag.contains("z", 3)) {
            return new BlockPos(tag.getInt("x"), tag.getInt("y"), tag.getInt("z"));
        }
        return null;
    }

    public static CompoundTag writeVec3dToTag(Vec3 vec, CompoundTag tag) {
        tag.putDouble("dx", vec.x);
        tag.putDouble("dy", vec.y);
        tag.putDouble("dz", vec.z);
        return tag;
    }

    public static CompoundTag writeEntityPositionToTag(Vec3 pos, CompoundTag tag) {
        ListTag posList = new ListTag();
        posList.add((Object)DoubleTag.valueOf((double)pos.x));
        posList.add((Object)DoubleTag.valueOf((double)pos.y));
        posList.add((Object)DoubleTag.valueOf((double)pos.z));
        tag.put("Pos", (Tag)posList);
        return tag;
    }

    @Nullable
    public static Vec3 readVec3d(@Nullable CompoundTag tag) {
        if (tag != null && tag.contains("dx", 6) && tag.contains("dy", 6) && tag.contains("dz", 6)) {
            return new Vec3(tag.getDouble("dx"), tag.getDouble("dy"), tag.getDouble("dz"));
        }
        return null;
    }

    @Nullable
    public static Vec3 readEntityPositionFromTag(@Nullable CompoundTag tag) {
        ListTag tagList;
        if (tag != null && tag.contains("Pos", 9) && (tagList = tag.getList("Pos", 6)).getElementType() == 6 && tagList.size() == 3) {
            return new Vec3(tagList.getDouble(0), tagList.getDouble(1), tagList.getDouble(2));
        }
        return null;
    }

    @Nullable
    public static Vec3i readVec3iFromTag(@Nullable CompoundTag tag) {
        if (tag != null && tag.contains("x", 3) && tag.contains("y", 3) && tag.contains("z", 3)) {
            return new Vec3i(tag.getInt("x"), tag.getInt("y"), tag.getInt("z"));
        }
        return null;
    }

    @Nullable
    public static CompoundTag readNbtFromFileAsPath(@Nonnull Path file) {
        return NbtUtils.readNbtFromFileAsPath(file, NbtAccounter.unlimitedHeap());
    }

    @Nullable
    public static CompoundTag readNbtFromFileAsPath(@Nonnull Path file, NbtAccounter tracker) {
        if (!Files.exists(file, new LinkOption[0]) || !Files.isReadable(file)) {
            return null;
        }
        try {
            return NbtIo.readCompressed((InputStream)Files.newInputStream(file, new OpenOption[0]), (NbtAccounter)tracker);
        }
        catch (Exception e) {
            Servux.LOGGER.warn("readNbtFromFileAsPath: Failed to read NBT data from file '{}'", (Object)file.toString());
            return null;
        }
    }

    public static void writeCompressed(@Nonnull CompoundTag tag, @Nonnull OutputStream outputStream) {
        try {
            NbtIo.writeCompressed((CompoundTag)tag, (OutputStream)outputStream);
        }
        catch (Exception err) {
            Servux.LOGGER.warn("writeCompressed: Failed to write NBT data to output stream");
        }
    }

    public static void writeCompressed(@Nonnull CompoundTag tag, @Nonnull Path file) {
        try {
            NbtIo.writeCompressed((CompoundTag)tag, (Path)file);
        }
        catch (Exception err) {
            Servux.LOGGER.warn("writeCompressed: Failed to write NBT data to file");
        }
    }
}

