package fi.dy.masa.servux.mixin.server;

import java.net.SocketAddress;
import java.util.Optional;
import java.util.UUID;

import net.minecraft.entity.Entity;
import net.minecraft.network.ClientConnection;
import net.minecraft.server.PlayerConfigEntry;
import net.minecraft.server.PlayerManager;
import net.minecraft.server.network.ConnectedClientData;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.text.Text;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import fi.dy.masa.servux.event.PlayerHandler;

/**
 * Interface for processing various server side Player Manager events
 */
@Mixin(PlayerManager.class)
public abstract class MixinPlayerManager
{
    @Unique
    private PlayerConfigEntry profileTemp;

    public MixinPlayerManager() { super(); }

    @Inject(method = "checkCanJoin", at = @At("RETURN"))
    private void servux_onClientConnect(SocketAddress address, PlayerConfigEntry playerConfigEntry, CallbackInfoReturnable<Text> cir)
    {
        ((PlayerHandler) PlayerHandler.getInstance()).onClientConnect(address, playerConfigEntry, cir.getReturnValue());
    }

    @Inject(method = "onPlayerConnect", at = @At("TAIL"))
    private void servux_onPlayerJoin(ClientConnection connection, ServerPlayerEntity player, ConnectedClientData clientData, CallbackInfo ci)
    {
        ((PlayerHandler) PlayerHandler.getInstance()).onPlayerJoin(connection.getAddress(), clientData.gameProfile(), player);
    }

    @Inject(method = "respawnPlayer", at = @At("RETURN"))
    private void servux_onPlayerRespawn(ServerPlayerEntity player, boolean alive, Entity.RemovalReason removalReason, CallbackInfoReturnable<ServerPlayerEntity> cir)
    {
        ((PlayerHandler) PlayerHandler.getInstance()).onPlayerRespawn(cir.getReturnValue(), player);
    }

    @Inject(method = "addToOperators(Lnet/minecraft/server/PlayerConfigEntry;Ljava/util/Optional;Ljava/util/Optional;)V", at = @At("HEAD"))
    private void servux_onCaptureGameProfileOp(PlayerConfigEntry player, Optional<Integer> permissionLevel, Optional<Boolean> canBypassPlayerLimit, CallbackInfo ci)
    {
        this.profileTemp = player;
    }

    @Redirect(method = "addToOperators(Lnet/minecraft/server/PlayerConfigEntry;Ljava/util/Optional;Ljava/util/Optional;)V",
            at = @At(value = "INVOKE",
                    target ="Lnet/minecraft/server/PlayerManager;getPlayer(Ljava/util/UUID;)Lnet/minecraft/server/network/ServerPlayerEntity;"))
    private ServerPlayerEntity servux_onPlayerOp(PlayerManager instance, UUID uuid)
    {
        ServerPlayerEntity player = instance.getPlayer(uuid);

        ((PlayerHandler) PlayerHandler.getInstance()).onPlayerOp(this.profileTemp, uuid, player);

        if (this.profileTemp != null)
        {
            this.profileTemp = null;
        }

        return player;
    }

    @Inject(method = "removeFromOperators", at = @At("HEAD"))
    private void servux_onGameProfileDeOp(PlayerConfigEntry player, CallbackInfo ci)
    {
        this.profileTemp = player;
    }

    @Redirect(method = "removeFromOperators",
            at = @At(value = "INVOKE",
                    target="Lnet/minecraft/server/PlayerManager;getPlayer(Ljava/util/UUID;)Lnet/minecraft/server/network/ServerPlayerEntity;"))
    private ServerPlayerEntity servux_onPlayerDeOp(PlayerManager instance, UUID uuid)
    {
        ServerPlayerEntity player = instance.getPlayer(uuid);

        ((PlayerHandler) PlayerHandler.getInstance()).onPlayerDeOp(this.profileTemp, uuid, player);

        if (this.profileTemp != null)
        {
            this.profileTemp = null;
        }

        return player;
    }

    @Inject(method = "remove", at = @At("HEAD"))
    private void servux_onPlayerLeave(ServerPlayerEntity player, CallbackInfo ci)
    {
        ((PlayerHandler) PlayerHandler.getInstance()).onPlayerLeave(player);
    }
}
