/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import fi.dy.masa.servux.dataproviders.DataProviderManager;
import fi.dy.masa.servux.dataproviders.IDataProvider;
import fi.dy.masa.servux.dataproviders.ServuxConfigProvider;
import fi.dy.masa.servux.interfaces.IServerCommand;
import fi.dy.masa.servux.settings.IServuxSetting;
import fi.dy.masa.servux.util.StringUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class ServuxCommand
implements IServerCommand {
    public static final ServuxCommand INSTANCE = new ServuxCommand();

    @Override
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext registryAccess, Commands.CommandSelection environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"servux").requires(Permissions.require((String)"servux.commands", (int)4))).then(((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(Permissions.require((String)"servux.commands.reload", (int)4))).executes(ctx -> {
            ServuxConfigProvider.INSTANCE.doReloadConfig((CommandSourceStack)ctx.getSource());
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"save").requires(Permissions.require((String)"servux.commands.save", (int)4))).executes(ctx -> {
            ServuxConfigProvider.INSTANCE.doSaveConfig((CommandSourceStack)ctx.getSource());
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"set").requires(Permissions.require((String)"servux.commands.set", (int)4))).then(this.settingsNode().then(Commands.argument((String)"value", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> {
            ResourceLocation settingId = (ResourceLocation)ctx.getArgument("setting", ResourceLocation.class);
            String settingName = StringUtils.removeDefaultMinecraftNamespace(settingId);
            IServuxSetting<?> setting = DataProviderManager.INSTANCE.getSettingByName(settingName);
            if (setting != null) {
                return SharedSuggestionProvider.suggest(setting.examples(), (SuggestionsBuilder)builder);
            }
            return builder.buildFuture();
        }).executes(ServuxCommand::configModify))))).then(((LiteralArgumentBuilder)Commands.literal((String)"info").requires(Permissions.require((String)"servux.commands.info", (int)4))).then(this.settingsNode().executes(ServuxCommand::configInfo)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"list").requires(Permissions.require((String)"servux.commands.list", (int)4))).executes(ctx -> this.configList((CommandContext<CommandSourceStack>)ctx, DataProviderManager.INSTANCE.getAllProviders().stream().flatMap(iDataProvider -> iDataProvider.getSettings().stream()).toList()))).then(Commands.argument((String)"provider", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(DataProviderManager.INSTANCE.getAllProviders(), (SuggestionsBuilder)builder, IDataProvider::getName, iDataProvider -> Component.literal((String)iDataProvider.getDescription()).append((Component)StringUtils.translate("servux.suffix.data_provider", new Object[0])))).executes(ctx -> {
            String provider = StringArgumentType.getString((CommandContext)ctx, (String)"provider");
            Optional<IDataProvider> dataProvider = DataProviderManager.INSTANCE.getProviderByName(provider);
            if (dataProvider.isEmpty()) {
                throw StringUtils.translateError("servux.command.error.unknown_data_provider", new Object[0]);
            }
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> StringUtils.translate("servux.command.config.list.data_provider", provider), false);
            return this.configList((CommandContext<CommandSourceStack>)ctx, dataProvider.get().getSettings());
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"search").requires(Permissions.require((String)"servux.commands.list", (int)4))).then(Commands.argument((String)"query", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            String query = StringArgumentType.getString((CommandContext)ctx, (String)"query");
            List<IServuxSetting<?>> settings = this.configSearch((CommandContext<CommandSourceStack>)ctx, query);
            if (settings.isEmpty()) {
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> StringUtils.translate("servux.command.search.none", query), false);
                return 0;
            }
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> StringUtils.translate("servux.command.search.results", settings.size(), query), false);
            return this.configList((CommandContext<CommandSourceStack>)ctx, settings);
        }))));
    }

    private List<IServuxSetting<?>> configSearch(CommandContext<CommandSourceStack> ctx, String query) {
        String[] searchParts = query.split(" ");
        return DataProviderManager.INSTANCE.getAllProviders().stream().flatMap(iDataProvider -> iDataProvider.getSettings().stream()).filter(iServuxSetting -> {
            for (String part : searchParts) {
                if (iServuxSetting.name().contains(part) || iServuxSetting.comment().getString().contains(part) || iServuxSetting.dataProvider().getName().contains(part)) continue;
                return false;
            }
            return true;
        }).toList();
    }

    private int configList(CommandContext<CommandSourceStack> ctx, List<IServuxSetting<?>> list) {
        if (list.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> StringUtils.translate("servux.command.error.no_settings", new Object[0]), false);
            return 0;
        }
        HashSet<String> appearedNames = new HashSet<String>();
        HashSet<String> appearedMultiTimes = new HashSet<String>();
        for (IServuxSetting<?> setting : list) {
            if (appearedNames.add(setting.name())) continue;
            appearedMultiTimes.add(setting.name());
        }
        for (IServuxSetting<?> setting : list) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> {
                String value;
                MutableComponent text = Component.empty();
                text.append((Component)setting.shortDisplayName().copy().withStyle(style -> style.withBold(Boolean.valueOf(true)).withClickEvent((ClickEvent)new ClickEvent.RunCommand("/servux info " + setting.qualifiedName()))));
                if (appearedMultiTimes.contains(setting.name())) {
                    text.append((Component)Component.literal((String)" (").append(Component.nullToEmpty((String)setting.dataProvider().getName())).append(")").withStyle(ChatFormatting.GRAY));
                }
                if ((value = setting.valueToString(setting.getValue())).length() < 10) {
                    text.append(": ").append(value);
                }
                return text;
            }, false);
        }
        return list.size();
    }

    private ArgumentBuilder<CommandSourceStack, ?> settingsNode() {
        RequiredArgumentBuilder node = Commands.argument((String)"setting", (ArgumentType)ResourceLocationArgument.id());
        node.suggests((ctx, builder) -> {
            if (builder.getRemainingLowerCase().contains(":")) {
                String providerName = builder.getRemaining().split(":")[0];
                DataProviderManager.INSTANCE.getProviderByName(providerName).ifPresent(iDataProvider -> iDataProvider.getSettings().forEach(iServuxSetting -> builder.suggest(providerName + ":" + iServuxSetting.name(), (Message)iServuxSetting.prettyName())));
            } else {
                SharedSuggestionProvider.suggest(DataProviderManager.INSTANCE.getAllProviders().stream().flatMap(iDataProvider -> iDataProvider.getSettings().stream()).toList(), (SuggestionsBuilder)builder, IServuxSetting::name, IServuxSetting::prettyName);
                SharedSuggestionProvider.suggest(DataProviderManager.INSTANCE.getAllProviders(), (SuggestionsBuilder)builder, IDataProvider::getName, iDataProvider -> Component.literal((String)iDataProvider.getDescription()).append((Component)StringUtils.translate("servux.suffix.data_provider", new Object[0])));
            }
            return builder.buildFuture();
        });
        return node;
    }

    private static int configInfo(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ResourceLocation settingId = (ResourceLocation)ctx.getArgument("setting", ResourceLocation.class);
        String settingName = StringUtils.removeDefaultMinecraftNamespace(settingId);
        IServuxSetting<?> setting = DataProviderManager.INSTANCE.getSettingByName(settingName);
        if (setting == null) {
            throw StringUtils.translateError("servux.command.error.unknown_setting", new Object[0]);
        }
        ((CommandSourceStack)ctx.getSource()).sendSuccess(Component::empty, false);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> {
            MutableComponent text = Component.empty();
            text.append((Component)setting.prettyName().copy().withStyle(style -> style.withColor(ChatFormatting.YELLOW).withBold(Boolean.valueOf(true))));
            text.append(" (");
            text.append((Component)Component.literal((String)setting.qualifiedName()).withStyle(style -> style.withColor(ChatFormatting.GRAY).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)StringUtils.translate("servux.command.info.click_to_copy", new Object[0]))).withClickEvent((ClickEvent)new ClickEvent.CopyToClipboard(setting.qualifiedName()))));
            text.append(")");
            return text;
        }, false);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> setting.comment().copy().withStyle(ChatFormatting.GRAY), false);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> {
            MutableComponent text = StringUtils.translate("servux.command.info.value", setting.valueToString(setting.getValue())).withStyle(style -> style.withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)StringUtils.translate("servux.command.info.click_to_set", setting.prettyName()))).withClickEvent((ClickEvent)new ClickEvent.SuggestCommand("/servux set " + setting.qualifiedName() + " "))).append(" ");
            if (Objects.equals(setting.getDefaultValue(), setting.getValue())) {
                text.append((Component)StringUtils.translate("servux.command.suffix.default_value", new Object[0]).withStyle(ChatFormatting.GRAY));
            } else {
                text.append((Component)StringUtils.translate("servux.command.suffix.modified", new Object[0]).withStyle(ChatFormatting.GREEN));
                text.append(" ");
                text.append((Component)StringUtils.translate("servux.command.info.reset", new Object[0]).withStyle(ChatFormatting.GRAY).withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.SuggestCommand("/servux set " + setting.qualifiedName() + " " + setting.valueToString(setting.getDefaultValue()))).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)StringUtils.translate("servux.command.info.click_to_reset_to", setting.valueToString(setting.getDefaultValue()))))));
            }
            return text;
        }, false);
        if (!setting.examples().isEmpty()) {
            MutableComponent text = StringUtils.translate("servux.command.info.examples", new Object[0]);
            setting.examples().forEach(example -> {
                MutableComponent optionText = Component.literal((String)example).withStyle(style -> {
                    style = example.equals(setting.valueToString(setting.getValue())) ? style.withColor(ChatFormatting.GREEN) : style.withColor(ChatFormatting.GRAY);
                    return style.withClickEvent((ClickEvent)new ClickEvent.SuggestCommand("/servux set " + setting.qualifiedName() + " " + example)).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)StringUtils.translate("servux.command.info.click_to_set", example)));
                });
                text.append((Component)optionText).append(" ");
            });
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> text, false);
        }
        return 1;
    }

    private static int configModify(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String value;
        ResourceLocation settingId = (ResourceLocation)ctx.getArgument("setting", ResourceLocation.class);
        String settingName = StringUtils.removeDefaultMinecraftNamespace(settingId);
        IServuxSetting<?> setting = DataProviderManager.INSTANCE.getSettingByName(settingName);
        if (setting == null) {
            throw StringUtils.translateError("servux.command.error.unknown_setting", new Object[0]);
        }
        try {
            value = (String)ctx.getArgument("value", String.class);
        }
        catch (Exception e) {
            value = setting.getDefaultValue().toString();
        }
        if (value == null || value.isEmpty()) {
            value = setting.getDefaultValue().toString();
        }
        if (!setting.validateString(value)) {
            throw StringUtils.translateError("servux.command.error.invalid_value", new Object[0]);
        }
        String finalValue = value;
        setting.setValueFromString(finalValue);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> StringUtils.translate("servux.command.config.set_value", setting.shortDisplayName().copy().withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.RunCommand("/servux info " + setting.qualifiedName()))), finalValue), true);
        return 1;
    }
}

