/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.dataproviders;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import fi.dy.masa.servux.Reference;
import fi.dy.masa.servux.Servux;
import fi.dy.masa.servux.dataproviders.DataProviderBase;
import fi.dy.masa.servux.dataproviders.IDataProvider;
import fi.dy.masa.servux.loggers.DataLogger;
import fi.dy.masa.servux.loggers.DataLoggerBase;
import fi.dy.masa.servux.network.IPluginServerPlayHandler;
import fi.dy.masa.servux.network.ServerPlayHandler;
import fi.dy.masa.servux.network.packet.ServuxHudHandler;
import fi.dy.masa.servux.network.packet.ServuxHudPacket;
import fi.dy.masa.servux.settings.IServuxSetting;
import fi.dy.masa.servux.settings.IServuxSettingCallback;
import fi.dy.masa.servux.settings.ServuxBoolSetting;
import fi.dy.masa.servux.settings.ServuxIntSetting;
import fi.dy.masa.servux.settings.ServuxStringListSetting;
import fi.dy.masa.servux.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;

public class HudDataProvider
extends DataProviderBase {
    public static final HudDataProvider INSTANCE = new HudDataProvider();
    protected static final ServuxHudHandler<ServuxHudPacket.Payload> HANDLER = ServuxHudHandler.getInstance();
    protected final CompoundTag metadata = new CompoundTag();
    private final ServuxIntSetting permissionLevel = new ServuxIntSetting((IDataProvider)this, "permission_level", 0, 4, 0);
    private final ServuxIntSetting updateInterval = new ServuxIntSetting((IDataProvider)this, "update_interval", 40, 300, 20);
    private final ServuxBoolSetting shareWeatherStatus = new ServuxBoolSetting(this, "share_weather_status", false);
    private final ServuxIntSetting weatherPermissionLevel = new ServuxIntSetting((IDataProvider)this, "weather_permission_level", 0, 4, 0);
    private final ServuxBoolSetting shareSeed = new ServuxBoolSetting(this, "share_seed", false);
    private final ServuxIntSetting seedPermissionLevel = new ServuxIntSetting((IDataProvider)this, "seed_permission_level", 2, 4, 0);
    private final ServuxBoolSetting loggersEnabled = new ServuxBoolSetting(this, "loggers_enabled", false, new BoolCallback());
    private final ServuxStringListSetting loggersEnableList = new ServuxStringListSetting(this, "loggers_enable_list", this.getDefaultLoggers(), new StringListCallback());
    private final ServuxIntSetting loggerPermissionLevel = new ServuxIntSetting((IDataProvider)this, "logger_permission_level", 0, 4, 0);
    private final List<IServuxSetting<?>> settings = List.of(this.permissionLevel, this.updateInterval, this.shareWeatherStatus, this.weatherPermissionLevel, this.shareSeed, this.seedPermissionLevel, this.loggersEnabled, this.loggersEnableList, this.loggerPermissionLevel);
    private GlobalPos spawnPos = new GlobalPos(Level.OVERWORLD, BlockPos.ZERO);
    private long worldSeed = 0L;
    private int clearWeatherTime = -1;
    private int rainWeatherTime = -1;
    private int thunderWeatherTime = -1;
    private boolean isRaining;
    private boolean isThundering;
    private long lastTick;
    private long lastWeatherTick;
    private boolean refreshSpawnMetadata;
    private boolean refreshWeatherData;
    private final List<UUID> invalidPlayers = new ArrayList<UUID>();
    private final HashMap<UUID, List<DataLogger>> loggerPlayers = new HashMap();
    private final HashMap<DataLogger, DataLoggerBase<?>> LOGGERS = new HashMap();
    private final HashMap<DataLogger, Tag> DATA = new HashMap();

    protected HudDataProvider() {
        super("hud_data", ServuxHudHandler.CHANNEL_ID, 2, 0, "servux.provider.hud_data", "MiniHUD Meta Data provider for various Server-Side information");
        this.metadata.putString("name", this.getName());
        this.metadata.putString("id", this.getNetworkChannel().toString());
        this.metadata.putInt("version", this.getProtocolVersion());
        this.metadata.putString("servux", Reference.MOD_STRING);
        this.metadata.putString("spawnDimension", this.getSpawnPos().dimension().location().toString());
        this.metadata.putInt("spawnPosX", this.getSpawnPos().pos().getX());
        this.metadata.putInt("spawnPosY", this.getSpawnPos().pos().getY());
        this.metadata.putInt("spawnPosZ", this.getSpawnPos().pos().getZ());
        this.checkIfLoggersAreInitialized();
    }

    private List<String> getDefaultLoggers() {
        ArrayList<String> list = new ArrayList<String>();
        for (DataLogger type : DataLogger.VALUES) {
            list.add(type.getSerializedName());
        }
        return list;
    }

    private void resetLoggersFromConfig() {
        if (this.isLoggersEnabled()) {
            this.loggersEnabled.setValueNoCallback(false);
            this.checkIfLoggersAreInitialized();
            this.loggersEnabled.setValueNoCallback(true);
        } else {
            this.checkIfLoggersAreInitialized();
        }
    }

    @Override
    public List<IServuxSetting<?>> getSettings() {
        return this.settings;
    }

    @Override
    public void registerHandler() {
        ServerPlayHandler.getInstance().registerServerPlayHandler(HANDLER);
        if (!this.isRegistered()) {
            HANDLER.registerPlayPayload(ServuxHudPacket.Payload.ID, ServuxHudPacket.Payload.CODEC, 3);
            this.setRegistered(true);
        }
        HANDLER.registerPlayReceiver(ServuxHudPacket.Payload.ID, (ServerPlayNetworking.PlayPayloadHandler<ServuxHudPacket.Payload>)((ServerPlayNetworking.PlayPayloadHandler)HANDLER::receivePlayPayload));
    }

    @Override
    public void unregisterHandler() {
        HANDLER.unregisterPlayReceiver();
        ServerPlayHandler.getInstance().unregisterServerPlayHandler(HANDLER);
    }

    @Override
    public IPluginServerPlayHandler<?> getPacketHandler() {
        return HANDLER;
    }

    @Override
    public boolean isPlayerRegistered(ServerPlayer player) {
        return !this.isPlayerInvalid(player);
    }

    @Override
    public boolean shouldTick() {
        return this.enabled;
    }

    @Override
    public void tick(MinecraftServer server, int tickCounter, ProfilerFiller profiler) {
        if (!this.isEnabled()) {
            return;
        }
        List playerList = server.getPlayerList().getPlayers();
        if (tickCounter % (Integer)this.updateInterval.getValue() == 0) {
            profiler.push(this.getName() + "_tick_weather");
            this.lastTick = tickCounter;
            if (this.worldSeed == 0L) {
                this.checkWorldSeed(server);
            } else if (!((Boolean)this.shareSeed.getValue()).booleanValue()) {
                this.setWorldSeed(0L);
            }
            profiler.popPush(this.getName() + "_weather_players");
            for (ServerPlayer player : playerList) {
                if (this.isPlayerInvalid(player)) continue;
                if (this.shouldRefreshWeatherData()) {
                    this.refreshWeatherData(player, null);
                }
                if (!this.shouldRefreshSpawnMetadata()) continue;
                this.refreshSpawnMetadata(player, null);
            }
            if (this.shouldRefreshWeatherData()) {
                this.lastWeatherTick = tickCounter;
                this.setRefreshWeatherDataComplete();
            }
            if (this.shouldRefreshSpawnMetadata()) {
                this.setRefreshSpawnMetadataComplete();
            }
            profiler.pop();
        }
        this.checkIfLoggersAreInitialized();
        if (this.isLoggersEnabled()) {
            profiler.push(this.getName() + "_tick_loggers");
            this.tickLoggers(server);
            profiler.popPush(this.getName() + "_logger_players");
            for (ServerPlayer player : playerList) {
                this.tickLoggerPlayer(player);
            }
            profiler.pop();
        }
    }

    private void setPlayerInvalid(ServerPlayer player) {
        if (!this.invalidPlayers.contains(player.getUUID())) {
            this.invalidPlayers.add(player.getUUID());
        }
    }

    private boolean isPlayerInvalid(ServerPlayer player) {
        return this.invalidPlayers.contains(player.getUUID());
    }

    private void removeInvalidPlayer(ServerPlayer player) {
        this.invalidPlayers.remove(player.getUUID());
    }

    public void tickWeather(int clearTime, int rainTime, int thunderTime, boolean isRaining, boolean isThunder) {
        if (!this.isEnabled()) {
            return;
        }
        this.clearWeatherTime = clearTime;
        this.rainWeatherTime = rainTime;
        this.thunderWeatherTime = thunderTime;
        this.isRaining = isRaining;
        this.isThundering = isThunder;
        if (this.lastTick - this.lastWeatherTick > (long)this.getTickInterval()) {
            this.refreshWeatherData = true;
        }
    }

    private void checkIfLoggersAreInitialized() {
        if (this.isLoggersEnabled()) {
            if (!this.metadata.contains("Loggers")) {
                this.metadata.put("Loggers", (Tag)this.putEnabledLoggers());
            }
            this.setTickRate(15);
            if (this.LOGGERS.isEmpty()) {
                this.initializeLoggers();
            }
        } else {
            if (this.metadata.contains("Loggers")) {
                this.metadata.remove("Loggers");
            }
            if (!this.LOGGERS.isEmpty()) {
                this.LOGGERS.clear();
            }
            this.setTickRate(40);
            if (!this.DATA.isEmpty()) {
                this.DATA.clear();
            }
        }
    }

    private CompoundTag putEnabledLoggers() {
        CompoundTag nbt = new CompoundTag();
        this.validateLoggerListConfig();
        for (DataLogger type : DataLogger.VALUES) {
            nbt.putBoolean(type.getSerializedName(), this.isLoggerTypeEnabled(type));
        }
        return nbt;
    }

    private void validateLoggerListConfig() {
        List list = (List)this.loggersEnableList.getValue();
        ArrayList<String> safeList = new ArrayList<String>();
        boolean dirty = false;
        for (String entry : list) {
            DataLogger type = DataLogger.fromStringStatic(entry);
            if (type == null) {
                Servux.LOGGER.warn("validateLoggerListConfig: Removing invalid logger type: '{}'", (Object)entry);
                dirty = true;
                continue;
            }
            safeList.add(entry);
        }
        if (dirty) {
            this.loggersEnableList.setValueNoCallback(safeList);
        }
    }

    private boolean isLoggerTypeEnabled(DataLogger type) {
        return ((List)this.loggersEnableList.getValue()).contains(type.getSerializedName());
    }

    private void initializeLoggers() {
        if (this.LOGGERS.isEmpty()) {
            for (DataLogger type : DataLogger.VALUES) {
                DataLoggerBase<?> entry;
                if (!this.isLoggerTypeEnabled(type) || (entry = type.init()) == null) continue;
                this.LOGGERS.put(type, entry);
            }
        }
    }

    private void tickLoggers(MinecraftServer server) {
        this.DATA.clear();
        if (!this.isLoggersEnabled()) {
            return;
        }
        this.LOGGERS.forEach((type, logger) -> this.DATA.put((DataLogger)((Object)type), (Tag)logger.getResult(server)));
    }

    private void tickLoggerPlayer(ServerPlayer player) {
        List<DataLogger> list;
        if (!this.isLoggersEnabled()) {
            return;
        }
        UUID uuid = player.getUUID();
        if (this.loggerPlayers.containsKey(uuid) && !(list = this.loggerPlayers.get(uuid)).isEmpty()) {
            CompoundTag nbt = new CompoundTag();
            for (DataLogger type : list) {
                if (!this.DATA.containsKey((Object)type)) continue;
                nbt.put(type.getSerializedName(), this.DATA.get((Object)type));
            }
            HANDLER.encodeServerData(player, ServuxHudPacket.DataLoggerTick(nbt));
        }
    }

    public void sendMetadata(ServerPlayer player) {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.hasPermission(player)) {
            Servux.debugLog("hud_service: Denying access for player {}, Insufficient Permissions", player.getName().tryCollapseToString());
            return;
        }
        this.removeInvalidPlayer(player);
        CompoundTag nbt = new CompoundTag();
        nbt.merge(this.metadata);
        if (!this.hasPermissionsForSeed(player) && nbt.contains("worldSeed")) {
            nbt.remove("worldSeed");
        }
        Servux.debugLog("hudDataChannel: sendMetadata to player {}", player.getName().tryCollapseToString());
        if (player.connection != null) {
            HANDLER.sendPlayPayload(player.connection, new ServuxHudPacket.Payload(ServuxHudPacket.MetadataResponse(this.metadata)));
        } else {
            HANDLER.sendPlayPayload(player, new ServuxHudPacket.Payload(ServuxHudPacket.MetadataResponse(this.metadata)));
        }
    }

    public void refreshLoggers(ServerPlayer player, @Nonnull CompoundTag nbt) {
        if (!this.hasPermissionsForLoggers(player)) {
            player.sendSystemMessage((Component)StringUtils.translate("servux.hud_data.error.insufficient_for_loggers", "any"));
            return;
        }
        if (!nbt.isEmpty()) {
            ArrayList<DataLogger> list = new ArrayList<DataLogger>();
            UUID uuid = player.getUUID();
            for (String key : nbt.keySet()) {
                DataLogger type = DataLogger.fromStringStatic(key);
                boolean enable = nbt.getBooleanOr(key, false);
                if (type == null) continue;
                if (this.hasPermissionsForLogger(player, key) && enable) {
                    list.add(type);
                    continue;
                }
                if (!enable) continue;
                player.sendSystemMessage((Component)StringUtils.translate("servux.hud_data.error.insufficient_for_loggers", key));
            }
            if (!list.isEmpty()) {
                this.loggerPlayers.put(uuid, list);
            } else {
                this.loggerPlayers.remove(uuid);
            }
        }
    }

    public void onPacketFailure(ServerPlayer player) {
        this.setPlayerInvalid(player);
        this.removePlayerLoggers(player);
    }

    public void removePlayer(ServerPlayer player) {
        this.removeInvalidPlayer(player);
        this.removePlayerLoggers(player);
    }

    private void removePlayerLoggers(ServerPlayer player) {
        this.loggerPlayers.remove(player.getUUID());
    }

    public void refreshSpawnMetadata(ServerPlayer player, @Nullable CompoundTag data) {
        if (!this.isEnabled()) {
            return;
        }
        GlobalPos spawnPos = INSTANCE.getSpawnPos();
        CompoundTag nbt = new CompoundTag();
        nbt.putString("id", this.getNetworkChannel().toString());
        nbt.putString("servux", Reference.MOD_STRING);
        nbt.putInt("version", this.getProtocolVersion());
        nbt.putString("spawnDimension", spawnPos.dimension().location().toString());
        nbt.putInt("spawnPosX", spawnPos.pos().getX());
        nbt.putInt("spawnPosY", spawnPos.pos().getY());
        nbt.putInt("spawnPosZ", spawnPos.pos().getZ());
        if (((Boolean)this.shareSeed.getValue()).booleanValue() && this.hasPermissionsForSeed(player)) {
            Servux.debugLog("refreshSpawnMetadata() player [{}] has seedPermissions.", player.getName().tryCollapseToString());
            nbt.putLong("worldSeed", this.worldSeed);
        } else {
            Servux.debugLog("refreshSpawnMetadata() player [{}] does not have seedPermissions.", player.getName().tryCollapseToString());
        }
        HANDLER.encodeServerData(player, ServuxHudPacket.SpawnResponse(nbt));
    }

    public void refreshWeatherData(ServerPlayer player, @Nullable CompoundTag data) {
        if (!this.hasPermissionsForWeather(player) || !this.isEnabled()) {
            return;
        }
        CompoundTag nbt = new CompoundTag();
        nbt.putString("id", this.getNetworkChannel().toString());
        nbt.putString("servux", Reference.MOD_STRING);
        if (this.isRaining && this.rainWeatherTime > -1) {
            nbt.putInt("SetRaining", this.rainWeatherTime);
            nbt.putBoolean("isRaining", true);
        } else {
            nbt.putBoolean("isRaining", false);
        }
        if (this.isThundering && this.thunderWeatherTime > -1) {
            nbt.putInt("SetThundering", this.thunderWeatherTime);
            nbt.putBoolean("isThundering", true);
        } else {
            nbt.putBoolean("isThundering", false);
        }
        if (this.clearWeatherTime > -1) {
            nbt.putInt("SetClear", this.clearWeatherTime);
        }
        HANDLER.encodeServerData(player, ServuxHudPacket.WeatherTick(nbt));
    }

    public void refreshRecipeManager(ServerPlayer player, @Nullable CompoundTag data) {
        if (!this.hasPermission(player)) {
            return;
        }
        ServerLevel world = player.level();
        Collection recipes = world.recipeAccess().getRecipes();
        CompoundTag nbt = new CompoundTag();
        ListTag list = new ListTag();
        if (data != null) {
            Servux.debugLog("hudDataChannel: received RecipeManager request from {}, client version: {}", player.getName().tryCollapseToString(), data.getStringOr("version", "?"));
        }
        recipes.forEach(recipeEntry -> {
            DataResult dr = Recipe.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)recipeEntry.value());
            if (dr.result().isPresent()) {
                CompoundTag entry = new CompoundTag();
                entry.putString("id_reg", recipeEntry.id().registry().toString());
                entry.putString("id_value", recipeEntry.id().location().toString());
                entry.put("recipe", (Tag)dr.result().get());
                list.add((Object)entry);
            }
        });
        nbt.put("RecipeManager", (Tag)list);
        HANDLER.encodeServerData(player, ServuxHudPacket.ResponseS2CStart(nbt));
    }

    public GlobalPos getSpawnPos() {
        if (this.spawnPos == null) {
            this.setSpawnPos(new GlobalPos(ServerLevel.OVERWORLD, BlockPos.ZERO));
        }
        return this.spawnPos;
    }

    public String getSpawnPosAsString() {
        GlobalPos pos = this.getSpawnPos();
        return String.format("[%s: %d, %d, %d]", pos.dimension().location().toString(), pos.pos().getX(), pos.pos().getY(), pos.pos().getZ());
    }

    public String getSpawnPosAsString(GlobalPos pos) {
        return String.format("[%s: %d, %d, %d]", pos.dimension().location().toString(), pos.pos().getX(), pos.pos().getY(), pos.pos().getZ());
    }

    public void setSpawnPos(GlobalPos spawnPos) {
        if (!this.spawnPos.equals((Object)spawnPos)) {
            this.metadata.remove("spawnDimension");
            this.metadata.remove("spawnPosX");
            this.metadata.remove("spawnPosY");
            this.metadata.remove("spawnPosZ");
            this.metadata.putString("spawnDimension", spawnPos.dimension().location().toString());
            this.metadata.putInt("spawnPosX", spawnPos.pos().getX());
            this.metadata.putInt("spawnPosY", spawnPos.pos().getY());
            this.metadata.putInt("spawnPosZ", spawnPos.pos().getZ());
            this.refreshSpawnMetadata = true;
            Servux.debugLog("setSpawnPos(): updating World Spawn [{}] -> [{}]", this.getSpawnPosAsString(), this.getSpawnPosAsString(spawnPos));
        }
        this.spawnPos = spawnPos;
    }

    public boolean shouldRefreshSpawnMetadata() {
        return this.refreshSpawnMetadata;
    }

    public void setRefreshSpawnMetadataComplete() {
        this.refreshSpawnMetadata = false;
        Servux.debugLog("setRefreshSpawnMetadataComplete()", new Object[0]);
    }

    public boolean shouldRefreshWeatherData() {
        return this.refreshWeatherData;
    }

    public void setRefreshWeatherDataComplete() {
        this.refreshWeatherData = false;
    }

    public long getWorldSeed() {
        return this.worldSeed;
    }

    public void setWorldSeed(long seed) {
        if (this.worldSeed != seed) {
            if (((Boolean)this.shareSeed.getValue()).booleanValue()) {
                this.metadata.remove("worldSeed");
                this.metadata.putLong("worldSeed", seed);
                this.refreshSpawnMetadata = true;
            }
            Servux.debugLog("setWorldSeed(): updating World Seed [{}] -> [{}]", this.worldSeed, seed);
        }
        this.worldSeed = seed;
    }

    public void checkWorldSeed(MinecraftServer server) {
        ServerLevel world;
        if (((Boolean)this.shareSeed.getValue()).booleanValue() && (world = server.overworld()) != null) {
            this.setWorldSeed(world.getSeed());
        }
    }

    public boolean isLoggersEnabled() {
        return (Boolean)this.loggersEnabled.getValue();
    }

    public boolean hasPermissionsForWeather(ServerPlayer player) {
        return Permissions.check((Entity)player, (String)(this.permNode + ".weather"), (int)((Integer)this.weatherPermissionLevel.getValue()));
    }

    public boolean hasPermissionsForSeed(ServerPlayer player) {
        return Permissions.check((Entity)player, (String)(this.permNode + ".seed"), (int)((Integer)this.seedPermissionLevel.getValue()));
    }

    public boolean hasPermissionsForLoggers(ServerPlayer player) {
        return Permissions.check((Entity)player, (String)(this.permNode + ".logger"), (int)((Integer)this.loggerPermissionLevel.getValue()));
    }

    public boolean hasPermissionsForLogger(ServerPlayer player, String type) {
        return Permissions.check((Entity)player, (String)(this.permNode + ".logger." + type), (int)((Integer)this.loggerPermissionLevel.getValue()));
    }

    @Override
    public boolean hasPermission(ServerPlayer player) {
        return Permissions.check((Entity)player, (String)this.permNode, (int)((Integer)this.permissionLevel.getValue()));
    }

    @Override
    public void onTickEndPre() {
    }

    @Override
    public void onTickEndPost() {
    }

    public static class BoolCallback
    implements IServuxSettingCallback<Boolean> {
        @Override
        public void onValueChanged(IServuxSetting<Boolean> setting, Boolean oldValue, Boolean value) {
            INSTANCE.resetLoggersFromConfig();
        }
    }

    public static class StringListCallback
    implements IServuxSettingCallback<List<String>> {
        @Override
        public void onValueChanged(IServuxSetting<List<String>> setting, List<String> oldValue, List<String> value) {
            INSTANCE.resetLoggersFromConfig();
        }
    }
}

