/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.dataproviders;

import fi.dy.masa.servux.Reference;
import fi.dy.masa.servux.Servux;
import fi.dy.masa.servux.dataproviders.DataProviderBase;
import fi.dy.masa.servux.dataproviders.IDataProvider;
import fi.dy.masa.servux.network.IPluginServerPlayHandler;
import fi.dy.masa.servux.network.ServerPlayHandler;
import fi.dy.masa.servux.network.packet.ServuxTweaksHandler;
import fi.dy.masa.servux.network.packet.ServuxTweaksPacket;
import fi.dy.masa.servux.settings.IServuxSetting;
import fi.dy.masa.servux.settings.IServuxSettingCallback;
import fi.dy.masa.servux.settings.ServuxBoolSetting;
import fi.dy.masa.servux.settings.ServuxIntSetting;
import fi.dy.masa.servux.util.InventoryUtils;
import fi.dy.masa.servux.util.nbt.NbtView;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TweaksDataProvider
extends DataProviderBase {
    public static final TweaksDataProvider INSTANCE = new TweaksDataProvider();
    private static final ServuxTweaksHandler<ServuxTweaksPacket.Payload> HANDLER = ServuxTweaksHandler.getInstance();
    private final CompoundTag metadata = new CompoundTag();
    private final BoolCallbacks boolCallback = new BoolCallbacks();
    private final IntCallbacks intCallback = new IntCallbacks();
    private final ServuxIntSetting permissionLevel = new ServuxIntSetting((IDataProvider)this, "permission_level", 0, 4, 0, (IServuxSettingCallback<Integer>)this.intCallback);
    private final ServuxIntSetting updateInterval = new ServuxIntSetting((IDataProvider)this, "update_interval", 120, 1200, 40, (IServuxSettingCallback<Integer>)this.intCallback);
    private final ServuxBoolSetting stackableShulkers = new ServuxBoolSetting(this, "stackable_shulkers", false, this.boolCallback);
    private final ServuxIntSetting stackableShulkersSize = new ServuxIntSetting((IDataProvider)this, "stackable_shulkers_count", 64, 99, 1, (IServuxSettingCallback<Integer>)this.intCallback);
    private final ServuxBoolSetting stackableShulkersFix = new ServuxBoolSetting(this, "stackable_shulkers_fix", true, this.boolCallback);
    private final List<IServuxSetting<?>> settings = List.of(this.permissionLevel, this.updateInterval, this.stackableShulkers, this.stackableShulkersSize, this.stackableShulkersFix);
    private final List<UUID> invalidPlayers = new ArrayList<UUID>();
    private boolean configDirty = false;

    protected TweaksDataProvider() {
        super("tweaks_data", ServuxTweaksHandler.CHANNEL_ID, 1, 0, "servux.provider.tweaks_data", "Tweaks Data provider for Client Side mods.");
        this.metadata.putString("name", this.getName());
        this.metadata.putString("id", this.getNetworkChannel().toString());
        this.metadata.putInt("version", this.getProtocolVersion());
        this.metadata.putString("servux", Reference.MOD_STRING);
        this.setTickRate(40);
        this.checkTweaksMetadata();
    }

    @Override
    public List<IServuxSetting<?>> getSettings() {
        return this.settings;
    }

    @Override
    public void registerHandler() {
        ServerPlayHandler.getInstance().registerServerPlayHandler(HANDLER);
        if (!this.isRegistered()) {
            HANDLER.registerPlayPayload(ServuxTweaksPacket.Payload.ID, ServuxTweaksPacket.Payload.CODEC, 3);
            this.setRegistered(true);
        }
        HANDLER.registerPlayReceiver(ServuxTweaksPacket.Payload.ID, (ServerPlayNetworking.PlayPayloadHandler<ServuxTweaksPacket.Payload>)((ServerPlayNetworking.PlayPayloadHandler)HANDLER::receivePlayPayload));
    }

    @Override
    public void unregisterHandler() {
        HANDLER.unregisterPlayReceiver();
        ServerPlayHandler.getInstance().unregisterServerPlayHandler(HANDLER);
    }

    @Override
    public boolean shouldTick() {
        return this.isEnabled();
    }

    @Override
    public void tick(MinecraftServer server, int tickCounter, ProfilerFiller profiler) {
        if (!this.isEnabled()) {
            return;
        }
        if (tickCounter % (Integer)this.updateInterval.getValue() == 0) {
            profiler.push(this.getName());
            if (this.configDirty) {
                this.updateAllTweaks(server);
                this.configDirty = false;
            }
            profiler.pop();
        }
    }

    @Override
    public IPluginServerPlayHandler<?> getPacketHandler() {
        return HANDLER;
    }

    @Override
    public boolean isPlayerRegistered(ServerPlayer player) {
        return !this.isPlayerInvalid(player);
    }

    private void checkTweaksMetadata() {
        if (this.shouldEmptyShulkersStack()) {
            this.metadata.putBoolean("stackingShulkers", this.shouldEmptyShulkersStack());
            this.metadata.putInt("stackingShulkersMax", ((Integer)this.stackableShulkersSize.getValue()).intValue());
        } else {
            if (this.metadata.contains("stackingShulkers")) {
                this.metadata.remove("stackingShulkers");
            }
            if (this.metadata.contains("stackingShulkersMax")) {
                this.metadata.remove("stackingShulkersMax");
            }
        }
    }

    public void updateAllTweaks(MinecraftServer server) {
        Servux.debugLog("tweaksData: Invoke updateAllTweaks()", new Object[0]);
        List players = server.getPlayerList().getPlayers();
        this.checkTweaksMetadata();
        for (ServerPlayer player : players) {
            if (!this.isPlayerRegistered(player)) continue;
            this.sendMetadata(player);
        }
    }

    public void sendMetadata(ServerPlayer player) {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.hasPermission(player)) {
            Servux.debugLog("tweaks_service: Denying access for player {}, Insufficient Permissions", player.getName().tryCollapseToString());
            return;
        }
        Servux.debugLog("tweaksDataChannel: sendMetadata to player {}", player.getName().tryCollapseToString());
        this.checkTweaksMetadata();
        if (player.connection != null) {
            HANDLER.sendPlayPayload(player.connection, new ServuxTweaksPacket.Payload(ServuxTweaksPacket.MetadataResponse(this.metadata)));
        } else {
            HANDLER.sendPlayPayload(player, new ServuxTweaksPacket.Payload(ServuxTweaksPacket.MetadataResponse(this.metadata)));
        }
    }

    public void onPacketFailure(ServerPlayer player) {
        this.setPlayerInvalid(player);
    }

    public void removePlayer(ServerPlayer player) {
        this.removeInvalidPlayer(player);
    }

    private void setPlayerInvalid(ServerPlayer player) {
        if (!this.invalidPlayers.contains(player.getUUID())) {
            this.invalidPlayers.add(player.getUUID());
        }
    }

    private boolean isPlayerInvalid(ServerPlayer player) {
        return this.invalidPlayers.contains(player.getUUID());
    }

    private void removeInvalidPlayer(ServerPlayer player) {
        this.invalidPlayers.remove(player.getUUID());
    }

    public void onBlockEntityRequest(ServerPlayer player, BlockPos pos) {
        if (!this.hasPermission(player) || !this.isEnabled()) {
            return;
        }
        BlockEntity be = player.level().getBlockEntity(pos);
        CompoundTag nbt = be != null ? be.saveWithoutMetadata((HolderLookup.Provider)player.registryAccess()) : new CompoundTag();
        HANDLER.encodeServerData(player, ServuxTweaksPacket.SimpleBlockResponse(pos, nbt));
    }

    public void onEntityRequest(ServerPlayer player, int entityId) {
        if (!this.hasPermission(player)) {
            return;
        }
        Entity entity = player.level().getEntity(entityId);
        if (entity != null) {
            NbtView view = NbtView.getWriter(player.level().registryAccess());
            ResourceLocation id = EntityType.getKey((EntityType)entity.getType());
            entity.saveWithoutId(view.getWriter());
            CompoundTag nbt = view.readNbt();
            if (nbt != null && id != null) {
                nbt.putString("id", id.toString());
                HANDLER.encodeServerData(player, ServuxTweaksPacket.SimpleEntityResponse(entityId, nbt.copy()));
            }
        }
    }

    public boolean shouldEmptyShulkersStack() {
        return (Boolean)this.stackableShulkers.getValue();
    }

    public boolean isStackableShulkersFixActive() {
        return this.shouldEmptyShulkersStack() && (Boolean)this.stackableShulkersFix.getValue() != false;
    }

    public int defaultEmptyShulkersMaxCount() {
        if (this.shouldEmptyShulkersStack()) {
            return (Integer)this.stackableShulkersSize.getValue();
        }
        return 1;
    }

    public int getEmptyShulkersMaxCount(ItemStack stack) {
        if (this.shouldEmptyShulkersStack() && InventoryUtils.isShulkerBox(stack)) {
            return this.defaultEmptyShulkersMaxCount();
        }
        return (Integer)stack.getComponents().getOrDefault(DataComponents.MAX_STACK_SIZE, (Object)1);
    }

    @Override
    public boolean hasPermission(ServerPlayer player) {
        return Permissions.check((Entity)player, (String)this.permNode, (int)((Integer)this.permissionLevel.getValue()));
    }

    @Override
    public void onTickEndPre() {
    }

    @Override
    public void onTickEndPost() {
    }

    public static class BoolCallbacks
    implements IServuxSettingCallback<Boolean> {
        @Override
        public void onValueChanged(IServuxSetting<Boolean> setting, Boolean oldValue, Boolean value) {
            Servux.debugLog("Config Change detected; {}:{}", setting.dataProvider().getName(), setting.name());
            TweaksDataProvider.INSTANCE.configDirty = true;
        }
    }

    public static class IntCallbacks
    implements IServuxSettingCallback<Integer> {
        @Override
        public void onValueChanged(IServuxSetting<Integer> setting, Integer oldValue, Integer value) {
            Servux.debugLog("Config Change detected; {}:{}", setting.dataProvider().getName(), setting.name());
            TweaksDataProvider.INSTANCE.configDirty = true;
        }
    }
}

