/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.loggers;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import fi.dy.masa.servux.loggers.DataLoggerBase;
import fi.dy.masa.servux.loggers.DataLoggerMobCaps;
import fi.dy.masa.servux.loggers.DataLoggerTPS;
import fi.dy.masa.servux.loggers.DataLoggerType;
import javax.annotation.Nullable;
import net.minecraft.util.StringRepresentable;

public enum DataLogger implements StringRepresentable
{
    TPS("tps", DataLoggerType.TPS, DataLoggerTPS.CODEC),
    MOB_CAPS("mob_caps", DataLoggerType.MOB_CAPS, DataLoggerMobCaps.CODEC);

    public static final StringRepresentable.EnumCodec<DataLogger> CODEC;
    public static final ImmutableList<DataLogger> VALUES;
    private final String name;
    private final DataLoggerType<?> type;
    private final Codec<?> codec;

    private DataLogger(String name, DataLoggerType<?> type, Codec<?> codec) {
        this.name = name;
        this.type = type;
        this.codec = codec;
    }

    public String getSerializedName() {
        return this.name;
    }

    @Nullable
    public DataLoggerBase<?> init() {
        return this.type.init(this);
    }

    public Codec<?> codec() {
        return this.codec;
    }

    @Nullable
    public static DataLogger fromStringStatic(String name) {
        for (DataLogger type : VALUES) {
            if (!type.name.equalsIgnoreCase(name)) continue;
            return type;
        }
        return null;
    }

    static {
        CODEC = StringRepresentable.fromEnum(DataLogger::values);
        VALUES = ImmutableList.copyOf((Object[])DataLogger.values());
    }
}

