/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.loggers;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import fi.dy.masa.servux.loggers.DataLogger;
import fi.dy.masa.servux.loggers.DataLoggerBase;
import fi.dy.masa.servux.loggers.data.TPSData;
import fi.dy.masa.servux.mixin.server.IMixinServerTickManager;
import java.util.concurrent.TimeUnit;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerTickRateManager;

public class DataLoggerTPS
extends DataLoggerBase<CompoundTag> {
    public static final Codec<CompoundTag> CODEC = CompoundTag.CODEC;

    public DataLoggerTPS(DataLogger type) {
        super(type);
    }

    @Override
    public CompoundTag getResult(MinecraftServer server) {
        try {
            return (CompoundTag)TPSData.CODEC.encodeStart((DynamicOps)server.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.build(server)).getOrThrow();
        }
        catch (Exception e) {
            return new CompoundTag();
        }
    }

    private TPSData build(MinecraftServer server) {
        ServerTickRateManager tickManager = server.tickRateManager();
        boolean frozen = tickManager.isFrozen();
        boolean sprinting = tickManager.isSprinting();
        double mspt = (double)server.getAverageTickTimeNanos() / (double)TimeUnit.MILLISECONDS.toNanos(1L);
        double tps = 1000.0 / Math.max(sprinting ? 0.0 : (double)tickManager.millisecondsPerTick(), mspt);
        if (frozen) {
            tps = 0.0;
        }
        return new TPSData(mspt, tps, ((IMixinServerTickManager)tickManager).servux_getStringTicks(), frozen, sprinting, tickManager.isSteppingForward());
    }
}

