/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.mixin.server;

import com.llamalad7.mixinextras.sugar.Local;
import fi.dy.masa.servux.dataproviders.DataProviderManager;
import fi.dy.masa.servux.dataproviders.HudDataProvider;
import fi.dy.masa.servux.event.ServerHandler;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MinecraftServer.class})
public abstract class MixinMinecraftServer {
    @Shadow
    private int tickCount;

    @Shadow
    public abstract ResourceManager getResourceManager();

    @Shadow
    public abstract GlobalPos selectLevelLoadFocusPos();

    @Inject(method={"tickServer(Ljava/util/function/BooleanSupplier;)V"}, at={@At(value="RETURN", ordinal=1)})
    private void servux_onTickEnd(BooleanSupplier supplier, CallbackInfo ci, @Local ProfilerFiller profiler) {
        profiler.push("servux_tick");
        DataProviderManager.INSTANCE.tickProviders((MinecraftServer)this, this.tickCount, profiler);
        profiler.pop();
    }

    @Inject(method={"prepareLevels()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;updateMobSpawningFlags()V", shift=At.Shift.BEFORE)})
    private void servux_onPrepareStartRegion(CallbackInfo ci) {
        if (HudDataProvider.INSTANCE.isEnabled()) {
            HudDataProvider.INSTANCE.setSpawnPos(this.selectLevelLoadFocusPos());
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;initServer()Z")}, method={"runServer()V"})
    private void servux_onServerStarting(CallbackInfo ci) {
        ((ServerHandler)ServerHandler.getInstance()).onServerStarting((MinecraftServer)this);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;buildServerStatus()Lnet/minecraft/network/protocol/status/ServerStatus;", ordinal=0)}, method={"runServer()V"})
    private void servux_onServerStarted(CallbackInfo ci) {
        ((ServerHandler)ServerHandler.getInstance()).onServerStarted((MinecraftServer)this);
    }

    @Inject(method={"reloadResources(Ljava/util/Collection;)Ljava/util/concurrent/CompletableFuture;"}, at={@At(value="HEAD")})
    private void servux_startResourceReload(Collection<String> collection, CallbackInfoReturnable<CompletableFuture<Void>> cir) {
        ((ServerHandler)ServerHandler.getInstance()).onServerResourceReloadPre((MinecraftServer)this, this.getResourceManager());
    }

    @Inject(method={"reloadResources(Ljava/util/Collection;)Ljava/util/concurrent/CompletableFuture;"}, at={@At(value="TAIL")})
    private void servux_endResourceReload(Collection<String> collection, CallbackInfoReturnable<CompletableFuture<Void>> cir) {
        ((CompletableFuture)cir.getReturnValue()).handleAsync((value, throwable) -> {
            ((ServerHandler)ServerHandler.getInstance()).onServerResourceReloadPost((MinecraftServer)this, this.getResourceManager(), throwable == null);
            return value;
        }, (Executor)((MinecraftServer)this));
    }

    @Inject(at={@At(value="HEAD")}, method={"stopServer()V"})
    private void servux_onServerStopping(CallbackInfo info) {
        ((ServerHandler)ServerHandler.getInstance()).onServerStopping((MinecraftServer)this);
    }

    @Inject(at={@At(value="TAIL")}, method={"stopServer()V"})
    private void servux_onServerStopped(CallbackInfo info) {
        ((ServerHandler)ServerHandler.getInstance()).onServerStopped((MinecraftServer)this);
    }
}

