/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.schematic;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import fi.dy.masa.servux.Servux;
import fi.dy.masa.servux.dataproviders.DataProviderManager;
import fi.dy.masa.servux.dataproviders.LitematicsDataProvider;
import fi.dy.masa.servux.mixin.world.IMixinWorldTickScheduler;
import fi.dy.masa.servux.network.packet.ServuxLitematicaHandler;
import fi.dy.masa.servux.network.packet.ServuxLitematicaPacket;
import fi.dy.masa.servux.schematic.SchematicMetadata;
import fi.dy.masa.servux.schematic.container.ILitematicaBlockStatePalette;
import fi.dy.masa.servux.schematic.container.LitematicaBlockStateContainer;
import fi.dy.masa.servux.schematic.conversion.SchematicConversionMaps;
import fi.dy.masa.servux.schematic.placement.SchematicPlacement;
import fi.dy.masa.servux.schematic.placement.SubRegionPlacement;
import fi.dy.masa.servux.schematic.selection.AreaSelection;
import fi.dy.masa.servux.schematic.selection.Box;
import fi.dy.masa.servux.schematic.transmit.SchematicBufferManager;
import fi.dy.masa.servux.util.BlockUtils;
import fi.dy.masa.servux.util.EntityUtils;
import fi.dy.masa.servux.util.FileUtils;
import fi.dy.masa.servux.util.IntBoundingBox;
import fi.dy.masa.servux.util.ReplaceBehavior;
import fi.dy.masa.servux.util.SchematicPlacingUtils;
import fi.dy.masa.servux.util.WorldUtils;
import fi.dy.masa.servux.util.data.FileType;
import fi.dy.masa.servux.util.nbt.NbtView;
import fi.dy.masa.servux.util.position.PositionUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.ScheduledTick;
import net.minecraft.world.ticks.TickPriority;
import org.apache.commons.lang3.tuple.Pair;

public class LitematicaSchematic {
    public static final String FILE_EXTENSION = ".litematic";
    public static final int MINECRAFT_DATA_VERSION_1_12 = 1139;
    public static final int MINECRAFT_DATA_VERSION = SharedConstants.getCurrentVersion().dataVersion().version();
    public static final int SCHEMATIC_VERSION = 7;
    public static final int SCHEMATIC_VERSION_SUB = 1;
    public final Map<String, LitematicaBlockStateContainer> blockContainers = new HashMap<String, LitematicaBlockStateContainer>();
    public final Map<String, Map<BlockPos, CompoundTag>> tileEntities = new HashMap<String, Map<BlockPos, CompoundTag>>();
    public final Map<String, Map<BlockPos, ScheduledTick<Block>>> pendingBlockTicks = new HashMap<String, Map<BlockPos, ScheduledTick<Block>>>();
    public final Map<String, Map<BlockPos, ScheduledTick<Fluid>>> pendingFluidTicks = new HashMap<String, Map<BlockPos, ScheduledTick<Fluid>>>();
    public final Map<String, List<EntityInfo>> entities = new HashMap<String, List<EntityInfo>>();
    public final Map<String, BlockPos> subRegionPositions = new HashMap<String, BlockPos>();
    public final Map<String, BlockPos> subRegionSizes = new HashMap<String, BlockPos>();
    public final SchematicMetadata metadata = new SchematicMetadata();
    private int totalBlocksReadFromWorld;
    @Nullable
    private final Path schematicFile;
    private final FileType schematicType;

    public LitematicaSchematic(CompoundTag nbtCompound) throws CommandSyntaxException {
        this.readFromNBT(nbtCompound, false);
        this.schematicFile = Path.of("/", new String[0]);
        this.schematicType = FileType.LITEMATICA_SCHEMATIC;
    }

    private LitematicaSchematic(@Nullable Path file) {
        this(file, FileType.LITEMATICA_SCHEMATIC);
    }

    private LitematicaSchematic(@Nullable Path file, FileType schematicType) {
        this.schematicFile = file;
        this.schematicType = schematicType;
    }

    @Nullable
    public Path getFile() {
        return this.schematicFile;
    }

    public Vec3i getTotalSize() {
        return this.metadata.getEnclosingSize();
    }

    public int getTotalBlocksReadFromWorld() {
        return this.totalBlocksReadFromWorld;
    }

    public SchematicMetadata getMetadata() {
        return this.metadata;
    }

    public int getSubRegionCount() {
        return this.blockContainers.size();
    }

    @Nullable
    public BlockPos getSubRegionPosition(String areaName) {
        return this.subRegionPositions.get(areaName);
    }

    public Map<String, BlockPos> getAreaPositions() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String name : this.subRegionPositions.keySet()) {
            BlockPos pos = this.subRegionPositions.get(name);
            builder.put((Object)name, (Object)pos);
        }
        return builder.build();
    }

    public Map<String, BlockPos> getAreaSizes() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String name : this.subRegionSizes.keySet()) {
            BlockPos pos = this.subRegionSizes.get(name);
            builder.put((Object)name, (Object)pos);
        }
        return builder.build();
    }

    @Nullable
    public BlockPos getAreaSize(String regionName) {
        return this.subRegionSizes.get(regionName);
    }

    public Map<String, Box> getAreas() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String name : this.subRegionPositions.keySet()) {
            BlockPos pos = this.subRegionPositions.get(name);
            BlockPos posEndRel = PositionUtils.getRelativeEndPositionFromAreaSize((Vec3i)this.subRegionSizes.get(name));
            Box box = new Box(pos, pos.offset((Vec3i)posEndRel), name);
            builder.put((Object)name, (Object)box);
        }
        return builder.build();
    }

    @Nullable
    public static LitematicaSchematic createFromWorld(Level world, AreaSelection area, SchematicSaveInfo info, String author) {
        List<Box> boxes = PositionUtils.getValidBoxes(area);
        if (boxes.isEmpty()) {
            Servux.LOGGER.warn("createFromWorld: No Selection boxes.");
            return null;
        }
        LitematicaSchematic schematic = new LitematicaSchematic(Path.of("/", new String[0]));
        long time = System.currentTimeMillis();
        BlockPos origin = area.getEffectiveOrigin();
        schematic.setSubRegionPositions(boxes, origin);
        schematic.setSubRegionSizes(boxes);
        schematic.takeBlocksFromWorld(world, boxes, info);
        if (!info.ignoreEntities) {
            schematic.takeEntitiesFromWorld(world, boxes, origin);
        }
        schematic.metadata.setAuthor(author);
        schematic.metadata.setName(area.getName());
        schematic.metadata.setTimeCreated(time);
        schematic.metadata.setTimeModified(time);
        schematic.metadata.setRegionCount(boxes.size());
        schematic.metadata.setTotalVolume(PositionUtils.getTotalVolume(boxes));
        schematic.metadata.setEnclosingSize(PositionUtils.getEnclosingAreaSize(boxes));
        schematic.metadata.setTotalBlocks(schematic.totalBlocksReadFromWorld);
        schematic.metadata.setSchematicVersion(7);
        schematic.metadata.setMinecraftDataVersion(MINECRAFT_DATA_VERSION);
        schematic.metadata.setFileType(FileType.LITEMATICA_SCHEMATIC);
        return schematic;
    }

    public boolean placeToWorld(Level world, SchematicPlacement schematicPlacement, boolean notifyNeighbors) {
        return this.placeToWorld(world, schematicPlacement, notifyNeighbors, false);
    }

    public boolean placeToWorld(Level world, SchematicPlacement schematicPlacement, boolean notifyNeighbors, boolean ignoreEntities) {
        WorldUtils.setShouldPreventBlockUpdates(world, true);
        ImmutableMap<String, SubRegionPlacement> relativePlacements = schematicPlacement.getEnabledRelativeSubRegionPlacements();
        BlockPos origin = schematicPlacement.getOrigin();
        for (String regionName : relativePlacements.keySet()) {
            SubRegionPlacement placement = (SubRegionPlacement)relativePlacements.get((Object)regionName);
            if (!placement.isEnabled()) continue;
            BlockPos regionPos = placement.getPos();
            BlockPos regionSize = this.subRegionSizes.get(regionName);
            LitematicaBlockStateContainer container = this.blockContainers.get(regionName);
            Map<BlockPos, CompoundTag> tileMap = this.tileEntities.get(regionName);
            List<EntityInfo> entityList = this.entities.get(regionName);
            Map<BlockPos, ScheduledTick<Block>> scheduledBlockTicks = this.pendingBlockTicks.get(regionName);
            Map<BlockPos, ScheduledTick<Fluid>> scheduledFluidTicks = this.pendingFluidTicks.get(regionName);
            if (regionPos != null && regionSize != null && container != null && tileMap != null) {
                this.placeBlocksToWorld(world, origin, regionPos, regionSize, schematicPlacement, placement, container, tileMap, scheduledBlockTicks, scheduledFluidTicks, notifyNeighbors);
            } else {
                Servux.LOGGER.warn("Invalid/missing schematic data in schematic '{}' for sub-region '{}'", (Object)this.metadata.getName(), (Object)regionName);
            }
            if (ignoreEntities || schematicPlacement.ignoreEntities() || placement.ignoreEntities() || entityList == null) continue;
            this.placeEntitiesToWorld(world, origin, regionPos, regionSize, schematicPlacement, placement, entityList);
        }
        WorldUtils.setShouldPreventBlockUpdates(world, false);
        return true;
    }

    private boolean placeBlocksToWorld(Level world, BlockPos origin, BlockPos regionPos, BlockPos regionSize, SchematicPlacement schematicPlacement, SubRegionPlacement placement, LitematicaBlockStateContainer container, Map<BlockPos, CompoundTag> tileMap, @Nullable Map<BlockPos, ScheduledTick<Block>> scheduledBlockTicks, @Nullable Map<BlockPos, ScheduledTick<Fluid>> scheduledFluidTicks, boolean notifyNeighbors) {
        BlockPos posEndRelSub = PositionUtils.getRelativeEndPositionFromAreaSize((Vec3i)regionSize);
        BlockPos posEndRel = posEndRelSub.offset((Vec3i)regionPos);
        BlockPos posMinRel = PositionUtils.getMinCorner(regionPos, posEndRel);
        BlockPos regionPosTransformed = PositionUtils.getTransformedBlockPos(regionPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        BlockPos regionPosAbs = regionPosTransformed.offset((Vec3i)origin);
        int sizeX = Math.abs(regionSize.getX());
        int sizeY = Math.abs(regionSize.getY());
        int sizeZ = Math.abs(regionSize.getZ());
        BlockState barrier = Blocks.BARRIER.defaultBlockState();
        boolean ignoreInventories = false;
        BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos();
        ReplaceBehavior replace = ReplaceBehavior.ALL;
        Rotation rotationCombined = schematicPlacement.getRotation().getRotated(placement.getRotation());
        Mirror mirrorMain = schematicPlacement.getMirror();
        Mirror mirrorSub = placement.getMirror();
        if (mirrorSub != Mirror.NONE && (schematicPlacement.getRotation() == Rotation.CLOCKWISE_90 || schematicPlacement.getRotation() == Rotation.COUNTERCLOCKWISE_90)) {
            mirrorSub = mirrorSub == Mirror.FRONT_BACK ? Mirror.LEFT_RIGHT : Mirror.FRONT_BACK;
        }
        int bottomY = world.getMinY();
        int topY = world.getMaxY() + 1;
        int tmp = posMinRel.getY() - regionPos.getY() + regionPosTransformed.getY() + origin.getY();
        int startY = 0;
        int endY = sizeY;
        if (tmp < bottomY) {
            startY += bottomY - tmp;
        }
        if ((tmp = posMinRel.getY() - regionPos.getY() + regionPosTransformed.getY() + origin.getY() + (endY - 1)) > topY) {
            endY -= tmp - topY;
        }
        for (int y = startY; y < endY; ++y) {
            for (int z = 0; z < sizeZ; ++z) {
                for (int x = 0; x < sizeX; ++x) {
                    BlockEntity te;
                    BlockState state = container.get(x, y, z);
                    if (state.getBlock() == Blocks.STRUCTURE_VOID) continue;
                    posMutable.set(x, y, z);
                    CompoundTag teNBT = tileMap.get(posMutable);
                    posMutable.set(posMinRel.getX() + x - regionPos.getX(), posMinRel.getY() + y - regionPos.getY(), posMinRel.getZ() + z - regionPos.getZ());
                    BlockPos pos = PositionUtils.getTransformedPlacementPosition((BlockPos)posMutable, schematicPlacement, placement);
                    pos = pos.offset((Vec3i)regionPosTransformed).offset((Vec3i)origin);
                    BlockState stateOld = world.getBlockState(pos);
                    if (replace == ReplaceBehavior.NONE && !stateOld.isAir() || replace == ReplaceBehavior.WITH_NON_AIR && state.isAir()) continue;
                    if (mirrorMain != Mirror.NONE) {
                        state = state.mirror(mirrorMain);
                    }
                    if (mirrorSub != Mirror.NONE) {
                        state = state.mirror(mirrorSub);
                    }
                    if (rotationCombined != Rotation.NONE) {
                        state = state.rotate(rotationCombined);
                    }
                    if (stateOld == state && !state.hasBlockEntity()) continue;
                    BlockEntity teOld = world.getBlockEntity(pos);
                    if (teOld != null) {
                        if (teOld instanceof Container) {
                            ((Container)teOld).clearContent();
                        }
                        world.setBlock(pos, barrier, 20);
                    }
                    if (!world.setBlock(pos, state, 18) || teNBT == null || (te = world.getBlockEntity(pos)) == null) continue;
                    teNBT = teNBT.copy();
                    teNBT.putInt("x", pos.getX());
                    teNBT.putInt("y", pos.getY());
                    teNBT.putInt("z", pos.getZ());
                    try {
                        NbtView view = NbtView.getReader(teNBT, world.registryAccess());
                        te.loadWithComponents(view.getReader());
                        continue;
                    }
                    catch (Exception e) {
                        Servux.LOGGER.warn("Failed to load TileEntity data for {} @ {}", (Object)state, (Object)pos);
                    }
                }
            }
        }
        return true;
    }

    private void placeEntitiesToWorld(Level world, BlockPos origin, BlockPos regionPos, BlockPos regionSize, SchematicPlacement schematicPlacement, SubRegionPlacement placement, List<EntityInfo> entityList) {
        BlockPos regionPosRelTransformed = PositionUtils.getTransformedBlockPos(regionPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        int offX = regionPosRelTransformed.getX() + origin.getX();
        int offY = regionPosRelTransformed.getY() + origin.getY();
        int offZ = regionPosRelTransformed.getZ() + origin.getZ();
        Rotation rotationCombined = schematicPlacement.getRotation().getRotated(placement.getRotation());
        Mirror mirrorMain = schematicPlacement.getMirror();
        Mirror mirrorSub = placement.getMirror();
        if (mirrorSub != Mirror.NONE && (schematicPlacement.getRotation() == Rotation.CLOCKWISE_90 || schematicPlacement.getRotation() == Rotation.COUNTERCLOCKWISE_90)) {
            mirrorSub = mirrorSub == Mirror.FRONT_BACK ? Mirror.LEFT_RIGHT : Mirror.FRONT_BACK;
        }
        for (EntityInfo info : entityList) {
            Entity entity = EntityUtils.createEntityAndPassengersFromNBT(info.nbt, world);
            if (entity == null) continue;
            Vec3 pos = info.posVec;
            pos = PositionUtils.getTransformedPosition(pos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
            pos = PositionUtils.getTransformedPosition(pos, placement.getMirror(), placement.getRotation());
            double x = pos.x + (double)offX;
            double y = pos.y + (double)offY;
            double z = pos.z + (double)offZ;
            SchematicPlacingUtils.rotateEntity(entity, x, y, z, rotationCombined, mirrorMain, mirrorSub);
            EntityUtils.spawnEntityAndPassengersInWorld(entity, world);
        }
    }

    private void takeEntitiesFromWorld(Level world, List<Box> boxes, BlockPos origin) {
        for (Box box : boxes) {
            AABB bb = PositionUtils.createEnclosingAABB(box.getPos1(), box.getPos2());
            BlockPos regionPosAbs = box.getPos1();
            ArrayList<EntityInfo> list = new ArrayList<EntityInfo>();
            List entities = world.getEntities(null, bb, EntityUtils.NOT_PLAYER);
            for (Entity entity : entities) {
                NbtView view = NbtView.getWriter(world.registryAccess());
                entity.save(view.getWriter());
                CompoundTag tag = view.readNbt();
                ResourceLocation id = EntityType.getKey((EntityType)entity.getType());
                if (tag == null || id == null) continue;
                Vec3 posVec = new Vec3(entity.getX() - (double)regionPosAbs.getX(), entity.getY() - (double)regionPosAbs.getY(), entity.getZ() - (double)regionPosAbs.getZ());
                tag.putString("id", id.toString());
                fi.dy.masa.servux.util.nbt.NbtUtils.putVec3dCodec(tag, posVec, "Pos");
                list.add(new EntityInfo(posVec, tag));
            }
            this.entities.put(box.getName(), list);
        }
    }

    public void takeEntitiesFromWorldWithinChunk(Level world, int chunkX, int chunkZ, ImmutableMap<String, IntBoundingBox> volumes, ImmutableMap<String, Box> boxes, Set<UUID> existingEntities, BlockPos origin) {
        for (Map.Entry entry : volumes.entrySet()) {
            String regionName = (String)entry.getKey();
            List<EntityInfo> list = this.entities.get(regionName);
            Box box = (Box)boxes.get((Object)regionName);
            if (box == null || list == null) continue;
            AABB bb = PositionUtils.createAABBFrom((IntBoundingBox)entry.getValue());
            List entities = world.getEntities(null, bb, EntityUtils.NOT_PLAYER);
            BlockPos regionPosAbs = box.getPos1();
            for (Entity entity : entities) {
                UUID uuid = entity.getUUID();
                if (existingEntities.contains(uuid)) continue;
                NbtView view = NbtView.getWriter(world.registryAccess());
                entity.save(view.getWriter());
                CompoundTag tag = view.readNbt();
                ResourceLocation id = EntityType.getKey((EntityType)entity.getType());
                if (tag == null || id == null) continue;
                Vec3 posVec = new Vec3(entity.getX() - (double)regionPosAbs.getX(), entity.getY() - (double)regionPosAbs.getY(), entity.getZ() - (double)regionPosAbs.getZ());
                tag.putString("id", id.toString());
                if (entity instanceof HangingEntity) {
                    HangingEntity decorationEntity = (HangingEntity)entity;
                    BlockPos p = decorationEntity.blockPosition();
                    tag.putInt("TileX", p.getX() - regionPosAbs.getX());
                    tag.putInt("TileY", p.getY() - regionPosAbs.getY());
                    tag.putInt("TileZ", p.getZ() - regionPosAbs.getZ());
                }
                fi.dy.masa.servux.util.nbt.NbtUtils.putVec3dCodec(tag, posVec, "Pos");
                list.add(new EntityInfo(posVec, tag));
                existingEntities.add(uuid);
            }
        }
    }

    private void takeBlocksFromWorld(Level world, List<Box> boxes, SchematicSaveInfo info) {
        BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos(0, 0, 0);
        for (Box box : boxes) {
            BlockPos size = box.getSize();
            int sizeX = Math.abs(size.getX());
            int sizeY = Math.abs(size.getY());
            int sizeZ = Math.abs(size.getZ());
            LitematicaBlockStateContainer container = new LitematicaBlockStateContainer(sizeX, sizeY, sizeZ);
            HashMap<BlockPos, CompoundTag> tileEntityMap = new HashMap<BlockPos, CompoundTag>();
            HashMap blockTickMap = new HashMap();
            HashMap fluidTickMap = new HashMap();
            BlockPos minCorner = PositionUtils.getMinCorner(box.getPos1(), box.getPos2());
            int startX = minCorner.getX();
            int startY = minCorner.getY();
            int startZ = minCorner.getZ();
            boolean visibleOnly = info.visibleOnly;
            boolean includeSupport = info.includeSupportBlocks;
            for (int y = 0; y < sizeY; ++y) {
                for (int z = 0; z < sizeZ; ++z) {
                    for (int x = 0; x < sizeX; ++x) {
                        BlockEntity te;
                        posMutable.set(x + startX, y + startY, z + startZ);
                        if (visibleOnly && !LitematicaSchematic.isExposed(world, (BlockPos)posMutable) && (!includeSupport || !LitematicaSchematic.isSupport(world, (BlockPos)posMutable))) continue;
                        BlockState state = world.getBlockState((BlockPos)posMutable);
                        container.set(x, y, z, state);
                        if (!state.isAir()) {
                            ++this.totalBlocksReadFromWorld;
                        }
                        if (!state.hasBlockEntity() || (te = world.getBlockEntity((BlockPos)posMutable)) == null) continue;
                        BlockPos pos = new BlockPos(x, y, z);
                        CompoundTag tag = te.saveWithFullMetadata((HolderLookup.Provider)world.registryAccess());
                        fi.dy.masa.servux.util.nbt.NbtUtils.writeBlockPosToTag((Vec3i)pos, tag);
                        tileEntityMap.put(pos, tag);
                    }
                }
            }
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                IntBoundingBox tickBox = IntBoundingBox.createProper(startX, startY, startZ, startX + sizeX, startY + sizeY, startZ + sizeZ);
                long currentTick = world.getGameTime();
                this.getTicksFromScheduler(((IMixinWorldTickScheduler)serverWorld.getBlockTicks()).servux_getChunkTickSchedulers(), blockTickMap, tickBox, minCorner, currentTick);
                this.getTicksFromScheduler(((IMixinWorldTickScheduler)serverWorld.getFluidTicks()).servux_getChunkTickSchedulers(), fluidTickMap, tickBox, minCorner, currentTick);
            }
            this.blockContainers.put(box.getName(), container);
            this.tileEntities.put(box.getName(), tileEntityMap);
            this.pendingBlockTicks.put(box.getName(), blockTickMap);
            this.pendingFluidTicks.put(box.getName(), fluidTickMap);
        }
    }

    private <T> void getTicksFromScheduler(Long2ObjectMap<LevelChunkTicks<T>> chunkTickSchedulers, Map<BlockPos, ScheduledTick<T>> outputMap, IntBoundingBox box, BlockPos minCorner, long currentTick) {
        int minCX = SectionPos.blockToSectionCoord((int)box.minX);
        int minCZ = SectionPos.blockToSectionCoord((int)box.minZ);
        int maxCX = SectionPos.blockToSectionCoord((int)box.maxX);
        int maxCZ = SectionPos.blockToSectionCoord((int)box.maxZ);
        for (int cx = minCX; cx <= maxCX; ++cx) {
            for (int cz = minCZ; cz <= maxCZ; ++cz) {
                long cp = ChunkPos.asLong((int)cx, (int)cz);
                LevelChunkTicks chunkTickScheduler = (LevelChunkTicks)chunkTickSchedulers.get(cp);
                if (chunkTickScheduler == null) continue;
                chunkTickScheduler.getAll().filter(t -> box.containsPos((Vec3i)t.pos())).forEach(t -> this.addRelativeTickToMap(outputMap, (ScheduledTick)t, minCorner, currentTick));
            }
        }
    }

    private <T> void addRelativeTickToMap(Map<BlockPos, ScheduledTick<T>> outputMap, ScheduledTick<T> tick, BlockPos minCorner, long currentTick) {
        BlockPos pos = tick.pos();
        BlockPos relativePos = new BlockPos(pos.getX() - minCorner.getX(), pos.getY() - minCorner.getY(), pos.getZ() - minCorner.getZ());
        ScheduledTick newTick = new ScheduledTick(tick.type(), relativePos, tick.triggerTick() - currentTick, tick.priority(), tick.subTickOrder());
        outputMap.put(relativePos, newTick);
    }

    public static boolean isExposed(Level world, BlockPos pos) {
        for (Direction dir : Direction.values()) {
            BlockPos posAdj = pos.relative(dir);
            BlockState stateAdj = world.getBlockState(posAdj);
            if (stateAdj.canOcclude() && stateAdj.isFaceSturdy((BlockGetter)world, posAdj, dir.getOpposite())) continue;
            return true;
        }
        return false;
    }

    public static boolean isGravityBlock(BlockState state) {
        return state.is(BlockTags.SAND) || state.is(BlockTags.CONCRETE_POWDER) || state.getBlock() == Blocks.GRAVEL;
    }

    public static boolean isGravityBlock(Level world, BlockPos pos) {
        return LitematicaSchematic.isGravityBlock(world.getBlockState(pos));
    }

    public static boolean supportsExposedBlocks(Level world, BlockPos pos) {
        BlockPos posUp = pos.relative(Direction.UP);
        BlockState stateUp = world.getBlockState(posUp);
        while (true) {
            if (LitematicaSchematic.needsSupportNonGravity(stateUp)) {
                return true;
            }
            if (!LitematicaSchematic.isGravityBlock(stateUp)) break;
            if (LitematicaSchematic.isExposed(world, posUp)) {
                return true;
            }
            if ((posUp = posUp.relative(Direction.UP)).getY() >= world.getMaxY() + 1) break;
            stateUp = world.getBlockState(posUp);
        }
        return false;
    }

    public static boolean needsSupportNonGravity(BlockState state) {
        Block block = state.getBlock();
        return block == Blocks.REPEATER || block == Blocks.COMPARATOR || block == Blocks.SNOW || block instanceof CarpetBlock;
    }

    public static boolean isSupport(Level world, BlockPos pos) {
        BlockPos posUp = pos.relative(Direction.UP);
        BlockState stateUp = world.getBlockState(posUp);
        if (LitematicaSchematic.needsSupportNonGravity(stateUp)) {
            return true;
        }
        return LitematicaSchematic.isGravityBlock(stateUp) && (LitematicaSchematic.isExposed(world, posUp) || LitematicaSchematic.supportsExposedBlocks(world, posUp));
    }

    private void setSubRegionPositions(List<Box> boxes, BlockPos areaOrigin) {
        for (Box box : boxes) {
            this.subRegionPositions.put(box.getName(), box.getPos1().subtract((Vec3i)areaOrigin));
        }
    }

    private void setSubRegionSizes(List<Box> boxes) {
        for (Box box : boxes) {
            this.subRegionSizes.put(box.getName(), box.getSize());
        }
    }

    @Nullable
    public LitematicaBlockStateContainer getSubRegionContainer(String regionName) {
        return this.blockContainers.get(regionName);
    }

    @Nullable
    public Map<BlockPos, CompoundTag> getBlockEntityMapForRegion(String regionName) {
        return this.tileEntities.get(regionName);
    }

    @Nullable
    public List<EntityInfo> getEntityListForRegion(String regionName) {
        return this.entities.get(regionName);
    }

    @Nullable
    public Map<BlockPos, ScheduledTick<Block>> getScheduledBlockTicksForRegion(String regionName) {
        return this.pendingBlockTicks.get(regionName);
    }

    @Nullable
    public Map<BlockPos, ScheduledTick<Fluid>> getScheduledFluidTicksForRegion(String regionName) {
        return this.pendingFluidTicks.get(regionName);
    }

    private CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.putInt("MinecraftDataVersion", MINECRAFT_DATA_VERSION);
        nbt.putInt("Version", 7);
        nbt.putInt("SubVersion", 1);
        nbt.put("Metadata", (Tag)this.metadata.writeToNBT());
        nbt.put("Regions", (Tag)this.writeSubRegionsToNBT());
        return nbt;
    }

    private CompoundTag writeSubRegionsToNBT() {
        CompoundTag wrapper = new CompoundTag();
        if (!this.blockContainers.isEmpty()) {
            for (String regionName : this.blockContainers.keySet()) {
                LitematicaBlockStateContainer blockContainer = this.blockContainers.get(regionName);
                Map<BlockPos, CompoundTag> tileMap = this.tileEntities.get(regionName);
                List<EntityInfo> entityList = this.entities.get(regionName);
                Map pendingBlockTicks = this.pendingBlockTicks.get(regionName);
                Map pendingFluidTicks = this.pendingFluidTicks.get(regionName);
                CompoundTag tag = new CompoundTag();
                tag.put("BlockStatePalette", (Tag)blockContainer.getPalette().writeToNBT());
                tag.put("BlockStates", (Tag)new LongArrayTag(blockContainer.getBackingLongArray()));
                tag.put("TileEntities", (Tag)this.writeTileEntitiesToNBT(tileMap));
                if (pendingBlockTicks != null) {
                    tag.put("PendingBlockTicks", (Tag)this.writePendingTicksToNBT(pendingBlockTicks, (Registry)BuiltInRegistries.BLOCK, "Block"));
                }
                if (pendingFluidTicks != null) {
                    tag.put("PendingFluidTicks", (Tag)this.writePendingTicksToNBT(pendingFluidTicks, (Registry)BuiltInRegistries.FLUID, "Fluid"));
                }
                if (entityList != null) {
                    tag.put("Entities", (Tag)this.writeEntitiesToNBT(entityList));
                }
                BlockPos pos = this.subRegionPositions.get(regionName);
                tag.put("Position", (Tag)fi.dy.masa.servux.util.nbt.NbtUtils.createBlockPosTag((Vec3i)pos));
                pos = this.subRegionSizes.get(regionName);
                tag.put("Size", (Tag)fi.dy.masa.servux.util.nbt.NbtUtils.createBlockPosTag((Vec3i)pos));
                wrapper.put(regionName, (Tag)tag);
            }
        }
        return wrapper;
    }

    private ListTag writeEntitiesToNBT(List<EntityInfo> entityList) {
        ListTag tagList = new ListTag();
        if (!entityList.isEmpty()) {
            for (EntityInfo info : entityList) {
                tagList.add((Object)info.nbt);
            }
        }
        return tagList;
    }

    private <T> ListTag writePendingTicksToNBT(Map<BlockPos, ScheduledTick<T>> tickMap, Registry<T> registry, String tagName) {
        ListTag tagList = new ListTag();
        if (!tickMap.isEmpty()) {
            for (ScheduledTick<T> entry : tickMap.values()) {
                Object target = entry.type();
                ResourceLocation id = registry.getKey(target);
                if (id == null) continue;
                CompoundTag tag = new CompoundTag();
                tag.putString(tagName, id.toString());
                tag.putInt("Priority", entry.priority().getValue());
                tag.putLong("SubTick", entry.subTickOrder());
                tag.putInt("Time", (int)entry.triggerTick());
                tag.putInt("x", entry.pos().getX());
                tag.putInt("y", entry.pos().getY());
                tag.putInt("z", entry.pos().getZ());
                tagList.add((Object)tag);
            }
        }
        return tagList;
    }

    private ListTag writeTileEntitiesToNBT(Map<BlockPos, CompoundTag> tileMap) {
        ListTag tagList = new ListTag();
        if (!tileMap.isEmpty()) {
            tagList.addAll(tileMap.values());
        }
        return tagList;
    }

    public void sendTransmitFile(CompoundTag nbtIn, long sessionKey, ServerPlayer player) {
        Path file = this.getFile();
        CompoundTag output = new CompoundTag();
        output.putString("Task", "Litematic-TransmitStart");
        output.putString("FileName", file.getFileName().toString());
        output.store("FileType", FileType.CODEC, (Object)this.schematicType);
        output.putLong("SliceKey", sessionKey);
        if (!nbtIn.isEmpty()) {
            output.put("PlacementData", (Tag)nbtIn);
        }
        ServuxLitematicaHandler.getInstance().encodeServerData(player, ServuxLitematicaPacket.ResponseC2SStart(output));
        int bufferSize = 16384;
        byte[] buffer = new byte[16384];
        int totalBytes = 0;
        int totalSlices = 0;
        output.putLong("SliceKey", sessionKey);
        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
            int bytesRead = 0;
            output.putString("Task", "Litematic-TransmitData");
            while (bytesRead != -1) {
                output.remove("Slice");
                output.remove("Size");
                output.remove("Data");
                bytesRead = is.read(buffer, 0, 16384);
                output.putInt("Slice", totalSlices);
                output.putInt("Size", bytesRead);
                output.putByteArray("Data", buffer);
                ServuxLitematicaHandler.getInstance().encodeServerData(player, ServuxLitematicaPacket.ResponseC2SStart(output));
                totalBytes += bytesRead;
                ++totalSlices;
            }
        }
        catch (Exception err) {
            output = new CompoundTag();
            output.putLong("SliceKey", sessionKey);
            output.putString("Task", "Litematic-TransmitCancel");
            ServuxLitematicaHandler.getInstance().encodeServerData(player, ServuxLitematicaPacket.ResponseC2SStart(output));
            Servux.LOGGER.error("sliceForServux: Exception reading file; {}", (Object)err.getLocalizedMessage());
            return;
        }
        output.remove("Slice");
        output.remove("Size");
        output.remove("Data");
        output.putInt("TotalSize", totalBytes);
        output.putInt("TotalSlices", totalSlices);
        output.putString("Task", "Litematic-TransmitEnd");
        ServuxLitematicaHandler.getInstance().encodeServerData(player, ServuxLitematicaPacket.ResponseC2SStart(output));
    }

    @Nullable
    public static Pair<LitematicaSchematic, CompoundTag> receiveFileTransmit(CompoundTag nbt, ServerPlayer player) {
        SchematicBufferManager manager = LitematicsDataProvider.INSTANCE.getBufferManager();
        String task = nbt.getStringOr("Task", "");
        long key = nbt.getLongOr("SliceKey", -1L);
        if (task.isEmpty() || key == -1L) {
            Servux.LOGGER.error("receiveFileTransmit: Invalid sessionKey or Task received.");
            return null;
        }
        switch (task) {
            case "Litematic-TransmitStart": {
                FileType type = nbt.read("FileType", FileType.CODEC).orElse(FileType.LITEMATICA_SCHEMATIC);
                String name = nbt.getStringOr("FileName", "default_file");
                manager.createBuffer(name, type, key, nbt.getCompoundOrEmpty("PlacementData"), player);
                break;
            }
            case "Litematic-TransmitData": {
                int slice = nbt.getIntOr("Slice", -1);
                int size = nbt.getIntOr("Size", -1);
                byte[] data = nbt.getByteArray("Data").orElse(new byte[0]);
                if (slice < 0 || size < 0 || data.length == 0) {
                    Servux.LOGGER.error("receiveFileTransmit: Invalid Slice Data received for session key [{}]", (Object)key);
                    return null;
                }
                manager.receiveSlice(key, slice, data, size);
                break;
            }
            case "Litematic-TransmitCancel": {
                Servux.LOGGER.warn("receiveFileTransmit: Cancel received for session key [{}]", (Object)key);
                manager.cancelBuffer(key);
                break;
            }
            case "Litematic-TransmitEnd": {
                int totalSize = nbt.getIntOr("TotalSize", -1);
                int totalSlices = nbt.getIntOr("TotalSlices", -1);
                Path dir = LitematicsDataProvider.INSTANCE.getTransmitDir();
                CompoundTag optional = manager.getOptionalNbt(key);
                LitematicaSchematic schematic = manager.finishBuffer(key, dir);
                manager.removePlayer(player);
                if (schematic == null) {
                    Servux.LOGGER.warn("receiveFileTransmit: Failed to create Schematic for finishing session key [{}]", (Object)key);
                    return null;
                }
                Servux.debugLog("receiveFileTransmit: Received file '{}', [tS: {}, tB: {}]", schematic.getFile().toAbsolutePath().toString(), totalSlices, totalSize);
                return Pair.of((Object)schematic, (Object)optional);
            }
            default: {
                Servux.LOGGER.error("receiveFileTransmit: Invalid sessionKey or Task received.");
            }
        }
        return null;
    }

    private boolean readFromNBT(CompoundTag nbt, boolean enableFixers) throws CommandSyntaxException {
        this.blockContainers.clear();
        this.tileEntities.clear();
        this.entities.clear();
        this.pendingBlockTicks.clear();
        this.subRegionPositions.clear();
        this.subRegionSizes.clear();
        if (nbt.contains("Version")) {
            int minecraftDataVersion;
            int version = nbt.getIntOr("Version", -1);
            int n = minecraftDataVersion = nbt.contains("MinecraftDataVersion") ? nbt.getIntOr("MinecraftDataVersion", 1139) : SharedConstants.getCurrentVersion().dataVersion().version();
            if (version >= 1 && version <= 7) {
                this.metadata.readFromNBT(nbt.getCompoundOrEmpty("Metadata"));
                this.metadata.setSchematicVersion(version);
                this.metadata.setMinecraftDataVersion(minecraftDataVersion);
                this.metadata.setFileType(FileType.LITEMATICA_SCHEMATIC);
                this.readSubRegionsFromNBT(nbt.getCompoundOrEmpty("Regions"), version, minecraftDataVersion, enableFixers);
                return true;
            }
            this.error("servux.litematics.error.schematic_load.unsupported_schematic_version");
        } else {
            this.error("servux.litematics.error.schematic_load.no_schematic_version_information");
        }
        return false;
    }

    private void error(String s, Objects ... objects) throws CommandSyntaxException {
        throw new SimpleCommandExceptionType((Message)Component.translatable((String)s, (Object[])objects)).create();
    }

    private void error(String s) throws CommandSyntaxException {
        throw new SimpleCommandExceptionType((Message)Component.translatable((String)s)).create();
    }

    private void readSubRegionsFromNBT(CompoundTag tag, int version, int minecraftDataVersion, boolean enableFixers) {
        for (String regionName : tag.keySet()) {
            Tag nbtBase;
            ListTag list;
            if (tag.get(regionName).getId() != 10) continue;
            CompoundTag regionTag = tag.getCompoundOrEmpty(regionName);
            BlockPos regionPos = fi.dy.masa.servux.util.nbt.NbtUtils.readBlockPos(regionTag.getCompoundOrEmpty("Position"));
            BlockPos regionSize = fi.dy.masa.servux.util.nbt.NbtUtils.readBlockPos(regionTag.getCompoundOrEmpty("Size"));
            Map<BlockPos, CompoundTag> tiles = null;
            if (regionPos == null || regionSize == null) continue;
            this.subRegionPositions.put(regionName, regionPos);
            this.subRegionSizes.put(regionName, regionSize);
            if (version >= 2) {
                tiles = this.readTileEntitiesFromNBT(regionTag.getListOrEmpty("TileEntities"));
                if (enableFixers) {
                    tiles = this.convertTileEntities_to_1_20_5(tiles, minecraftDataVersion);
                }
                this.tileEntities.put(regionName, tiles);
                ListTag entities = regionTag.getListOrEmpty("Entities");
                if (enableFixers) {
                    entities = this.convertEntities_to_1_20_5(entities, minecraftDataVersion);
                }
                this.entities.put(regionName, this.readEntitiesFromNBT(entities));
            } else if (version == 1) {
                tiles = this.readTileEntitiesFromNBT_v1(regionTag.getListOrEmpty("TileEntities"));
                this.tileEntities.put(regionName, tiles);
                this.entities.put(regionName, this.readEntitiesFromNBT_v1(regionTag.getListOrEmpty("Entities")));
            }
            if (version >= 3) {
                list = regionTag.getListOrEmpty("PendingBlockTicks");
                this.pendingBlockTicks.put(regionName, this.readPendingTicksFromNBT(list, (Registry)BuiltInRegistries.BLOCK, "Block", (Object)Blocks.AIR));
            }
            if (version >= 5) {
                list = regionTag.getListOrEmpty("PendingFluidTicks");
                this.pendingFluidTicks.put(regionName, this.readPendingTicksFromNBT(list, (Registry)BuiltInRegistries.FLUID, "Fluid", (Object)Fluids.EMPTY));
            }
            if ((nbtBase = regionTag.get("BlockStates")) == null || nbtBase.getId() != 12) continue;
            ListTag palette = regionTag.getListOrEmpty("BlockStatePalette");
            long[] blockStateArr = ((LongArrayTag)nbtBase).getAsLongArray();
            BlockPos posEndRel = PositionUtils.getRelativeEndPositionFromAreaSize((Vec3i)regionSize).offset((Vec3i)regionPos);
            BlockPos posMin = PositionUtils.getMinCorner(regionPos, posEndRel);
            BlockPos posMax = PositionUtils.getMaxCorner(regionPos, posEndRel);
            BlockPos size = posMax.subtract((Vec3i)posMin).offset(1, 1, 1);
            if (enableFixers) {
                palette = this.convertBlockStatePalette_to_1_20_5(palette, minecraftDataVersion);
            }
            LitematicaBlockStateContainer container = LitematicaBlockStateContainer.createFrom(palette, blockStateArr, size);
            if (minecraftDataVersion < MINECRAFT_DATA_VERSION && enableFixers) {
                this.postProcessContainerIfNeeded(palette, container, tiles);
            }
            this.blockContainers.put(regionName, container);
        }
    }

    public static boolean isSizeValid(@Nullable Vec3i size) {
        return size != null && size.getX() > 0 && size.getY() > 0 && size.getZ() > 0;
    }

    @Nullable
    private static Vec3i readSizeFromTagImpl(CompoundTag tag) {
        ListTag tagList;
        if (tag.contains("size") && (tagList = tag.getListOrEmpty("size")).size() == 3) {
            return new Vec3i(tagList.getIntOr(0, 0), tagList.getIntOr(1, 0), tagList.getIntOr(2, 0));
        }
        return null;
    }

    @Nullable
    public static BlockPos readBlockPosFromNbtList(CompoundTag tag, String tagName) {
        ListTag tagList;
        if (tag.contains(tagName) && (tagList = tag.getListOrEmpty(tagName)).size() == 3) {
            return new BlockPos(tagList.getIntOr(0, 0), tagList.getIntOr(1, 0), tagList.getIntOr(2, 0));
        }
        return null;
    }

    protected boolean readPaletteFromLitematicaFormatTag(ListTag tagList, ILitematicaBlockStatePalette palette) {
        int size = tagList.size();
        ArrayList<BlockState> list = new ArrayList<BlockState>(size);
        Registry lookup = DataProviderManager.INSTANCE.getRegistryManager().lookupOrThrow(Registries.BLOCK);
        for (int id = 0; id < size; ++id) {
            CompoundTag tag = tagList.getCompoundOrEmpty(id);
            BlockState state = NbtUtils.readBlockState((HolderGetter)lookup, (CompoundTag)tag);
            list.add(state);
        }
        return palette.setMapping(list);
    }

    public static boolean isValidSpongeSchematic(CompoundTag tag) {
        if (tag.contains("Width") && tag.contains("Height") && tag.contains("Length") && tag.contains("Version") && tag.contains("Palette") && tag.contains("BlockData")) {
            return LitematicaSchematic.isSizeValid(LitematicaSchematic.readSizeFromTagSponge(tag));
        }
        return false;
    }

    public static boolean isValidSpongeSchematicv3(CompoundTag tag) {
        CompoundTag nbtV3;
        if (tag.contains("Schematic") && (nbtV3 = tag.getCompoundOrEmpty("Schematic")).contains("Width") && nbtV3.contains("Height") && nbtV3.contains("Length") && nbtV3.contains("Version") && nbtV3.getIntOr("Version", -1) >= 3 && nbtV3.contains("Blocks") && nbtV3.contains("DataVersion")) {
            return LitematicaSchematic.isSizeValid(LitematicaSchematic.readSizeFromTagSponge(nbtV3));
        }
        return false;
    }

    public static Vec3i readSizeFromTagSponge(CompoundTag tag) {
        return new Vec3i(tag.getIntOr("Width", 0), tag.getIntOr("Height", 0), tag.getIntOr("Length", 0));
    }

    protected boolean readSpongePaletteFromTag(CompoundTag tag, ILitematicaBlockStatePalette palette) {
        int size = tag.keySet().size();
        ArrayList<BlockState> list = new ArrayList<BlockState>(size);
        BlockState air = Blocks.AIR.defaultBlockState();
        for (int i = 0; i < size; ++i) {
            list.add(air);
        }
        for (String key : tag.keySet()) {
            BlockState state;
            int id = tag.getIntOr(key, 0);
            Optional<BlockState> stateOptional = BlockUtils.getBlockStateFromString(key);
            if (stateOptional.isPresent()) {
                state = stateOptional.get();
            } else {
                Servux.LOGGER.warn("Unknown block in the Sponge schematic palette: '{}'", (Object)key);
                state = LitematicaBlockStateContainer.AIR_BLOCK_STATE;
            }
            if (id < 0 || id >= size) {
                Servux.LOGGER.error("Invalid ID in the Sponge schematic palette: '{}'", (Object)id);
                return false;
            }
            list.set(id, state);
        }
        return palette.setMapping(list);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean readSpongeBlocksFromTag(CompoundTag tag, String schematicName, Vec3i size, int minecraftDataVersion, int spongeVersion) {
        int paletteSize;
        byte[] blockData;
        CompoundTag paletteTag;
        CompoundTag blocksTag = new CompoundTag();
        if (spongeVersion >= 3 && tag.contains("Blocks")) {
            blocksTag = tag.getCompoundOrEmpty("Blocks");
            if (!blocksTag.contains("Palette") || !blocksTag.contains("Data")) return false;
            paletteTag = blocksTag.getCompoundOrEmpty("Palette");
            blockData = blocksTag.getByteArray("Data").orElse(new byte[0]);
            paletteSize = paletteTag.keySet().size();
        } else {
            if (!tag.contains("Palette") || !tag.contains("BlockData")) return false;
            paletteTag = tag.getCompoundOrEmpty("Palette");
            blockData = tag.getByteArray("BlockData").orElse(new byte[0]);
            paletteSize = paletteTag.keySet().size();
        }
        LitematicaBlockStateContainer container = LitematicaBlockStateContainer.createContainer(paletteSize, blockData, size);
        if (container == null) {
            Servux.LOGGER.error("Failed to read blocks from Sponge schematic");
            return false;
        }
        this.blockContainers.put(schematicName, container);
        if (!this.readSpongePaletteFromTag(paletteTag, container.getPalette())) {
            return false;
        }
        if (spongeVersion < 3) return true;
        if (blocksTag.isEmpty()) return false;
        Map<BlockPos, CompoundTag> tileEntities = this.readSpongeBlockEntitiesFromTag(blocksTag, spongeVersion);
        this.tileEntities.put(schematicName, tileEntities);
        return true;
    }

    protected Map<BlockPos, CompoundTag> readSpongeBlockEntitiesFromTag(CompoundTag tag, int spongeVersion) {
        String tagName;
        HashMap<BlockPos, CompoundTag> blockEntities = new HashMap<BlockPos, CompoundTag>();
        String string = tagName = spongeVersion == 1 ? "TileEntities" : "BlockEntities";
        if (!tag.contains(tagName)) {
            return blockEntities;
        }
        ListTag tagList = tag.getListOrEmpty(tagName);
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            CompoundTag beTag = tagList.getCompoundOrEmpty(i);
            BlockPos pos = fi.dy.masa.servux.util.nbt.NbtUtils.readBlockPosFromArrayTag(beTag, "Pos");
            if (pos == null || beTag.isEmpty()) continue;
            beTag.putString("id", beTag.getStringOr("Id", ""));
            beTag.remove("Id");
            beTag.remove("Pos");
            if (spongeVersion == 1) {
                beTag.remove("ContentVersion");
            }
            if (spongeVersion >= 3) {
                CompoundTag beData = beTag.getCompoundOrEmpty("Data");
                blockEntities.put(pos, beData);
                continue;
            }
            blockEntities.put(pos, beTag);
        }
        return blockEntities;
    }

    protected List<EntityInfo> readSpongeEntitiesFromTag(CompoundTag tag, Vec3i offset, int spongeVersion) {
        ArrayList<EntityInfo> entities = new ArrayList<EntityInfo>();
        ListTag tagList = tag.getListOrEmpty("Entities");
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            CompoundTag entityEntry = tagList.getCompoundOrEmpty(i);
            Vec3 pos = fi.dy.masa.servux.util.nbt.NbtUtils.getVec3dCodec(entityEntry, "Pos");
            if (pos == null || entityEntry.isEmpty()) continue;
            entityEntry.putString("id", entityEntry.getStringOr("Id", ""));
            entityEntry.remove("Id");
            if (spongeVersion >= 3) {
                CompoundTag entityData = entityEntry.getCompoundOrEmpty("Data");
                if (!entityData.contains("id")) {
                    entityData.putString("id", entityEntry.getStringOr("id", ""));
                }
                entities.add(new EntityInfo(pos, entityData));
                continue;
            }
            pos = new Vec3(pos.x - (double)offset.getX(), pos.y - (double)offset.getY(), pos.z - (double)offset.getZ());
            entities.add(new EntityInfo(pos, entityEntry));
        }
        return entities;
    }

    public boolean readFromSpongeSchematic(String name, CompoundTag tag) {
        if (LitematicaSchematic.isValidSpongeSchematicv3(tag)) {
            CompoundTag spongeTag = tag.getCompoundOrEmpty("Schematic");
            tag.remove("Schematic");
            tag.merge(spongeTag);
        } else if (!LitematicaSchematic.isValidSpongeSchematic(tag)) {
            return false;
        }
        int spongeVersion = tag.contains("Version") ? tag.getIntOr("Version", -1) : -1;
        int minecraftDataVersion = tag.contains("DataVersion") ? tag.getIntOr("DataVersion", 1139) : 1139;
        Vec3i size = LitematicaSchematic.readSizeFromTagSponge(tag);
        if (!this.readSpongeBlocksFromTag(tag, name, size, minecraftDataVersion, spongeVersion)) {
            return false;
        }
        Vec3i offset = fi.dy.masa.servux.util.nbt.NbtUtils.readVec3iFromIntArray(tag, "Offset");
        if (offset == null) {
            offset = Vec3i.ZERO;
        }
        if (spongeVersion < 3) {
            Map<BlockPos, CompoundTag> tileEntities = this.readSpongeBlockEntitiesFromTag(tag, spongeVersion);
            this.tileEntities.put(name, tileEntities);
        }
        List<EntityInfo> entities = this.readSpongeEntitiesFromTag(tag, offset, spongeVersion);
        this.entities.put(name, entities);
        if (tag.contains("Metadata")) {
            CompoundTag metadata = tag.getCompoundOrEmpty("Metadata");
            this.metadata.setName(metadata.contains("Name") ? metadata.getStringOr("Name", "?") : name);
            this.metadata.setAuthor(metadata.contains("Author") ? metadata.getStringOr("Author", "?") : "unknown");
            this.metadata.setTimeCreated(metadata.contains("Date") ? metadata.getLongOr("Date", System.currentTimeMillis()) : System.currentTimeMillis());
        } else {
            this.metadata.setAuthor("unknown");
            this.metadata.setName(name);
            this.metadata.setTimeCreated(System.currentTimeMillis());
        }
        if (tag.contains("author")) {
            this.metadata.setAuthor(tag.getStringOr("author", "?"));
        }
        this.subRegionPositions.put(name, BlockPos.ZERO);
        this.subRegionSizes.put(name, new BlockPos(size));
        this.metadata.setRegionCount(1);
        this.metadata.setTotalVolume(size.getX() * size.getY() * size.getZ());
        this.metadata.setEnclosingSize(size);
        this.metadata.setTimeModified(this.metadata.getTimeCreated());
        this.metadata.setTotalBlocks(this.totalBlocksReadFromWorld);
        this.metadata.setSchematicVersion(spongeVersion);
        this.metadata.setMinecraftDataVersion(minecraftDataVersion);
        this.metadata.setFileType(FileType.SPONGE_SCHEMATIC);
        return true;
    }

    public boolean readFromVanillaStructure(String name, CompoundTag tag) {
        Vec3i size = LitematicaSchematic.readSizeFromTagImpl(tag);
        if (tag.contains("palette") && tag.contains("blocks") && LitematicaSchematic.isSizeValid(size)) {
            ListTag paletteTag = tag.getListOrEmpty("palette");
            int minecraftDataVersion = tag.contains("DataVersion") ? tag.getIntOr("DataVersion", 1139) : 1139;
            HashMap<BlockPos, CompoundTag> tileMap = new HashMap<BlockPos, CompoundTag>();
            this.tileEntities.put(name, tileMap);
            BlockState air = Blocks.AIR.defaultBlockState();
            int paletteSize = paletteTag.size();
            ArrayList<BlockState> list = new ArrayList<BlockState>(paletteSize);
            Registry lookup = DataProviderManager.INSTANCE.getRegistryManager().lookupOrThrow(Registries.BLOCK);
            if (minecraftDataVersion < MINECRAFT_DATA_VERSION) {
                Servux.LOGGER.info("VanillaStructure: executing Vanilla DataFixer for Block State Palette DataVersion {} -> {}", (Object)minecraftDataVersion, (Object)MINECRAFT_DATA_VERSION);
            }
            for (int id = 0; id < paletteSize; ++id) {
                CompoundTag t = paletteTag.getCompoundOrEmpty(id);
                if (minecraftDataVersion < MINECRAFT_DATA_VERSION) {
                    t = SchematicConversionMaps.updateBlockStates(t, minecraftDataVersion);
                }
                BlockState state = NbtUtils.readBlockState((HolderGetter)lookup, (CompoundTag)t);
                list.add(state);
            }
            BlockState zeroState = (BlockState)list.get(0);
            int airId = -1;
            for (int i = 0; i < paletteSize; ++i) {
                if (list.get(i) != air) continue;
                airId = i;
                break;
            }
            if (airId != 0) {
                if (airId == -1) {
                    list.add(0, air);
                    ++paletteSize;
                } else {
                    list.set(0, air);
                    list.set(airId, zeroState);
                }
            }
            int bits = Math.max(2, 32 - Integer.numberOfLeadingZeros(paletteSize - 1));
            LitematicaBlockStateContainer container = new LitematicaBlockStateContainer(size.getX(), size.getY(), size.getZ(), bits, null);
            ILitematicaBlockStatePalette palette = container.getPalette();
            palette.setMapping(list);
            this.blockContainers.put(name, container);
            if (tag.contains("author")) {
                this.getMetadata().setAuthor(tag.getStringOr("author", "?"));
            }
            this.subRegionPositions.put(name, BlockPos.ZERO);
            this.subRegionSizes.put(name, new BlockPos(size));
            this.metadata.setName(name);
            this.metadata.setRegionCount(1);
            this.metadata.setTotalVolume(size.getX() * size.getY() * size.getZ());
            this.metadata.setEnclosingSize(size);
            this.metadata.setTimeCreated(System.currentTimeMillis());
            this.metadata.setTimeModified(this.metadata.getTimeCreated());
            this.metadata.setSchematicVersion(0);
            this.metadata.setMinecraftDataVersion(minecraftDataVersion);
            this.metadata.setFileType(FileType.VANILLA_STRUCTURE);
            ListTag blockList = tag.getListOrEmpty("blocks");
            int count = blockList.size();
            int totalBlocks = 0;
            for (int i = 0; i < count; ++i) {
                CompoundTag blockTag = blockList.getCompoundOrEmpty(i);
                BlockPos pos = LitematicaSchematic.readBlockPosFromNbtList(blockTag, "pos");
                if (pos == null) {
                    Servux.LOGGER.error("Failed to read block position for vanilla structure");
                    return false;
                }
                int id = blockTag.getIntOr("state", 0);
                BlockState state = airId == -1 ? palette.getBlockState(id + 1) : (airId != 0 ? (id == 0 ? zeroState : (id == airId ? air : palette.getBlockState(id))) : palette.getBlockState(id));
                if (state == null) {
                    state = air;
                } else if (state != air) {
                    ++totalBlocks;
                }
                container.set(pos.getX(), pos.getY(), pos.getZ(), state);
                if (!blockTag.contains("nbt")) continue;
                tileMap.put(pos, blockTag.getCompoundOrEmpty("nbt"));
            }
            this.metadata.setTotalBlocks(totalBlocks);
            this.entities.put(name, this.readEntitiesFromVanillaStructure(tag, minecraftDataVersion));
            return true;
        }
        return false;
    }

    protected List<EntityInfo> readEntitiesFromVanillaStructure(CompoundTag tag, int minecraftDataVersion) {
        ArrayList<EntityInfo> entities = new ArrayList<EntityInfo>();
        ListTag tagList = tag.getListOrEmpty("entities");
        int size = tagList.size();
        if (minecraftDataVersion < MINECRAFT_DATA_VERSION) {
            Servux.LOGGER.info("VanillaStructure: executing Vanilla DataFixer for Entities DataVersion {} -> {}", (Object)minecraftDataVersion, (Object)MINECRAFT_DATA_VERSION);
        }
        for (int i = 0; i < size; ++i) {
            Vec3 pos;
            CompoundTag entityData = tagList.getCompoundOrEmpty(i);
            if (minecraftDataVersion < MINECRAFT_DATA_VERSION) {
                entityData = SchematicConversionMaps.updateEntity(entityData, minecraftDataVersion);
            }
            if ((pos = LitematicaSchematic.readVec3dFromNbtList(entityData, "pos")) == null || !entityData.contains("nbt")) continue;
            entities.add(new EntityInfo(pos, entityData.getCompoundOrEmpty("nbt")));
        }
        return entities;
    }

    @Nullable
    public static Vec3 readVec3dFromNbtList(@Nullable CompoundTag tag, String tagName) {
        ListTag tagList;
        if (tag != null && tag.contains(tagName) && (tagList = tag.getListOrEmpty(tagName)).getId() == 6 && tagList.size() == 3) {
            return new Vec3(tagList.getDoubleOr(0, 0.0), tagList.getDoubleOr(1, 0.0), tagList.getDoubleOr(2, 0.0));
        }
        return null;
    }

    private void postProcessContainerIfNeeded(ListTag palette, LitematicaBlockStateContainer container, @Nullable Map<BlockPos, CompoundTag> tiles) {
        List<BlockState> states = LitematicaSchematic.getStatesFromPaletteTag(palette);
    }

    public static List<BlockState> getStatesFromPaletteTag(ListTag palette) {
        ArrayList<BlockState> states = new ArrayList<BlockState>();
        Registry lookup = DataProviderManager.INSTANCE.getRegistryManager().lookupOrThrow(Registries.BLOCK);
        int size = palette.size();
        for (int i = 0; i < size; ++i) {
            CompoundTag tag = palette.getCompoundOrEmpty(i);
            BlockState state = NbtUtils.readBlockState((HolderGetter)lookup, (CompoundTag)tag);
            if (i <= 0 && state == LitematicaBlockStateContainer.AIR_BLOCK_STATE) continue;
            states.add(state);
        }
        return states;
    }

    private List<EntityInfo> readEntitiesFromNBT(ListTag tagList) {
        ArrayList<EntityInfo> entityList = new ArrayList<EntityInfo>();
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            CompoundTag entityData = tagList.getCompoundOrEmpty(i);
            Vec3 posVec = fi.dy.masa.servux.util.nbt.NbtUtils.getVec3dCodec(entityData, "Pos");
            if (posVec == null || entityData.isEmpty()) continue;
            entityList.add(new EntityInfo(posVec, entityData));
        }
        return entityList;
    }

    private Map<BlockPos, CompoundTag> readTileEntitiesFromNBT(ListTag tagList) {
        HashMap<BlockPos, CompoundTag> tileMap = new HashMap<BlockPos, CompoundTag>();
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            CompoundTag tag = tagList.getCompoundOrEmpty(i);
            BlockPos pos = fi.dy.masa.servux.util.nbt.NbtUtils.readBlockPos(tag);
            if (pos == null || tag.isEmpty()) continue;
            tileMap.put(pos, tag);
        }
        return tileMap;
    }

    private <T> Map<BlockPos, ScheduledTick<T>> readPendingTicksFromNBT(ListTag tagList, Registry<T> registry, String tagName, T emptyValue) {
        HashMap<BlockPos, ScheduledTick<T>> tickMap = new HashMap<BlockPos, ScheduledTick<T>>();
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            CompoundTag tag = tagList.getCompoundOrEmpty(i);
            if (!tag.contains("Time")) continue;
            Object target = null;
            try {
                target = registry.getValue(ResourceLocation.tryParse((String)tag.getStringOr(tagName, "")));
                if (target == null || target == emptyValue) {
                    continue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (target == null) continue;
            BlockPos pos = new BlockPos(tag.getIntOr("x", 0), tag.getIntOr("y", 0), tag.getIntOr("z", 0));
            TickPriority priority = TickPriority.byValue((int)tag.getIntOr("Priority", 0));
            int scheduledTime = tag.getIntOr("Time", 0);
            long subTick = tag.getLongOr("SubTick", 0L);
            tickMap.put(pos, new ScheduledTick(target, pos, (long)scheduledTime, priority, subTick));
        }
        return tickMap;
    }

    private ListTag convertBlockStatePalette_to_1_20_5(ListTag oldPalette, int minecraftDataVersion) {
        if (minecraftDataVersion < 1139) {
            minecraftDataVersion = 1139;
        }
        if (minecraftDataVersion < MINECRAFT_DATA_VERSION) {
            ListTag newPalette = new ListTag();
            int count = oldPalette.size();
            Servux.LOGGER.info("LitematicaSchematic: executing Vanilla DataFixer for Block State Palette DataVersion {} -> {}", (Object)minecraftDataVersion, (Object)MINECRAFT_DATA_VERSION);
            for (int i = 0; i < count; ++i) {
                newPalette.add((Object)SchematicConversionMaps.updateBlockStates(oldPalette.getCompoundOrEmpty(i), minecraftDataVersion));
            }
            return newPalette;
        }
        return oldPalette;
    }

    private Map<BlockPos, CompoundTag> convertTileEntities_to_1_20_5(Map<BlockPos, CompoundTag> oldTE, int minecraftDataVersion) {
        if (minecraftDataVersion < 1139) {
            minecraftDataVersion = 1139;
        }
        if (minecraftDataVersion < MINECRAFT_DATA_VERSION) {
            HashMap<BlockPos, CompoundTag> newTE = new HashMap<BlockPos, CompoundTag>();
            Servux.LOGGER.info("LitematicaSchematic: executing Vanilla DataFixer for Tile Entities DataVersion {} -> {}", (Object)minecraftDataVersion, (Object)MINECRAFT_DATA_VERSION);
            for (BlockPos key : oldTE.keySet()) {
                newTE.put(key, SchematicConversionMaps.updateBlockEntity(SchematicConversionMaps.checkForIdTag(oldTE.get(key)), minecraftDataVersion));
            }
            return newTE;
        }
        return oldTE;
    }

    private ListTag convertEntities_to_1_20_5(ListTag oldEntitiesList, int minecraftDataVersion) {
        if (minecraftDataVersion < 1139) {
            minecraftDataVersion = 1139;
        }
        if (minecraftDataVersion < MINECRAFT_DATA_VERSION) {
            ListTag newEntitiesList = new ListTag();
            int size = oldEntitiesList.size();
            Servux.LOGGER.info("LitematicaSchematic: executing Vanilla DataFixer for Entities DataVersion {} -> {}", (Object)minecraftDataVersion, (Object)MINECRAFT_DATA_VERSION);
            for (int i = 0; i < size; ++i) {
                newEntitiesList.add((Object)SchematicConversionMaps.updateEntity(oldEntitiesList.getCompoundOrEmpty(i), minecraftDataVersion));
            }
            return newEntitiesList;
        }
        return oldEntitiesList;
    }

    private List<EntityInfo> convertSpongeEntities_to_1_20_5(List<EntityInfo> oldEntitiesList, int minecraftDataVersion) {
        if (minecraftDataVersion < 1139) {
            minecraftDataVersion = 1139;
        }
        if (minecraftDataVersion < MINECRAFT_DATA_VERSION) {
            ArrayList<EntityInfo> newEntitiesList = new ArrayList<EntityInfo>();
            Servux.LOGGER.info("SpongeSchematic: executing Vanilla DataFixer for Entities DataVersion {} -> {}", (Object)minecraftDataVersion, (Object)MINECRAFT_DATA_VERSION);
            for (EntityInfo oldEntityInfo : oldEntitiesList) {
                newEntitiesList.add(new EntityInfo(oldEntityInfo.posVec, SchematicConversionMaps.updateEntity(oldEntityInfo.nbt, minecraftDataVersion)));
            }
            return newEntitiesList;
        }
        return oldEntitiesList;
    }

    private List<EntityInfo> readEntitiesFromNBT_v1(ListTag tagList) {
        ArrayList<EntityInfo> entityList = new ArrayList<EntityInfo>();
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            CompoundTag tag = tagList.getCompoundOrEmpty(i);
            Vec3 posVec = fi.dy.masa.servux.util.nbt.NbtUtils.readVec3d(tag);
            CompoundTag entityData = tag.getCompoundOrEmpty("EntityData");
            if (posVec == null || entityData.isEmpty()) continue;
            fi.dy.masa.servux.util.nbt.NbtUtils.putVec3dCodec(entityData, posVec, "Pos");
            entityList.add(new EntityInfo(posVec, entityData));
        }
        return entityList;
    }

    private Map<BlockPos, CompoundTag> readTileEntitiesFromNBT_v1(ListTag tagList) {
        HashMap<BlockPos, CompoundTag> tileMap = new HashMap<BlockPos, CompoundTag>();
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            CompoundTag tag = tagList.getCompoundOrEmpty(i);
            CompoundTag tileNbt = tag.getCompoundOrEmpty("TileNBT");
            BlockPos pos = fi.dy.masa.servux.util.nbt.NbtUtils.readBlockPos(tag);
            if (pos == null || tileNbt.isEmpty()) continue;
            fi.dy.masa.servux.util.nbt.NbtUtils.writeBlockPosToTag((Vec3i)pos, tileNbt);
            tileMap.put(pos, tileNbt);
        }
        return tileMap;
    }

    public boolean writeToFile(Path dir, String fileNameIn, boolean override) {
        return this.writeToFile(dir, fileNameIn, override, false);
    }

    public boolean writeToFile(Path dir, String fileNameIn, boolean override, boolean downgrade) {
        Object fileName = fileNameIn;
        if (!((String)fileName).endsWith(FILE_EXTENSION)) {
            fileName = (String)fileName + FILE_EXTENSION;
        }
        Path fileSchematic = dir.resolve((String)fileName);
        try {
            if (!Files.exists(dir, new LinkOption[0])) {
                Files.createDirectory(dir, new FileAttribute[0]);
            }
            if (!Files.isDirectory(dir, new LinkOption[0])) {
                return false;
            }
            if (!override && Files.exists(fileSchematic, new LinkOption[0])) {
                return false;
            }
            fi.dy.masa.servux.util.nbt.NbtUtils.writeCompressed(this.writeToNBT(), fileSchematic);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean readFromFile() {
        return this.readFromFile(this.schematicType);
    }

    private boolean readFromFile(FileType schematicType) {
        try {
            CompoundTag nbt = LitematicaSchematic.readNbtFromFile(this.schematicFile);
            if (nbt != null) {
                if (schematicType == FileType.SPONGE_SCHEMATIC) {
                    String name = FileUtils.getNameWithoutExtension(this.schematicFile.getFileName().toString()) + " (Converted Sponge)";
                    return this.readFromSpongeSchematic(name, nbt);
                }
                if (schematicType == FileType.VANILLA_STRUCTURE) {
                    String name = FileUtils.getNameWithoutExtension(this.schematicFile.getFileName().toString()) + " (Converted Structure)";
                    return this.readFromVanillaStructure(name, nbt);
                }
                if (schematicType == FileType.LITEMATICA_SCHEMATIC) {
                    return this.readFromNBT(nbt, true);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static CompoundTag readNbtFromFile(Path file) {
        if (file == null) {
            return null;
        }
        if (!Files.exists(file, new LinkOption[0]) || !Files.isReadable(file)) {
            return null;
        }
        return fi.dy.masa.servux.util.nbt.NbtUtils.readNbtFromFileAsPath(file);
    }

    public static Path fileFromDirAndName(Path dir, String fileName, FileType schematicType) {
        if (!((String)fileName).endsWith(FILE_EXTENSION) && schematicType == FileType.LITEMATICA_SCHEMATIC) {
            fileName = (String)fileName + FILE_EXTENSION;
        }
        return dir.resolve((String)fileName);
    }

    @Nullable
    public static LitematicaSchematic createFromFile(Path dir, String fileName) {
        return LitematicaSchematic.createFromFile(dir, fileName, FileType.LITEMATICA_SCHEMATIC);
    }

    @Nullable
    public static LitematicaSchematic createFromFile(Path dir, String fileName, FileType schematicType) {
        Path file = LitematicaSchematic.fileFromDirAndName(dir, fileName, schematicType);
        LitematicaSchematic schematic = new LitematicaSchematic(file, schematicType);
        return schematic.readFromFile(schematicType) ? schematic : null;
    }

    public static class SchematicSaveInfo {
        public final boolean visibleOnly;
        public final boolean includeSupportBlocks;
        public final boolean ignoreEntities;
        public final boolean fromSchematicWorld;

        public SchematicSaveInfo(boolean visibleOnly, boolean ignoreEntities) {
            this(visibleOnly, false, ignoreEntities, false);
        }

        public SchematicSaveInfo(boolean visibleOnly, boolean includeSupportBlocks, boolean ignoreEntities, boolean fromSchematicWorld) {
            this.visibleOnly = visibleOnly;
            this.includeSupportBlocks = includeSupportBlocks;
            this.ignoreEntities = ignoreEntities;
            this.fromSchematicWorld = fromSchematicWorld;
        }
    }

    public static class EntityInfo {
        public final Vec3 posVec;
        public final CompoundTag nbt;

        public EntityInfo(Vec3 posVec, CompoundTag nbt) {
            this.posVec = posVec;
            if (nbt.contains("SleepingX")) {
                nbt.putInt("SleepingX", Mth.floor((double)posVec.x));
            }
            if (nbt.contains("SleepingY")) {
                nbt.putInt("SleepingY", Mth.floor((double)posVec.y));
            }
            if (nbt.contains("SleepingZ")) {
                nbt.putInt("SleepingZ", Mth.floor((double)posVec.z));
            }
            this.nbt = nbt;
        }
    }
}

