/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.schematic.placement;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fi.dy.masa.servux.Servux;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;

public class SubRegionPlacement {
    public static final Codec<SubRegionPlacement> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)PrimitiveCodec.STRING.fieldOf("Name").forGetter(get -> get.name), (App)BlockPos.CODEC.fieldOf("DefaultPos").forGetter(get -> get.defaultPos), (App)BlockPos.CODEC.fieldOf("Pos").forGetter(get -> get.pos), (App)Rotation.CODEC.fieldOf("Rotation").forGetter(get -> get.rotation), (App)Mirror.CODEC.fieldOf("Mirror").forGetter(get -> get.mirror), (App)PrimitiveCodec.BOOL.fieldOf("Enabled").forGetter(get -> get.enabled), (App)PrimitiveCodec.BOOL.fieldOf("RenderingEnabled").forGetter(get -> get.renderingEnabled), (App)PrimitiveCodec.BOOL.fieldOf("IgnoreEntities").forGetter(get -> get.ignoreEntities), (App)PrimitiveCodec.INT.fieldOf("CoordinateLockMask").forGetter(get -> get.coordinateLockMask)).apply((Applicative)inst, SubRegionPlacement::new));
    public static final StreamCodec<ByteBuf, Mirror> BLOCK_MIRROR_PACKET_CODEC = ByteBufCodecs.STRING_UTF8.map(Mirror::valueOf, Mirror::getSerializedName);
    public static final StreamCodec<ByteBuf, SubRegionPlacement> PACKET_CODEC = new StreamCodec<ByteBuf, SubRegionPlacement>(){

        public void encode(ByteBuf buf, SubRegionPlacement value) {
            ByteBufCodecs.STRING_UTF8.encode((Object)buf, (Object)value.name);
            BlockPos.STREAM_CODEC.encode((Object)buf, (Object)value.defaultPos);
            BlockPos.STREAM_CODEC.encode((Object)buf, (Object)value.pos);
            Rotation.STREAM_CODEC.encode((Object)buf, (Object)value.rotation);
            BLOCK_MIRROR_PACKET_CODEC.encode((Object)buf, (Object)value.mirror);
            ByteBufCodecs.BOOL.encode((Object)buf, (Object)value.enabled);
            ByteBufCodecs.BOOL.encode((Object)buf, (Object)value.renderingEnabled);
            ByteBufCodecs.BOOL.encode((Object)buf, (Object)value.ignoreEntities);
            ByteBufCodecs.INT.encode((Object)buf, (Object)value.coordinateLockMask);
        }

        public SubRegionPlacement decode(ByteBuf buf) {
            return new SubRegionPlacement((String)ByteBufCodecs.STRING_UTF8.decode((Object)buf), (BlockPos)BlockPos.STREAM_CODEC.decode((Object)buf), (BlockPos)BlockPos.STREAM_CODEC.decode((Object)buf), (Rotation)Rotation.STREAM_CODEC.decode((Object)buf), (Mirror)BLOCK_MIRROR_PACKET_CODEC.decode((Object)buf), (Boolean)ByteBufCodecs.BOOL.decode((Object)buf), (Boolean)ByteBufCodecs.BOOL.decode((Object)buf), (Boolean)ByteBufCodecs.BOOL.decode((Object)buf), (Integer)ByteBufCodecs.INT.decode((Object)buf));
        }
    };
    private final String name;
    private final BlockPos defaultPos;
    private BlockPos pos;
    public Rotation rotation = Rotation.NONE;
    public Mirror mirror = Mirror.NONE;
    public boolean enabled = true;
    private boolean renderingEnabled = false;
    public boolean ignoreEntities;
    private int coordinateLockMask;

    public SubRegionPlacement(BlockPos pos, String name) {
        this.pos = pos;
        this.defaultPos = pos;
        this.name = name;
    }

    private SubRegionPlacement(String name, BlockPos defPos, BlockPos pos, Rotation rot, Mirror mirror, Boolean enabled, Boolean renderingEnabled, Boolean ignoreEntities, Integer coordinateLockMask) {
        this(defPos, name);
        this.pos = pos;
        this.rotation = rot;
        this.mirror = mirror;
        this.enabled = enabled;
        this.renderingEnabled = renderingEnabled;
        this.ignoreEntities = ignoreEntities;
        this.coordinateLockMask = coordinateLockMask;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean ignoreEntities() {
        return this.ignoreEntities;
    }

    public boolean matchesRequirement(RequiredEnabled required) {
        if (required == RequiredEnabled.ANY) {
            return true;
        }
        if (required == RequiredEnabled.PLACEMENT_ENABLED) {
            return this.isEnabled();
        }
        Servux.LOGGER.warn("RequiredEnabled.RENDERING_ENABLED is not supported on server side!");
        return false;
    }

    public String getName() {
        return this.name;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public Mirror getMirror() {
        return this.mirror;
    }

    void toggleIgnoreEntities() {
        this.ignoreEntities = !this.ignoreEntities;
    }

    void setPos(BlockPos pos) {
        this.pos = pos;
    }

    void setRotation(Rotation rotation) {
        this.rotation = rotation;
    }

    void setMirror(Mirror mirror) {
        this.mirror = mirror;
    }

    void resetToOriginalValues() {
        this.pos = this.defaultPos;
        this.rotation = Rotation.NONE;
        this.mirror = Mirror.NONE;
        this.enabled = true;
        this.ignoreEntities = false;
    }

    public boolean isRegionPlacementModifiedFromDefault() {
        return this.isRegionPlacementModified(this.defaultPos);
    }

    public boolean isRegionPlacementModified(BlockPos originalPosition) {
        return !this.isEnabled() || this.ignoreEntities() || this.getMirror() != Mirror.NONE || this.getRotation() != Rotation.NONE || !this.getPos().equals((Object)originalPosition);
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        JsonArray arr = new JsonArray();
        arr.add((Number)this.pos.getX());
        arr.add((Number)this.pos.getY());
        arr.add((Number)this.pos.getZ());
        obj.add("pos", (JsonElement)arr);
        obj.add("name", (JsonElement)new JsonPrimitive(this.getName()));
        obj.add("rotation", (JsonElement)new JsonPrimitive(this.rotation.name()));
        obj.add("mirror", (JsonElement)new JsonPrimitive(this.mirror.name()));
        obj.add("locked_coords", (JsonElement)new JsonPrimitive((Number)0));
        obj.add("enabled", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.enabled)));
        obj.add("rendering_enabled", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        obj.add("ignore_entities", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.ignoreEntities)));
        return obj;
    }

    public static enum RequiredEnabled {
        ANY,
        PLACEMENT_ENABLED,
        RENDERING_ENABLED;

    }
}

