/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.dataproviders;

import fi.dy.masa.servux.Reference;
import fi.dy.masa.servux.Servux;
import fi.dy.masa.servux.dataproviders.DataProviderBase;
import fi.dy.masa.servux.dataproviders.IDataProvider;
import fi.dy.masa.servux.network.IPluginServerPlayHandler;
import fi.dy.masa.servux.network.ServerPlayHandler;
import fi.dy.masa.servux.network.packet.ServuxLitematicaHandler;
import fi.dy.masa.servux.network.packet.ServuxLitematicaPacket;
import fi.dy.masa.servux.schematic.LitematicaSchematic;
import fi.dy.masa.servux.schematic.placement.SchematicPlacement;
import fi.dy.masa.servux.schematic.transmit.SchematicBufferManager;
import fi.dy.masa.servux.settings.IServuxSetting;
import fi.dy.masa.servux.settings.ServuxBoolSetting;
import fi.dy.masa.servux.settings.ServuxIntSetting;
import fi.dy.masa.servux.util.EntityUtils;
import fi.dy.masa.servux.util.LayerRange;
import fi.dy.masa.servux.util.PasteLayerBehavior;
import fi.dy.masa.servux.util.ReplaceBehavior;
import fi.dy.masa.servux.util.StringUtils;
import fi.dy.masa.servux.util.nbt.NbtUtils;
import fi.dy.masa.servux.util.nbt.NbtView;
import fi.dy.masa.servux.util.position.PositionUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;

public class LitematicsDataProvider
extends DataProviderBase {
    public static final LitematicsDataProvider INSTANCE = new LitematicsDataProvider();
    protected static final ServuxLitematicaHandler<ServuxLitematicaPacket.Payload> HANDLER = ServuxLitematicaHandler.getInstance();
    protected final CompoundTag metadata = new CompoundTag();
    protected ServuxIntSetting permissionLevel = new ServuxIntSetting((IDataProvider)this, "permission_level", 0, 4, 0);
    protected ServuxIntSetting pastePermissionLevel = new ServuxIntSetting((IDataProvider)this, "permission_level_paste", 0, 4, 0);
    public ServuxBoolSetting fixRaiLRotations = new ServuxBoolSetting(this, "fix_rail_rotations", true);
    public ServuxBoolSetting fixStairMirror = new ServuxBoolSetting(this, "fix_stairs_mirror", true);
    public ServuxBoolSetting fixChestMirror = new ServuxBoolSetting(this, "fix_chest_mirror", true);
    private final List<IServuxSetting<?>> settings = List.of(this.permissionLevel, this.pastePermissionLevel, this.fixRaiLRotations, this.fixStairMirror, this.fixChestMirror);
    private final List<UUID> invalidPlayers = new ArrayList<UUID>();
    private final SchematicBufferManager bufferManager = new SchematicBufferManager();
    private final Path transmitDir;

    protected LitematicsDataProvider() {
        super("litematic_data", ServuxLitematicaHandler.CHANNEL_ID, 1, 0, "servux.provider.litematic_data", "Litematics Data provider.");
        this.metadata.putString("name", this.getName());
        this.metadata.putString("id", this.getNetworkChannel().toString());
        this.metadata.putInt("version", this.getProtocolVersion());
        this.metadata.putString("servux", Reference.MOD_STRING);
        this.transmitDir = this.getTransmitDir();
    }

    @Override
    public List<IServuxSetting<?>> getSettings() {
        return this.settings;
    }

    @Override
    public void registerHandler() {
        ServerPlayHandler.getInstance().registerServerPlayHandler(HANDLER);
        if (!this.isRegistered()) {
            HANDLER.registerPlayPayload(ServuxLitematicaPacket.Payload.ID, ServuxLitematicaPacket.Payload.CODEC, 3);
            this.setRegistered(true);
        }
        HANDLER.registerPlayReceiver(ServuxLitematicaPacket.Payload.ID, (ServerPlayNetworking.PlayPayloadHandler<ServuxLitematicaPacket.Payload>)((ServerPlayNetworking.PlayPayloadHandler)HANDLER::receivePlayPayload));
    }

    @Override
    public void unregisterHandler() {
        HANDLER.unregisterPlayReceiver();
        ServerPlayHandler.getInstance().unregisterServerPlayHandler(HANDLER);
    }

    @Override
    public IPluginServerPlayHandler<?> getPacketHandler() {
        return HANDLER;
    }

    public SchematicBufferManager getBufferManager() {
        return this.bufferManager;
    }

    public Path getTransmitDir() {
        Path dir;
        Path path = dir = this.transmitDir != null ? this.transmitDir : Reference.DEFAULT_RUN_DIR.resolve("schematics").normalize();
        if (!Files.exists(dir, new LinkOption[0]) || !Files.isDirectory(dir, new LinkOption[0])) {
            try {
                if (Files.exists(dir, new LinkOption[0])) {
                    Files.delete(dir);
                }
                Files.createDirectory(dir, new FileAttribute[0]);
                Servux.LOGGER.warn("getTransmitDir(): Created schematic transmit directory '{}'", (Object)dir.toAbsolutePath().toString());
            }
            catch (IOException err) {
                Servux.LOGGER.error("getTransmitDir(): Fatal exception creating schematic transmit dir '{}'; {}", (Object)dir.toAbsolutePath().toString(), (Object)err.getLocalizedMessage());
                throw new RuntimeException(err);
            }
        }
        if (!Files.isWritable(dir)) {
            Servux.LOGGER.error("Schematic transmit directory '{}'; is not writeable.", (Object)dir.toAbsolutePath().toString());
        }
        Servux.debugLog("getTransmitDir(): Schematic transmit directory debug '{}'", dir.toAbsolutePath().toString());
        return dir;
    }

    @Override
    public boolean isPlayerRegistered(ServerPlayer player) {
        return !this.isPlayerInvalid(player);
    }

    public void sendMetadata(ServerPlayer player) {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.hasPermission(player)) {
            Servux.debugLog("litematic_data: Denying access for player {}, Insufficient Permissions", player.getName().tryCollapseToString());
            return;
        }
        Servux.debugLog("litematic_data: sendMetadata to player {}", player.getName().tryCollapseToString());
        if (player.connection != null) {
            HANDLER.sendPlayPayload(player.connection, new ServuxLitematicaPacket.Payload(ServuxLitematicaPacket.MetadataResponse(this.metadata)));
        } else {
            HANDLER.sendPlayPayload(player, new ServuxLitematicaPacket.Payload(ServuxLitematicaPacket.MetadataResponse(this.metadata)));
        }
    }

    public void onPacketFailure(ServerPlayer player) {
        this.setPlayerInvalid(player);
    }

    public void removePlayer(ServerPlayer player) {
        this.removeInvalidPlayer(player);
    }

    private void setPlayerInvalid(ServerPlayer player) {
        if (!this.invalidPlayers.contains(player.getUUID())) {
            this.invalidPlayers.add(player.getUUID());
        }
    }

    private boolean isPlayerInvalid(ServerPlayer player) {
        return this.invalidPlayers.contains(player.getUUID());
    }

    private void removeInvalidPlayer(ServerPlayer player) {
        this.invalidPlayers.remove(player.getUUID());
    }

    public void onBlockEntityRequest(ServerPlayer player, BlockPos pos) {
        if (!this.hasPermission(player) || !this.isEnabled()) {
            return;
        }
        BlockEntity be = player.level().getBlockEntity(pos);
        CompoundTag nbt = be != null ? be.saveWithFullMetadata((HolderLookup.Provider)player.registryAccess()) : new CompoundTag();
        HANDLER.encodeServerData(player, ServuxLitematicaPacket.SimpleBlockResponse(pos, nbt));
    }

    public void onEntityRequest(ServerPlayer player, int entityId) {
        if (!this.hasPermission(player) || !this.isEnabled()) {
            return;
        }
        Entity entity = player.level().getEntity(entityId);
        if (entity != null) {
            NbtView view = NbtView.getWriter(player.level().registryAccess());
            ResourceLocation id = EntityType.getKey((EntityType)entity.getType());
            entity.saveWithoutId(view.getWriter());
            CompoundTag nbt = view.readNbt();
            if (nbt != null && id != null) {
                nbt.putString("id", id.toString());
                HANDLER.encodeServerData(player, ServuxLitematicaPacket.SimpleEntityResponse(entityId, nbt));
            }
        }
    }

    public void onBulkEntityRequest(ServerPlayer player, ChunkPos chunkPos, CompoundTag req) {
        ChunkAccess chunk;
        if (!this.hasPermission(player) || !this.isEnabled()) {
            return;
        }
        if (req == null || req.isEmpty()) {
            return;
        }
        ServerLevel world = player.level();
        ChunkAccess chunkAccess = chunk = world != null ? world.getChunk(chunkPos.x, chunkPos.z, ChunkStatus.FULL, false) : null;
        if (chunk == null) {
            return;
        }
        if (req.contains("Task") && req.getStringOr("Task", "").equals("BulkEntityRequest") || !req.contains("Task")) {
            Servux.debugLog("litematic_data: Sending Bulk NBT Data for ChunkPos [{}] to player {}", chunkPos.toString(), player.getName().tryCollapseToString());
            long timeStart = System.currentTimeMillis();
            ListTag tileList = new ListTag();
            ListTag entityList = new ListTag();
            int minY = req.getIntOr("minY", -64);
            int maxY = req.getIntOr("maxY", 319);
            BlockPos pos1 = new BlockPos(chunkPos.getMinBlockX(), minY, chunkPos.getMinBlockZ());
            BlockPos pos2 = new BlockPos(chunkPos.getMaxBlockX(), maxY, chunkPos.getMaxBlockZ());
            AABB bb = PositionUtils.createEnclosingAABB(pos1, pos2);
            Set teSet = chunk.getBlockEntitiesPos();
            List entities = world.getEntities(null, bb, EntityUtils.NOT_PLAYER);
            for (BlockPos tePos : teSet) {
                if (tePos.getX() < chunkPos.getMinBlockX() || tePos.getX() > chunkPos.getMaxBlockX() || tePos.getZ() < chunkPos.getMinBlockZ() || tePos.getZ() > chunkPos.getMaxBlockZ() || tePos.getY() < minY || tePos.getY() > maxY) continue;
                BlockEntity be = world.getBlockEntity(tePos);
                CompoundTag beTag = be != null ? be.saveWithFullMetadata((HolderLookup.Provider)player.registryAccess()) : new CompoundTag();
                tileList.add((Object)beTag);
            }
            for (Entity entity : entities) {
                NbtView view = NbtView.getWriter(player.level().registryAccess());
                ResourceLocation id = EntityType.getKey((EntityType)entity.getType());
                entity.saveWithoutId(view.getWriter());
                CompoundTag entTag = view.readNbt();
                if (entTag == null || id == null) continue;
                Vec3 posVec = new Vec3(entity.getX() - (double)pos1.getX(), entity.getY() - (double)pos1.getY(), entity.getZ() - (double)pos1.getZ());
                entTag.putString("id", id.toString());
                NbtUtils.writeEntityPositionToTag(posVec, entTag);
                entTag.putInt("entityId", entity.getId());
                entityList.add((Object)entTag);
            }
            CompoundTag output = new CompoundTag();
            output.putString("Task", "BulkEntityReply");
            output.put("TileEntities", (Tag)tileList);
            output.put("Entities", (Tag)entityList);
            output.putInt("chunkX", chunkPos.x);
            output.putInt("chunkZ", chunkPos.z);
            long timeElapsed = System.currentTimeMillis() - timeStart;
            HANDLER.encodeServerData(player, ServuxLitematicaPacket.ResponseS2CStart(output));
        }
    }

    public void handleClientPasteRequest(ServerPlayer player, int transactionId, CompoundTag tags) {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.hasPermission(player) || !this.hasPermissionsForPaste(player)) {
            Servux.debugLog("litematic_data: Denying Litematic Paste for player {}, Insufficient Permissions.", player.getName().tryCollapseToString());
            player.sendSystemMessage((Component)StringUtils.translate("servux.litematics.error.insufficent_for_paste", new Object[0]));
            return;
        }
        if (!player.isCreative()) {
            Servux.debugLog("litematic_data: Denying Litematic Paste for player {}, Player is not in Creative Mode.", player.getName().tryCollapseToString());
            player.sendSystemMessage((Component)StringUtils.translate("servux.litematics.error.creative_required", new Object[0]));
            return;
        }
        if (tags.getStringOr("Task", "").equals("LitematicaPaste")) {
            Servux.debugLog("litematic_data: Servux Paste request from player {}", player.getName().tryCollapseToString());
            long timeStart = System.currentTimeMillis();
            SchematicPlacement placement = SchematicPlacement.createFromNbt(tags);
            ReplaceBehavior replaceMode = ReplaceBehavior.fromStringStatic(tags.getStringOr("ReplaceMode", ReplaceBehavior.NONE.name()));
            PasteLayerBehavior layerBehavior = PasteLayerBehavior.fromStringStatic(tags.getStringOr("PasteLayerBehavior", PasteLayerBehavior.ALL.name()));
            LayerRange layerRange = tags.read("RenderLayerRange", LayerRange.CODEC).orElse(null);
            placement.pasteTo(player.level(), replaceMode, layerBehavior, layerRange);
            long timeElapsed = System.currentTimeMillis() - timeStart;
            player.displayClientMessage((Component)StringUtils.translate("servux.litematics.success.pasted", placement.getName(), player.level().dimension().location().toString(), timeElapsed), false);
        }
    }

    public void handleClientPasteRequestPair(ServerPlayer player, int transactionId, Pair<LitematicaSchematic, CompoundTag> schemPair) {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.hasPermission(player) || !this.hasPermissionsForPaste(player)) {
            Servux.debugLog("litematic_data: Denying Litematic Paste for player {}, Insufficient Permissions.", player.getName().tryCollapseToString());
            player.sendSystemMessage((Component)StringUtils.translate("servux.litematics.error.insufficent_for_paste", new Object[0]));
            return;
        }
        if (!player.isCreative()) {
            Servux.debugLog("litematic_data: Denying Litematic Paste for player {}, Player is not in Creative Mode.", player.getName().tryCollapseToString());
            player.sendSystemMessage((Component)StringUtils.translate("servux.litematics.error.creative_required", new Object[0]));
            return;
        }
        if (schemPair.getLeft() != null) {
            Servux.debugLog("litematic_data: Servux Paste (Pair) request from player {}", player.getName().tryCollapseToString());
            long timeStart = System.currentTimeMillis();
            CompoundTag tags = (CompoundTag)schemPair.getRight();
            SchematicPlacement placement = SchematicPlacement.createFromNbt((LitematicaSchematic)schemPair.getLeft(), tags);
            ReplaceBehavior replaceMode = ReplaceBehavior.fromStringStatic(tags.getStringOr("ReplaceMode", ReplaceBehavior.NONE.name()));
            PasteLayerBehavior layerBehavior = PasteLayerBehavior.fromStringStatic(tags.getStringOr("PasteLayerBehavior", PasteLayerBehavior.ALL.name()));
            LayerRange layerRange = tags.read("RenderLayerRange", LayerRange.CODEC).orElse(null);
            placement.pasteTo(player.level(), replaceMode, layerBehavior, layerRange);
            long timeElapsed = System.currentTimeMillis() - timeStart;
            player.displayClientMessage((Component)StringUtils.translate("servux.litematics.success.pasted", placement.getName(), player.level().dimension().location().toString(), timeElapsed), false);
        }
    }

    @Override
    public boolean hasPermission(ServerPlayer player) {
        return Permissions.check((Entity)player, (String)this.permNode, (int)((Integer)this.permissionLevel.getValue()));
    }

    @Override
    public void onTickEndPre() {
    }

    @Override
    public void onTickEndPost() {
    }

    public boolean hasPermissionsForPaste(ServerPlayer player) {
        return this.hasPermission(player) && Permissions.check((Entity)player, (String)(this.permNode + ".paste"), (int)((Integer)this.pastePermissionLevel.getValue()));
    }
}

