/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.loggers;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import fi.dy.masa.servux.loggers.DataLogger;
import fi.dy.masa.servux.loggers.DataLoggerBase;
import fi.dy.masa.servux.loggers.data.MobCapData;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.NaturalSpawner;

public class DataLoggerMobCaps
extends DataLoggerBase<CompoundTag> {
    public static final Codec<CompoundTag> CODEC = CompoundTag.CODEC;

    public DataLoggerMobCaps(DataLogger type) {
        super(type);
    }

    @Override
    public CompoundTag getResult(MinecraftServer server) {
        CompoundTag nbt = new CompoundTag();
        for (ServerLevel world : server.getAllLevels()) {
            String dimKey = world.dimension().location().toString();
            MobCapData mobCapData = new MobCapData();
            MobCapData.Cap[] data = MobCapData.createCapArray();
            NaturalSpawner.SpawnState info = world.getChunkSource().getLastSpawnState();
            if (info == null) continue;
            int spawnableChunks = world.getChunkSource().chunkMap.getDistanceManager().getNaturalSpawnChunkCount();
            int divisor = 289;
            long worldTime = world.getGameTime();
            if (spawnableChunks <= 0) continue;
            for (Object2IntMap.Entry entry : info.getMobCategoryCounts().object2IntEntrySet()) {
                MobCapData.EntityCategory category = MobCapData.EntityCategory.fromVanillaCategory((MobCategory)entry.getKey());
                int current = entry.getIntValue();
                int capacity = ((MobCategory)entry.getKey()).getMaxInstancesPerChunk() * spawnableChunks / divisor;
                data[category.ordinal()].setCurrentAndCap(current, capacity);
                for (MobCapData.EntityCategory type : MobCapData.EntityCategory.values()) {
                    MobCapData.Cap cap = data[type.ordinal()];
                    mobCapData.setCurrentAndCapValues(type, cap.getCurrent(), cap.getCap(), worldTime);
                }
            }
            try {
                CompoundTag nbtEntry = (CompoundTag)MobCapData.CODEC.encodeStart((DynamicOps)world.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)mobCapData).getPartialOrThrow();
                nbtEntry.putLong("WorldTick", worldTime);
                nbt.put(dimKey, (Tag)nbtEntry);
            }
            catch (Exception exception) {}
        }
        return nbt;
    }
}

