/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.mixin.block;

import fi.dy.masa.servux.dataproviders.LitematicsDataProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={StairBlock.class})
public abstract class MixinStairsBlock
extends Block {
    public MixinStairsBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Inject(method={"mirror(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/Mirror;)Lnet/minecraft/world/level/block/state/BlockState;"}, at={@At(value="HEAD")}, cancellable=true)
    private void servux_fixStairsMirror(BlockState state, Mirror mirror, CallbackInfoReturnable<BlockState> cir) {
        if (LitematicsDataProvider.INSTANCE.isEnabled() && ((Boolean)LitematicsDataProvider.INSTANCE.fixStairMirror.getValue()).booleanValue()) {
            Direction direction = (Direction)state.getValue((Property)StairBlock.FACING);
            StairsShape stairShape = (StairsShape)state.getValue((Property)StairBlock.SHAPE);
            if (direction.getAxis() == Direction.Axis.X && mirror == Mirror.FRONT_BACK) {
                cir.setReturnValue((Object)(switch (stairShape) {
                    case StairsShape.INNER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue((Property)StairBlock.SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    case StairsShape.INNER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue((Property)StairBlock.SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    case StairsShape.OUTER_LEFT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue((Property)StairBlock.SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    case StairsShape.OUTER_RIGHT -> (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue((Property)StairBlock.SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    default -> state.rotate(Rotation.CLOCKWISE_180);
                }));
                cir.cancel();
            } else if (direction.getAxis() == Direction.Axis.X && mirror == Mirror.LEFT_RIGHT || direction.getAxis() == Direction.Axis.Z && mirror == Mirror.FRONT_BACK) {
                cir.setReturnValue((Object)(switch (stairShape) {
                    case StairsShape.INNER_LEFT -> (BlockState)state.setValue((Property)StairBlock.SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    case StairsShape.INNER_RIGHT -> (BlockState)state.setValue((Property)StairBlock.SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    case StairsShape.OUTER_LEFT -> (BlockState)state.setValue((Property)StairBlock.SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    case StairsShape.OUTER_RIGHT -> (BlockState)state.setValue((Property)StairBlock.SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    default -> state;
                }));
                cir.cancel();
            }
        }
    }
}

