/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.network.packet;

import fi.dy.masa.servux.Servux;
import fi.dy.masa.servux.dataproviders.HudDataProvider;
import fi.dy.masa.servux.dataproviders.StructureDataProvider;
import fi.dy.masa.servux.network.IPluginServerPlayHandler;
import fi.dy.masa.servux.network.PacketSplitter;
import fi.dy.masa.servux.network.packet.ServuxStructuresPacket;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;

public abstract class ServuxStructuresHandler<T extends CustomPacketPayload>
implements IPluginServerPlayHandler<T> {
    private static final ServuxStructuresHandler<ServuxStructuresPacket.Payload> INSTANCE = new ServuxStructuresHandler<ServuxStructuresPacket.Payload>(){

        public void receive(ServuxStructuresPacket.Payload payload, ServerPlayNetworking.Context context) {
            INSTANCE.receivePlayPayload(payload, context);
        }
    };
    public static final ResourceLocation CHANNEL_ID = ResourceLocation.fromNamespaceAndPath((String)"servux", (String)"structures");
    private boolean payloadRegistered = false;
    private final Map<UUID, Integer> failures = new HashMap<UUID, Integer>();
    private static final int MAX_FAILURES = 4;

    public static ServuxStructuresHandler<ServuxStructuresPacket.Payload> getInstance() {
        return INSTANCE;
    }

    @Override
    public ResourceLocation getPayloadChannel() {
        return CHANNEL_ID;
    }

    @Override
    public boolean isPlayRegistered(ResourceLocation channel) {
        if (channel.equals((Object)CHANNEL_ID)) {
            return this.payloadRegistered;
        }
        return false;
    }

    @Override
    public void setPlayRegistered(ResourceLocation channel) {
        if (channel.equals((Object)CHANNEL_ID)) {
            this.payloadRegistered = true;
        }
    }

    public void decodeStructuresPacket(ResourceLocation channel, ServerPlayer player, ServuxStructuresPacket packet) {
        if (!channel.equals((Object)CHANNEL_ID)) {
            return;
        }
        switch (packet.getType()) {
            case PACKET_C2S_STRUCTURES_REGISTER: {
                Servux.debugLog("decodeStructuresPacket(): received Structures Register from player {}", player.getName().tryCollapseToString());
                StructureDataProvider.INSTANCE.unregister(player);
                StructureDataProvider.INSTANCE.register(player);
                break;
            }
            case PACKET_C2S_REQUEST_SPAWN_METADATA: {
                HudDataProvider.INSTANCE.refreshSpawnMetadata(player, packet.getCompound());
                break;
            }
            case PACKET_C2S_STRUCTURES_UNREGISTER: {
                Servux.debugLog("decodeStructuresPacket(): received Structures Un-Register from player {}", player.getName().tryCollapseToString());
                StructureDataProvider.INSTANCE.unregister(player);
                break;
            }
            default: {
                Servux.LOGGER.warn("decodeStructuresPacket(): Invalid packetType '{}' from player: {}, of size in bytes: {}.", (Object)packet.getPacketType(), (Object)player.getName().tryCollapseToString(), (Object)packet.getTotalSize());
            }
        }
    }

    @Override
    public void reset(ResourceLocation channel) {
        if (channel.equals((Object)CHANNEL_ID)) {
            this.failures.clear();
        }
    }

    public void resetFailures(ResourceLocation channel, ServerPlayer player) {
        if (channel.equals((Object)CHANNEL_ID)) {
            this.failures.remove(player.getUUID());
        }
    }

    @Override
    public void receivePlayPayload(T payload, ServerPlayNetworking.Context ctx) {
        if (payload.type().id().equals((Object)CHANNEL_ID)) {
            ServerPlayer player = ctx.player();
            INSTANCE.decodeStructuresPacket(CHANNEL_ID, player, ((ServuxStructuresPacket.Payload)payload).data());
        }
    }

    @Override
    public void encodeWithSplitter(ServerPlayer player, FriendlyByteBuf buffer, ServerGamePacketListenerImpl networkHandler) {
        INSTANCE.encodeStructuresPacket(player, new ServuxStructuresPacket(ServuxStructuresPacket.Type.PACKET_S2C_STRUCTURE_DATA, buffer));
    }

    public void encodeStructuresPacket(ServerPlayer player, ServuxStructuresPacket packet) {
        if (!StructureDataProvider.INSTANCE.isEnabled()) {
            return;
        }
        if (packet.getType().equals((Object)ServuxStructuresPacket.Type.PACKET_S2C_STRUCTURE_DATA_START)) {
            FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
            buffer.writeNbt((Tag)packet.getCompound());
            PacketSplitter.send(this, buffer, player, player.connection);
        } else if (!INSTANCE.sendPlayPayload(player, new ServuxStructuresPacket.Payload(packet))) {
            UUID id = player.getUUID();
            if (!this.failures.containsKey(id)) {
                this.failures.put(id, 1);
            } else if (this.failures.get(id) > 4) {
                StructureDataProvider.INSTANCE.unregister(player);
            } else {
                int count = this.failures.get(id) + 1;
                this.failures.put(id, count);
            }
        }
    }
}

