/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.schematic;

import fi.dy.masa.servux.schematic.SchematicSchema;
import fi.dy.masa.servux.util.data.FileType;
import fi.dy.masa.servux.util.data.Schema;
import fi.dy.masa.servux.util.nbt.NbtUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class SchematicMetadata {
    private String name = "?";
    private String author = "?";
    private String description = "";
    private Vec3i enclosingSize = Vec3i.ZERO;
    private long timeCreated;
    private long timeModified;
    protected int minecraftDataVersion;
    protected int schematicVersion;
    protected Schema schema;
    protected FileType type;
    private int regionCount;
    protected int entityCount;
    protected int blockEntityCount;
    private int totalVolume = -1;
    private int totalBlocks = -1;
    private boolean modifiedSinceSaved;
    @Nullable
    protected int[] thumbnailPixelData;

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getDescription() {
        return this.description;
    }

    @Nullable
    public int[] getPreviewImagePixelData() {
        return this.thumbnailPixelData;
    }

    public int getRegionCount() {
        return this.regionCount;
    }

    public int getTotalVolume() {
        return this.totalVolume;
    }

    public int getTotalBlocks() {
        return this.totalBlocks;
    }

    public int getEntityCount() {
        return this.entityCount;
    }

    public int getBlockEntityCount() {
        return this.blockEntityCount;
    }

    public Vec3i getEnclosingSize() {
        return this.enclosingSize;
    }

    public Vec3i getEnclosingSizeAsVanilla() {
        return this.enclosingSize;
    }

    public BlockPos getEnclosingSizeAsBlockPos() {
        return new BlockPos(this.enclosingSize);
    }

    public long getTimeCreated() {
        return this.timeCreated;
    }

    public long getTimeModified() {
        return this.timeModified;
    }

    public int getSchematicVersion() {
        return this.schematicVersion;
    }

    public int getMinecraftDataVersion() {
        return this.minecraftDataVersion;
    }

    public SchematicSchema getSchematicSchema() {
        return new SchematicSchema(this.schematicVersion, this.minecraftDataVersion);
    }

    public Schema getSchema() {
        return this.schema;
    }

    public String getMinecraftVersion() {
        return this.schema.getString();
    }

    public String getSchemaString() {
        return this.schema.toString();
    }

    public FileType getFileType() {
        if (this.type != null) {
            return this.type;
        }
        return FileType.UNKNOWN;
    }

    public boolean hasBeenModified() {
        return this.timeCreated != this.timeModified;
    }

    public boolean wasModifiedSinceSaved() {
        return this.modifiedSinceSaved;
    }

    public void setModifiedSinceSaved() {
        this.modifiedSinceSaved = true;
    }

    public void clearModifiedSinceSaved() {
        this.modifiedSinceSaved = false;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setPreviewImagePixelData(@Nullable int[] pixelData) {
        this.thumbnailPixelData = pixelData;
    }

    public void setRegionCount(int regionCount) {
        this.regionCount = regionCount;
    }

    public void setTotalVolume(int totalVolume) {
        this.totalVolume = totalVolume;
    }

    public void setTotalBlocks(int totalBlocks) {
        this.totalBlocks = totalBlocks;
    }

    public void setEnclosingSize(Vec3i enclosingSize) {
        this.enclosingSize = enclosingSize;
    }

    public void setEnclosingSize(BlockPos enclosingSize) {
        this.enclosingSize = enclosingSize;
    }

    public void setTimeCreated(long timeCreated) {
        this.timeCreated = timeCreated;
    }

    public void setTimeModified(long timeModified) {
        this.timeModified = timeModified;
    }

    public void setTimeModifiedToNow() {
        this.timeModified = System.currentTimeMillis();
    }

    public void setTimeModifiedToNowIfNotRecentlyCreated() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.timeCreated > 600000L) {
            this.timeModified = currentTime;
        }
    }

    public void setSchematicVersion(int version) {
        this.schematicVersion = version;
    }

    public void setMinecraftDataVersion(int minecraftDataVersion) {
        this.minecraftDataVersion = minecraftDataVersion;
        this.schema = Schema.getSchemaByDataVersion(this.minecraftDataVersion);
    }

    public void setSchema() {
        this.schema = Schema.getSchemaByDataVersion(this.minecraftDataVersion);
    }

    public void setFileType(FileType type) {
        this.type = type;
    }

    public void copyFrom(SchematicMetadata other) {
        this.name = other.name;
        this.author = other.author;
        this.description = other.description;
        this.enclosingSize = other.enclosingSize;
        this.timeCreated = other.timeCreated;
        this.timeModified = other.timeModified;
        this.regionCount = other.regionCount;
        this.totalVolume = other.totalVolume;
        this.totalBlocks = other.totalBlocks;
        this.modifiedSinceSaved = false;
        this.schematicVersion = other.schematicVersion;
        this.minecraftDataVersion = other.minecraftDataVersion;
        this.schema = Schema.getSchemaByDataVersion(other.minecraftDataVersion);
        this.type = other.getFileType();
        if (other.thumbnailPixelData != null) {
            this.thumbnailPixelData = new int[other.thumbnailPixelData.length];
            System.arraycopy(other.thumbnailPixelData, 0, this.thumbnailPixelData, 0, this.thumbnailPixelData.length);
        } else {
            this.thumbnailPixelData = null;
        }
    }

    public CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.putString("Name", this.name);
        nbt.putString("Author", this.author);
        nbt.putString("Description", this.description);
        if (this.regionCount > 0) {
            nbt.putInt("RegionCount", this.regionCount);
        }
        if (this.totalVolume > 0) {
            nbt.putInt("TotalVolume", this.totalVolume);
        }
        if (this.totalBlocks >= 0) {
            nbt.putInt("TotalBlocks", this.totalBlocks);
        }
        if (this.timeCreated > 0L) {
            nbt.putLong("TimeCreated", this.timeCreated);
        }
        if (this.timeModified > 0L) {
            nbt.putLong("TimeModified", this.timeModified);
        }
        nbt.put("EnclosingSize", (Tag)NbtUtils.createBlockPosTag(this.enclosingSize));
        if (this.thumbnailPixelData != null) {
            nbt.putIntArray("PreviewImageData", this.thumbnailPixelData);
        }
        return nbt;
    }

    public void readFromNBT(CompoundTag nbt) {
        Vec3i size;
        this.name = nbt.getStringOr("Name", "?");
        this.author = nbt.getStringOr("Author", "?");
        this.description = nbt.getStringOr("Description", "");
        this.regionCount = nbt.getIntOr("RegionCount", -1);
        this.timeCreated = nbt.getLongOr("TimeCreated", -1L);
        this.timeModified = nbt.getLongOr("TimeModified", -1L);
        if (nbt.contains("TotalVolume")) {
            this.totalVolume = nbt.getIntOr("TotalVolume", -1);
        }
        if (nbt.contains("TotalBlocks")) {
            this.totalBlocks = nbt.getIntOr("TotalBlocks", -1);
        }
        if (nbt.contains("EnclosingSize") && (size = NbtUtils.readVec3iFromTag(nbt.getCompoundOrEmpty("EnclosingSize"))) != null) {
            this.enclosingSize = size != null ? size : Vec3i.ZERO;
        }
        this.thumbnailPixelData = (int[])(nbt.contains("PreviewImageData") ? (int[])nbt.getIntArray("PreviewImageData").orElse(null) : null);
    }
}

