/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.util;

import fi.dy.masa.servux.schematic.placement.SchematicPlacement;
import fi.dy.masa.servux.schematic.placement.SubRegionPlacement;
import fi.dy.masa.servux.util.nbt.NbtView;
import fi.dy.masa.servux.util.position.PositionUtils;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.phys.AABB;

public class EntityUtils {
    public static final Predicate<Entity> NOT_PLAYER = entity -> !(entity instanceof Player);

    public static boolean isCreativeMode(Player player) {
        return player.getAbilities().instabuild;
    }

    public static Direction getHorizontalLookingDirection(Entity entity) {
        return Direction.fromYRot((double)entity.getYRot());
    }

    public static Direction getVerticalLookingDirection(Entity entity) {
        return entity.getXRot() > 0.0f ? Direction.DOWN : Direction.UP;
    }

    public static Direction getClosestLookingDirection(Entity entity) {
        if (entity.getXRot() > 60.0f) {
            return Direction.DOWN;
        }
        if (-entity.getXRot() > 60.0f) {
            return Direction.UP;
        }
        return EntityUtils.getHorizontalLookingDirection(entity);
    }

    @Nullable
    public static <T extends Entity> T findEntityByUUID(List<T> list, UUID uuid) {
        if (uuid == null) {
            return null;
        }
        for (Entity entity : list) {
            if (!entity.getUUID().equals(uuid)) continue;
            return (T)entity;
        }
        return null;
    }

    @Nullable
    public static String getEntityId(Entity entity) {
        EntityType entitytype = entity.getType();
        ResourceLocation resourcelocation = EntityType.getKey((EntityType)entitytype);
        return entitytype.canSerialize() && resourcelocation != null ? resourcelocation.toString() : null;
    }

    @Nullable
    private static Entity createEntityFromNBTSingle(CompoundTag nbt, Level world) {
        try {
            NbtView view = NbtView.getReader(nbt, world.registryAccess());
            Optional optional = EntityType.create((ValueInput)view.getReader(), (Level)world, (EntitySpawnReason)EntitySpawnReason.LOAD);
            if (optional.isPresent()) {
                Entity entity = (Entity)optional.get();
                entity.setUUID(UUID.randomUUID());
                return entity;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    public static Entity createEntityAndPassengersFromNBT(CompoundTag nbt, Level world) {
        Entity entity = EntityUtils.createEntityFromNBTSingle(nbt, world);
        if (entity == null) {
            return null;
        }
        if (nbt.contains("Passengers")) {
            ListTag taglist = nbt.getListOrEmpty("Passengers");
            for (int i = 0; i < taglist.size(); ++i) {
                Entity passenger = EntityUtils.createEntityAndPassengersFromNBT(taglist.getCompoundOrEmpty(i), world);
                if (passenger == null) continue;
                passenger.startRiding(entity, true);
            }
        }
        return entity;
    }

    public static void spawnEntityAndPassengersInWorld(Entity entity, Level world) {
        if (world.addFreshEntity(entity) && entity.isVehicle()) {
            for (Entity passenger : entity.getPassengers()) {
                passenger.snapTo(entity.getX(), entity.getY() + entity.getPassengerRidingPosition(passenger).y(), entity.getZ(), passenger.getYRot(), passenger.getXRot());
                EntityUtils.setEntityRotations(passenger, passenger.getYRot(), passenger.getXRot());
                EntityUtils.spawnEntityAndPassengersInWorld(passenger, world);
            }
        }
    }

    public static void setEntityRotations(Entity entity, float yaw, float pitch) {
        entity.setYRot(yaw);
        entity.yRotO = yaw;
        entity.setXRot(pitch);
        entity.xRotO = pitch;
        if (entity instanceof LivingEntity) {
            LivingEntity livingBase = (LivingEntity)entity;
            livingBase.yHeadRot = yaw;
            livingBase.yBodyRot = yaw;
            livingBase.yHeadRotO = yaw;
            livingBase.yBodyRotO = yaw;
        }
    }

    public static List<Entity> getEntitiesWithinSubRegion(Level world, BlockPos origin, BlockPos regionPos, BlockPos regionSize, SchematicPlacement schematicPlacement, SubRegionPlacement placement) {
        BlockPos regionPosRelTransformed = PositionUtils.getTransformedBlockPos(regionPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        BlockPos posEndAbs = PositionUtils.getTransformedPlacementPosition(regionSize.offset(-1, -1, -1), schematicPlacement, placement).offset((Vec3i)regionPosRelTransformed).offset((Vec3i)origin);
        BlockPos regionPosAbs = regionPosRelTransformed.offset((Vec3i)origin);
        AABB bb = PositionUtils.createEnclosingAABB(regionPosAbs, posEndAbs);
        return world.getEntities(null, bb, NOT_PLAYER);
    }
}

