/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.util.nbt;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import fi.dy.masa.servux.Servux;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class NbtUtils {
    @Nullable
    public static UUID getUUIDCodec(@Nonnull CompoundTag nbt) {
        return NbtUtils.getUUIDCodec(nbt, "UUID");
    }

    @Nullable
    public static UUID getUUIDCodec(@Nonnull CompoundTag nbt, String key) {
        if (nbt.contains(key)) {
            return nbt.read(key, UUIDUtil.CODEC).orElse(null);
        }
        return null;
    }

    public static CompoundTag putUUIDCodec(@Nonnull CompoundTag nbtIn, @Nonnull UUID uuid, String key) {
        nbtIn.store(key, UUIDUtil.CODEC, (Object)uuid);
        return nbtIn;
    }

    @Nonnull
    public static CompoundTag putVec2fCodec(@Nonnull CompoundTag tag, @Nonnull Vec2 pos, String key) {
        tag.store(key, Vec2.CODEC, (Object)pos);
        return tag;
    }

    @Nonnull
    public static CompoundTag putVec3iCodec(@Nonnull CompoundTag tag, @Nonnull Vec3i pos, String key) {
        tag.store(key, Vec3i.CODEC, (Object)pos);
        return tag;
    }

    @Nonnull
    public static CompoundTag putVec3dCodec(@Nonnull CompoundTag tag, @Nonnull Vec3 pos, String key) {
        tag.store(key, Vec3.CODEC, (Object)pos);
        return tag;
    }

    @Nonnull
    public static CompoundTag putPosCodec(@Nonnull CompoundTag tag, @Nonnull BlockPos pos, String key) {
        tag.store(key, BlockPos.CODEC, (Object)pos);
        return tag;
    }

    public static Vec2 getVec2fCodec(@Nonnull CompoundTag tag, String key) {
        return tag.read(key, Vec2.CODEC).orElse(Vec2.ZERO);
    }

    public static Vec3i getVec3iCodec(@Nonnull CompoundTag tag, String key) {
        return tag.read(key, Vec3i.CODEC).orElse(Vec3i.ZERO);
    }

    public static Vec3 getVec3dCodec(@Nonnull CompoundTag tag, String key) {
        return tag.read(key, Vec3.CODEC).orElse(Vec3.ZERO);
    }

    public static BlockPos getPosCodec(@Nonnull CompoundTag tag, String key) {
        return tag.read(key, BlockPos.CODEC).orElse(BlockPos.ZERO);
    }

    @Nonnull
    public static CompoundTag writeVec3iToArray(@Nonnull Vec3i pos, @Nonnull CompoundTag tag, String tagName) {
        return NbtUtils.writeBlockPosToArrayTag(pos, tag, tagName);
    }

    @Nonnull
    public static CompoundTag writeVec3iToArrayTag(@Nonnull Vec3i pos, @Nonnull CompoundTag tag, String tagName) {
        return NbtUtils.writeBlockPosToArrayTag(pos, tag, tagName);
    }

    @Nonnull
    public static CompoundTag writeBlockPosToArrayTag(@Nonnull Vec3i pos, @Nonnull CompoundTag tag, String tagName) {
        int[] arr = new int[]{pos.getX(), pos.getY(), pos.getZ()};
        tag.putIntArray(tagName, arr);
        return tag;
    }

    @Nullable
    public static BlockPos readBlockPosFromIntArray(@Nonnull CompoundTag nbt, String key) {
        return NbtUtils.readBlockPosFromArrayTag(nbt, key);
    }

    @Nullable
    public static BlockPos readBlockPosFromArrayTag(@Nonnull CompoundTag tag, String tagName) {
        int[] pos;
        if (tag.contains(tagName) && (pos = tag.getIntArray(tagName).orElse(new int[0])).length == 3) {
            return new BlockPos(pos[0], pos[1], pos[2]);
        }
        return null;
    }

    @Nullable
    public static Vec3i readVec3iFromIntArray(@Nonnull CompoundTag nbt, String key) {
        return NbtUtils.readVec3iFromIntArrayTag(nbt, key);
    }

    @Nullable
    public static Vec3i readVec3iFromIntArrayTag(@Nonnull CompoundTag tag, String tagName) {
        int[] pos;
        if (tag.contains(tagName) && (pos = tag.getIntArray(tagName).orElse(new int[0])).length == 3) {
            return new Vec3i(pos[0], pos[1], pos[2]);
        }
        return null;
    }

    public static CompoundTag createBlockPosTag(Vec3i pos) {
        return NbtUtils.writeBlockPosToTag(pos, new CompoundTag());
    }

    public static CompoundTag writeBlockPosToTag(Vec3i pos, CompoundTag tag) {
        tag.putInt("x", pos.getX());
        tag.putInt("y", pos.getY());
        tag.putInt("z", pos.getZ());
        return tag;
    }

    @Nullable
    public static BlockPos readBlockPos(@Nullable CompoundTag tag) {
        if (tag != null && tag.contains("x") && tag.contains("y") && tag.contains("z")) {
            return new BlockPos(tag.getIntOr("x", 0), tag.getIntOr("y", 0), tag.getIntOr("z", 0));
        }
        return null;
    }

    public static CompoundTag writeVec3dToTag(Vec3 vec, CompoundTag tag) {
        tag.putDouble("dx", vec.x);
        tag.putDouble("dy", vec.y);
        tag.putDouble("dz", vec.z);
        return tag;
    }

    public static CompoundTag writeEntityPositionToTag(Vec3 pos, CompoundTag tag) {
        ListTag posList = new ListTag();
        posList.add((Object)DoubleTag.valueOf((double)pos.x));
        posList.add((Object)DoubleTag.valueOf((double)pos.y));
        posList.add((Object)DoubleTag.valueOf((double)pos.z));
        tag.put("Pos", (Tag)posList);
        return tag;
    }

    @Nullable
    public static Vec3 readVec3d(@Nullable CompoundTag tag) {
        if (tag != null && tag.contains("dx") && tag.contains("dy") && tag.contains("dz")) {
            return new Vec3(tag.getDoubleOr("dx", 0.0), tag.getDoubleOr("dy", 0.0), tag.getDoubleOr("dz", 0.0));
        }
        return null;
    }

    @Nullable
    public static Vec3 readEntityPositionFromTag(@Nullable CompoundTag tag) {
        ListTag tagList;
        if (tag != null && tag.contains("Pos") && (tagList = tag.getListOrEmpty("Pos")).getId() == 6 && tagList.size() == 3) {
            return new Vec3(tagList.getDoubleOr(0, 0.0), tagList.getDoubleOr(1, 0.0), tagList.getDoubleOr(2, 0.0));
        }
        return null;
    }

    @Nullable
    public static Vec3i readVec3iFromTag(@Nullable CompoundTag tag) {
        if (tag != null && tag.contains("x") && tag.contains("y") && tag.contains("z")) {
            return new Vec3i(tag.getIntOr("x", 0), tag.getIntOr("y", 0), tag.getIntOr("z", 0));
        }
        return null;
    }

    @Nullable
    public static CompoundTag readNbtFromFileAsPath(@Nonnull Path file) {
        return NbtUtils.readNbtFromFileAsPath(file, NbtAccounter.unlimitedHeap());
    }

    @Nullable
    public static CompoundTag readNbtFromFileAsPath(@Nonnull Path file, NbtAccounter tracker) {
        if (!Files.exists(file, new LinkOption[0]) || !Files.isReadable(file)) {
            return null;
        }
        try {
            return NbtIo.readCompressed((InputStream)Files.newInputStream(file, new OpenOption[0]), (NbtAccounter)tracker);
        }
        catch (Exception e) {
            Servux.LOGGER.warn("readNbtFromFileAsPath: Failed to read NBT data from file '{}'", (Object)file.toString());
            return null;
        }
    }

    public static void writeCompressed(@Nonnull CompoundTag tag, @Nonnull OutputStream outputStream) {
        try {
            NbtIo.writeCompressed((CompoundTag)tag, (OutputStream)outputStream);
        }
        catch (Exception err) {
            Servux.LOGGER.warn("writeCompressed: Failed to write NBT data to output stream");
        }
    }

    public static void writeCompressed(@Nonnull CompoundTag tag, @Nonnull Path file) {
        try {
            NbtIo.writeCompressed((CompoundTag)tag, (Path)file);
        }
        catch (Exception err) {
            Servux.LOGGER.warn("writeCompressed: Failed to write NBT data to file");
        }
    }

    public static <T> Optional<T> readFlatMap(@Nonnull CompoundTag nbt, MapCodec<T> mapCodec) {
        NbtOps ops = NbtOps.INSTANCE;
        DataResult dataResult = ops.getMap((Object)nbt).flatMap(arg_0 -> NbtUtils.lambda$readFlatMap$0(mapCodec, (DynamicOps)ops, arg_0));
        Objects.requireNonNull(dataResult);
        DataResult dataResult2 = dataResult;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult2, n)) {
            case 0 -> {
                DataResult.Success result = (DataResult.Success)dataResult2;
                yield Optional.of(result.value());
            }
            case 1 -> {
                DataResult.Error error = (DataResult.Error)dataResult2;
                yield error.partialValue();
            }
            default -> Optional.empty();
        };
    }

    public static <T> CompoundTag writeFlatMap(MapCodec<T> mapCodec, T value) {
        NbtOps ops = NbtOps.INSTANCE;
        CompoundTag nbt = new CompoundTag();
        DataResult dataResult = mapCodec.encoder().encodeStart((DynamicOps)ops, value);
        Objects.requireNonNull(dataResult);
        DataResult dataResult2 = dataResult;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                DataResult.Success result = (DataResult.Success)dataResult2;
                nbt.merge((CompoundTag)result.value());
                break;
            }
            case 1: {
                DataResult.Error error = (DataResult.Error)dataResult2;
                error.partialValue().ifPresent(partial -> nbt.merge((CompoundTag)partial));
            }
        }
        return nbt;
    }

    private static /* synthetic */ DataResult lambda$readFlatMap$0(MapCodec mapCodec, DynamicOps ops, MapLike map) {
        return mapCodec.decode(ops, map);
    }
}

