/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.dataproviders;

import fi.dy.masa.servux.Reference;
import fi.dy.masa.servux.Servux;
import fi.dy.masa.servux.dataproviders.DataProviderBase;
import fi.dy.masa.servux.dataproviders.IDataProvider;
import fi.dy.masa.servux.network.IPluginServerPlayHandler;
import fi.dy.masa.servux.network.ServerPlayHandler;
import fi.dy.masa.servux.network.packet.ServuxStructuresHandler;
import fi.dy.masa.servux.network.packet.ServuxStructuresPacket;
import fi.dy.masa.servux.settings.IServuxSetting;
import fi.dy.masa.servux.settings.ServuxBoolSetting;
import fi.dy.masa.servux.settings.ServuxIntSetting;
import fi.dy.masa.servux.settings.ServuxStringListSetting;
import fi.dy.masa.servux.util.PlayerDimensionPosition;
import fi.dy.masa.servux.util.Timeout;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;

public class StructureDataProvider
extends DataProviderBase {
    public static final StructureDataProvider INSTANCE = new StructureDataProvider();
    protected static final ServuxStructuresHandler<ServuxStructuresPacket.Payload> HANDLER = ServuxStructuresHandler.getInstance();
    protected final Map<UUID, PlayerDimensionPosition> registeredPlayers = new HashMap<UUID, PlayerDimensionPosition>();
    protected final Map<UUID, Map<ChunkPos, Timeout>> timeouts = new HashMap<UUID, Map<ChunkPos, Timeout>>();
    protected final CompoundTag metadata = new CompoundTag();
    protected int retainDistance;
    private ServuxIntSetting permissionLevel = new ServuxIntSetting((IDataProvider)this, "permission_level", 0, 4, 0);
    private ServuxBoolSetting structureBlacklistEnabled = new ServuxBoolSetting(this, "structures_blacklist_enabled", false);
    private ServuxBoolSetting structureWhitelistEnabled = new ServuxBoolSetting(this, "structures_whitelist_enabled", false);
    private ServuxStringListSetting structureBlacklist = new ServuxStringListSetting(this, "structures_blacklist", List.of("minecraft:buried_treasure"));
    private ServuxStringListSetting structureWhitelist = new ServuxStringListSetting(this, "structures_whitelist", List.of());
    private ServuxIntSetting updateInterval = new ServuxIntSetting((IDataProvider)this, "update_interval", 40, 1200, 1);
    private ServuxIntSetting timeout = new ServuxIntSetting((IDataProvider)this, "timeout", 600, 1200, 40);
    private List<IServuxSetting<?>> settings = List.of(this.permissionLevel, this.structureBlacklistEnabled, this.structureWhitelistEnabled, this.structureBlacklist, this.structureWhitelist, this.updateInterval, this.timeout);

    protected StructureDataProvider() {
        super("structure_bounding_boxes", ServuxStructuresHandler.CHANNEL_ID, 2, 0, "servux.provider.structure_bounding_boxes", "Structure Bounding Boxes data for structures such as Witch Huts, Ocean Monuments, Nether Fortresses etc.");
        this.metadata.putString("name", this.getName());
        this.metadata.putString("id", this.getNetworkChannel().toString());
        this.metadata.putInt("version", this.getProtocolVersion());
        this.metadata.putString("servux", Reference.MOD_STRING);
        this.metadata.putInt("timeout", ((Integer)this.timeout.getValue()).intValue());
        this.setTickRate(40);
    }

    @Override
    public List<IServuxSetting<?>> getSettings() {
        return this.settings;
    }

    @Override
    public void registerHandler() {
        ServerPlayHandler.getInstance().registerServerPlayHandler(HANDLER);
        if (!this.isRegistered()) {
            HANDLER.registerPlayPayload(ServuxStructuresPacket.Payload.ID, ServuxStructuresPacket.Payload.CODEC, 3);
            this.setRegistered(true);
        }
        HANDLER.registerPlayReceiver(ServuxStructuresPacket.Payload.ID, (ServerPlayNetworking.PlayPayloadHandler<ServuxStructuresPacket.Payload>)((ServerPlayNetworking.PlayPayloadHandler)HANDLER::receivePlayPayload));
    }

    @Override
    public void unregisterHandler() {
        HANDLER.unregisterPlayReceiver();
        ServerPlayHandler.getInstance().unregisterServerPlayHandler(HANDLER);
    }

    public IPluginServerPlayHandler<ServuxStructuresPacket.Payload> getPacketHandler() {
        return HANDLER;
    }

    @Override
    public boolean isPlayerRegistered(ServerPlayer player) {
        return this.registeredPlayers.containsKey(player.getUUID());
    }

    @Override
    public boolean shouldTick() {
        return this.enabled;
    }

    @Override
    public void tick(MinecraftServer server, int tickCounter, ProfilerFiller profiler) {
        if (!this.isEnabled()) {
            return;
        }
        if (tickCounter % (Integer)this.updateInterval.getValue() == 0) {
            profiler.push(this.getName());
            List playerList = server.getPlayerList().getPlayers();
            this.retainDistance = server.getPlayerList().getViewDistance() + 2;
            profiler.popPush(this.getName() + "_players");
            for (ServerPlayer player : playerList) {
                UUID uuid = player.getUUID();
                if (!this.registeredPlayers.containsKey(uuid)) continue;
                if (!this.hasPermission(player)) {
                    this.unregister(player);
                    continue;
                }
                this.checkForDimensionChange(player);
                this.refreshTrackedChunks(player, tickCounter);
            }
            this.checkForInvalidPlayers(server);
            profiler.pop();
        }
    }

    public void checkForInvalidPlayers(MinecraftServer server) {
        if (!this.registeredPlayers.isEmpty()) {
            Iterator<UUID> iter = this.registeredPlayers.keySet().iterator();
            while (iter.hasNext()) {
                UUID uuid = iter.next();
                if (server.getPlayerList().getPlayer(uuid) != null) continue;
                this.timeouts.remove(uuid);
                iter.remove();
            }
        }
    }

    public void onStartedWatchingChunk(ServerPlayer player, LevelChunk chunk) {
        UUID uuid = player.getUUID();
        if (this.registeredPlayers.containsKey(uuid)) {
            this.addChunkTimeoutIfHasReferences(uuid, chunk, player.createCommandSourceStack().getServer().getTickCount());
        }
    }

    public boolean register(ServerPlayer player) {
        if (!this.isEnabled()) {
            return false;
        }
        boolean registered = false;
        MinecraftServer server = player.createCommandSourceStack().getServer();
        UUID uuid = player.getUUID();
        if (!this.hasPermission(player)) {
            Servux.debugLog("structure_bounding_boxes: Denying access for player {}, Insufficient Permissions", player.getName().tryCollapseToString());
            return registered;
        }
        if (!this.registeredPlayers.containsKey(uuid)) {
            this.registeredPlayers.put(uuid, new PlayerDimensionPosition((Player)player));
            int tickCounter = server.getTickCount();
            ServerGamePacketListenerImpl handler = player.connection;
            if (handler != null) {
                CompoundTag nbt = new CompoundTag();
                nbt.merge(this.metadata);
                Servux.debugLog("structure_bounding_boxes: sending Metadata to player {}", player.getName().tryCollapseToString());
                HANDLER.sendPlayPayload(handler, new ServuxStructuresPacket.Payload(new ServuxStructuresPacket(ServuxStructuresPacket.Type.PACKET_S2C_METADATA, nbt)));
                this.initialSyncStructuresToPlayerWithinRange(player, player.createCommandSourceStack().getServer().getPlayerList().getViewDistance() + 2, tickCounter);
            }
            registered = true;
        }
        return registered;
    }

    public boolean unregister(ServerPlayer player) {
        HANDLER.resetFailures(this.getNetworkChannel(), player);
        return this.registeredPlayers.remove(player.getUUID()) != null;
    }

    protected void initialSyncStructuresToPlayerWithinRange(ServerPlayer player, int chunkRadius, int tickCounter) {
        UUID uuid = player.getUUID();
        ChunkPos center = player.getLastSectionPos().chunk();
        Map<Structure, LongSet> references = this.getStructureReferencesWithinRange(player.level(), center, chunkRadius);
        this.timeouts.remove(uuid);
        this.registeredPlayers.computeIfAbsent(uuid, u -> new PlayerDimensionPosition((Player)player)).setPosition((Player)player);
        this.sendStructures(player, references, tickCounter);
    }

    protected void addChunkTimeoutIfHasReferences(UUID uuid, LevelChunk chunk, int tickCounter) {
        ChunkPos pos = chunk.getPos();
        if (this.chunkHasStructureReferences(pos.x, pos.z, chunk.getLevel())) {
            Map map = this.timeouts.computeIfAbsent(uuid, u -> new HashMap());
            map.computeIfAbsent(pos, p -> new Timeout(tickCounter - (Integer)this.timeout.getValue()));
        }
    }

    protected void checkForDimensionChange(ServerPlayer player) {
        UUID uuid = player.getUUID();
        PlayerDimensionPosition playerPos = this.registeredPlayers.get(uuid);
        if (playerPos == null || playerPos.dimensionChanged((Player)player)) {
            this.timeouts.remove(uuid);
            this.registeredPlayers.computeIfAbsent(uuid, u -> new PlayerDimensionPosition((Player)player)).setPosition((Player)player);
        }
    }

    protected void addOrRefreshTimeouts(UUID uuid, Map<Structure, LongSet> references, int tickCounter) {
        Map map = this.timeouts.computeIfAbsent(uuid, u -> new HashMap());
        for (LongSet chunks : references.values()) {
            for (Long chunkPosLong : chunks) {
                ChunkPos pos = new ChunkPos(chunkPosLong.longValue());
                map.computeIfAbsent(pos, p -> new Timeout(tickCounter)).setLastSync(tickCounter);
            }
        }
    }

    protected void refreshTrackedChunks(ServerPlayer player, int tickCounter) {
        UUID uuid = player.getUUID();
        Map<ChunkPos, Timeout> map = this.timeouts.get(uuid);
        if (map != null) {
            this.sendAndRefreshExpiredStructures(player, map, tickCounter);
        }
    }

    protected boolean isOutOfRange(ChunkPos pos, ChunkPos center) {
        int chunkRadius = this.retainDistance;
        return Math.abs(pos.x - center.x) > chunkRadius || Math.abs(pos.z - center.z) > chunkRadius;
    }

    protected void sendAndRefreshExpiredStructures(ServerPlayer player, Map<ChunkPos, Timeout> map, int tickCounter) {
        HashSet<ChunkPos> positionsToUpdate = new HashSet<ChunkPos>();
        for (Map.Entry<ChunkPos, Timeout> entry : map.entrySet()) {
            Timeout timeout = entry.getValue();
            if (!timeout.needsUpdate(tickCounter, (Integer)this.timeout.getValue())) continue;
            positionsToUpdate.add(entry.getKey());
        }
        if (!positionsToUpdate.isEmpty()) {
            ServerLevel world = player.level();
            ChunkPos center = player.getLastSectionPos().chunk();
            HashMap<Structure, LongSet> references = new HashMap<Structure, LongSet>();
            for (ChunkPos pos : positionsToUpdate) {
                if (this.isOutOfRange(pos, center)) {
                    map.remove(pos);
                    continue;
                }
                this.getStructureReferencesFromChunk(pos.x, pos.z, (Level)world, references);
                Timeout timeout = map.get(pos);
                if (timeout == null) continue;
                timeout.setLastSync(tickCounter);
            }
            if (!references.isEmpty()) {
                this.sendStructures(player, references, tickCounter);
            }
        }
    }

    protected void getStructureReferencesFromChunk(int chunkX, int chunkZ, Level world, Map<Structure, LongSet> references) {
        if (!world.hasChunk(chunkX, chunkZ)) {
            return;
        }
        ChunkAccess chunk = world.getChunk(chunkX, chunkZ, ChunkStatus.STRUCTURE_STARTS, false);
        if (chunk == null) {
            return;
        }
        for (Map.Entry entry : chunk.getAllReferences().entrySet()) {
            Structure feature = (Structure)entry.getKey();
            LongSet startChunks = (LongSet)entry.getValue();
            if (startChunks.isEmpty()) continue;
            references.merge(feature, startChunks, (oldSet, entrySet) -> {
                LongOpenHashSet newSet = new LongOpenHashSet((LongCollection)oldSet);
                newSet.addAll((LongCollection)entrySet);
                return newSet;
            });
        }
    }

    protected boolean chunkHasStructureReferences(int chunkX, int chunkZ, Level world) {
        if (!world.hasChunk(chunkX, chunkZ)) {
            return false;
        }
        ChunkAccess chunk = world.getChunk(chunkX, chunkZ, ChunkStatus.STRUCTURE_STARTS, false);
        if (chunk == null) {
            return false;
        }
        for (Map.Entry entry : chunk.getAllReferences().entrySet()) {
            if (((LongSet)entry.getValue()).isEmpty()) continue;
            return true;
        }
        return false;
    }

    protected Map<ChunkPos, StructureStart> getStructureStartsFromReferences(ServerLevel world, Map<Structure, LongSet> references) {
        HashMap<ChunkPos, StructureStart> starts = new HashMap<ChunkPos, StructureStart>();
        for (Map.Entry<Structure, LongSet> entry : references.entrySet()) {
            Structure structure = entry.getKey();
            LongSet startChunks = entry.getValue();
            LongIterator iter = startChunks.iterator();
            while (iter.hasNext()) {
                StructureStart start;
                ChunkAccess chunk;
                ChunkPos pos = new ChunkPos(iter.nextLong());
                if (!world.hasChunk(pos.x, pos.z) || (chunk = world.getChunk(pos.x, pos.z, ChunkStatus.STRUCTURE_STARTS, false)) == null || (start = chunk.getStartForStructure(structure)) == null) continue;
                starts.put(pos, start);
            }
        }
        return starts;
    }

    protected Map<Structure, LongSet> getStructureReferencesWithinRange(ServerLevel world, ChunkPos center, int chunkRadius) {
        HashMap<Structure, LongSet> references = new HashMap<Structure, LongSet>();
        for (int cx = center.x - chunkRadius; cx <= center.x + chunkRadius; ++cx) {
            for (int cz = center.z - chunkRadius; cz <= center.z + chunkRadius; ++cz) {
                this.getStructureReferencesFromChunk(cx, cz, (Level)world, references);
            }
        }
        return references;
    }

    protected void sendStructures(ServerPlayer player, Map<Structure, LongSet> references, int tickCounter) {
        ServerLevel world = player.level();
        Map<ChunkPos, StructureStart> starts = this.getStructureStartsFromReferences(world, references);
        if (!starts.isEmpty()) {
            this.addOrRefreshTimeouts(player.getUUID(), references, tickCounter);
            ListTag structureList = this.getStructureList(starts, world);
            if (this.registeredPlayers.containsKey(player.getUUID())) {
                CompoundTag nbt = new CompoundTag();
                nbt.put("Structures", (Tag)structureList.copy());
                HANDLER.encodeStructuresPacket(player, new ServuxStructuresPacket(ServuxStructuresPacket.Type.PACKET_S2C_STRUCTURE_DATA_START, nbt));
            }
        }
    }

    protected ListTag getStructureList(Map<ChunkPos, StructureStart> structures, ServerLevel world) {
        ListTag list = new ListTag();
        StructurePieceSerializationContext ctx = StructurePieceSerializationContext.fromLevel((ServerLevel)world);
        for (Map.Entry<ChunkPos, StructureStart> entry : structures.entrySet()) {
            ResourceLocation structureType = BuiltInRegistries.STRUCTURE_TYPE.getKey((Object)entry.getValue().getStructure().type());
            if (!this.shouldSendStructure(structureType)) continue;
            ChunkPos pos = entry.getKey();
            list.add((Object)entry.getValue().createTag(ctx, pos));
        }
        return list;
    }

    protected boolean shouldSendStructure(ResourceLocation identifier) {
        if (((Boolean)this.structureWhitelistEnabled.getValue()).booleanValue()) {
            return ((List)this.structureWhitelist.getValue()).contains(identifier.toString());
        }
        if (((Boolean)this.structureBlacklistEnabled.getValue()).booleanValue()) {
            return !((List)this.structureBlacklist.getValue()).contains(identifier.toString());
        }
        return true;
    }

    @Override
    public boolean hasPermission(ServerPlayer player) {
        return Permissions.check((Entity)player, (String)this.permNode, (int)((Integer)this.permissionLevel.getValue()));
    }

    @Override
    public void onTickEndPre() {
    }

    @Override
    public void onTickEndPost() {
    }
}

