/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.network.packet;

import fi.dy.masa.servux.Servux;
import fi.dy.masa.servux.network.IServerPayloadData;
import fi.dy.masa.servux.network.packet.ServuxDebugHandler;
import io.netty.buffer.Unpooled;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public class ServuxDebugPacket
implements IServerPayloadData {
    private Type packetType;
    private CompoundTag nbt;
    private FriendlyByteBuf buffer;
    public static final int PROTOCOL_VERSION = 1;

    private ServuxDebugPacket(Type type) {
        this.packetType = type;
        this.nbt = new CompoundTag();
        this.clearPacket();
    }

    public static ServuxDebugPacket MetadataRequest(@Nullable CompoundTag nbt) {
        ServuxDebugPacket packet = new ServuxDebugPacket(Type.PACKET_C2S_METADATA_REQUEST);
        if (nbt != null) {
            packet.nbt.merge(nbt);
        }
        return packet;
    }

    public static ServuxDebugPacket MetadataResponse(@Nullable CompoundTag nbt) {
        ServuxDebugPacket packet = new ServuxDebugPacket(Type.PACKET_S2C_METADATA);
        if (nbt != null) {
            packet.nbt.merge(nbt);
        }
        return packet;
    }

    public static ServuxDebugPacket MetadataConfirm(@Nullable CompoundTag nbt) {
        ServuxDebugPacket packet = new ServuxDebugPacket(Type.PACKET_C2S_METADATA_CONFIRM);
        if (nbt != null) {
            packet.nbt.merge(nbt);
        }
        return packet;
    }

    public static ServuxDebugPacket DebugServiceRegister(@Nullable CompoundTag nbt) {
        ServuxDebugPacket packet = new ServuxDebugPacket(Type.PACKET_C2S_DEBUG_SERVICE_REGISTER);
        if (nbt != null) {
            packet.nbt.merge(nbt);
        }
        return packet;
    }

    public static ServuxDebugPacket DebugServiceUnregister(@Nullable CompoundTag nbt) {
        ServuxDebugPacket packet = new ServuxDebugPacket(Type.PACKET_C2S_DEBUG_SERVICE_UNREGISTER);
        if (nbt != null) {
            packet.nbt.merge(nbt);
        }
        return packet;
    }

    public static ServuxDebugPacket ResponseS2CStart(@Nonnull CompoundTag nbt) {
        ServuxDebugPacket packet = new ServuxDebugPacket(Type.PACKET_S2C_NBT_RESPONSE_START);
        packet.nbt.merge(nbt);
        return packet;
    }

    public static ServuxDebugPacket ResponseS2CData(@Nonnull FriendlyByteBuf buffer) {
        ServuxDebugPacket packet = new ServuxDebugPacket(Type.PACKET_S2C_NBT_RESPONSE_DATA);
        packet.buffer = new FriendlyByteBuf(buffer.copy());
        packet.nbt = new CompoundTag();
        return packet;
    }

    private void clearPacket() {
        if (this.buffer != null) {
            this.buffer.clear();
            this.buffer = new FriendlyByteBuf(Unpooled.buffer());
        }
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public int getPacketType() {
        return this.packetType.get();
    }

    @Override
    public int getTotalSize() {
        int total = 2;
        if (this.nbt != null && !this.nbt.isEmpty()) {
            total += this.nbt.sizeInBytes();
        }
        if (this.buffer != null) {
            total += this.buffer.readableBytes();
        }
        return total;
    }

    public Type getType() {
        return this.packetType;
    }

    public CompoundTag getCompound() {
        return this.nbt;
    }

    public FriendlyByteBuf getBuffer() {
        return this.buffer;
    }

    public boolean hasBuffer() {
        return this.buffer != null && this.buffer.isReadable();
    }

    public boolean hasNbt() {
        return this.nbt != null && !this.nbt.isEmpty();
    }

    @Override
    public boolean isEmpty() {
        return !this.hasBuffer() && !this.hasNbt();
    }

    @Override
    public void toPacket(FriendlyByteBuf output) {
        output.writeVarInt(this.packetType.get());
        switch (this.packetType.ordinal()) {
            case 6: {
                try {
                    output.writeBytes(this.buffer.copy());
                }
                catch (Exception e) {
                    Servux.LOGGER.error("ServuxDebugPacket#toPacket: error writing buffer data to packet: [{}]", (Object)e.getLocalizedMessage());
                }
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                try {
                    output.writeNbt((Tag)this.nbt);
                }
                catch (Exception e) {
                    Servux.LOGGER.error("ServuxDebugPacket#toPacket: error writing NBT to packet: [{}]", (Object)e.getLocalizedMessage());
                }
                break;
            }
            default: {
                Servux.LOGGER.error("ServuxDebugPacket#toPacket: Unknown packet type!");
            }
        }
    }

    @Nullable
    public static ServuxDebugPacket fromPacket(FriendlyByteBuf input) {
        int i = input.readVarInt();
        Type type = ServuxDebugPacket.getType(i);
        if (type == null) {
            Servux.LOGGER.warn("ServuxDebugPacket#fromPacket: invalid packet type received");
            return null;
        }
        switch (type.ordinal()) {
            case 6: {
                try {
                    return ServuxDebugPacket.ResponseS2CData(new FriendlyByteBuf(input.readBytes(input.readableBytes())));
                }
                catch (Exception e) {
                    Servux.LOGGER.error("ServuxDebugPacket#fromPacket: error reading S2C Bulk Response Buffer from packet: [{}]", (Object)e.getLocalizedMessage());
                    break;
                }
            }
            case 1: {
                try {
                    return ServuxDebugPacket.MetadataRequest(input.readNbt());
                }
                catch (Exception e) {
                    Servux.LOGGER.error("ServuxDebugPacket#fromPacket: error reading Metadata Request from packet: [{}]", (Object)e.getLocalizedMessage());
                    break;
                }
            }
            case 0: {
                try {
                    return ServuxDebugPacket.MetadataResponse(input.readNbt());
                }
                catch (Exception e) {
                    Servux.LOGGER.error("ServuxDebugPacket#fromPacket: error reading Metadata Response from packet: [{}]", (Object)e.getLocalizedMessage());
                    break;
                }
            }
            case 2: {
                try {
                    return ServuxDebugPacket.MetadataConfirm(input.readNbt());
                }
                catch (Exception e) {
                    Servux.LOGGER.error("ServuxDebugPacket#fromPacket: error reading Metadata Confirm from packet: [{}]", (Object)e.getLocalizedMessage());
                    break;
                }
            }
            case 3: {
                try {
                    return ServuxDebugPacket.DebugServiceRegister(input.readNbt());
                }
                catch (Exception e) {
                    Servux.LOGGER.error("ServuxDebugPacket#fromPacket: error reading Spawn Data Request from packet: [{}]", (Object)e.getLocalizedMessage());
                    break;
                }
            }
            case 4: {
                try {
                    return ServuxDebugPacket.DebugServiceUnregister(input.readNbt());
                }
                catch (Exception e) {
                    Servux.LOGGER.error("ServuxDebugPacket#fromPacket: error reading Spawn Data Response from packet: [{}]", (Object)e.getLocalizedMessage());
                    break;
                }
            }
            default: {
                Servux.LOGGER.error("ServuxDebugPacket#fromPacket: Unknown packet type!");
            }
        }
        return null;
    }

    @Override
    public void clear() {
        if (this.nbt != null && !this.nbt.isEmpty()) {
            this.nbt = new CompoundTag();
        }
        this.clearPacket();
        this.packetType = null;
    }

    @Nullable
    public static Type getType(int input) {
        for (Type type : Type.values()) {
            if (type.get() != input) continue;
            return type;
        }
        return null;
    }

    public static enum Type {
        PACKET_S2C_METADATA(1),
        PACKET_C2S_METADATA_REQUEST(2),
        PACKET_C2S_METADATA_CONFIRM(3),
        PACKET_C2S_DEBUG_SERVICE_REGISTER(4),
        PACKET_C2S_DEBUG_SERVICE_UNREGISTER(5),
        PACKET_S2C_NBT_RESPONSE_START(10),
        PACKET_S2C_NBT_RESPONSE_DATA(11);

        private final int type;

        private Type(int type) {
            this.type = type;
        }

        int get() {
            return this.type;
        }
    }

    public record Payload(ServuxDebugPacket data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<Payload> ID = new CustomPacketPayload.Type(ServuxDebugHandler.CHANNEL_ID);
        public static final StreamCodec<FriendlyByteBuf, Payload> CODEC = CustomPacketPayload.codec(Payload::write, Payload::new);

        public Payload(FriendlyByteBuf input) {
            this(ServuxDebugPacket.fromPacket(input));
        }

        private void write(FriendlyByteBuf output) {
            this.data.toPacket(output);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }
    }
}

