/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.schematic.container;

import fi.dy.masa.servux.dataproviders.DataProviderManager;
import fi.dy.masa.servux.schematic.container.ILitematicaBlockStatePalette;
import fi.dy.masa.servux.schematic.container.ILitematicaBlockStatePaletteResizer;
import fi.dy.masa.servux.schematic.container.LitematicaBlockStateContainer;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.CrudeIncrementalIntIdentityHashBiMap;
import net.minecraft.world.level.block.state.BlockState;

public class LitematicaBlockStatePaletteHashMap
implements ILitematicaBlockStatePalette {
    private final CrudeIncrementalIntIdentityHashBiMap<BlockState> statePaletteMap;
    private final ILitematicaBlockStatePaletteResizer paletteResizer;
    private final int bits;

    public LitematicaBlockStatePaletteHashMap(int bitsIn, ILitematicaBlockStatePaletteResizer paletteResizer) {
        this.bits = bitsIn;
        this.paletteResizer = paletteResizer;
        this.statePaletteMap = CrudeIncrementalIntIdentityHashBiMap.create((int)(1 << bitsIn));
    }

    @Override
    public int idFor(BlockState state) {
        int i = this.statePaletteMap.getId((Object)state);
        if (i == -1 && (i = this.statePaletteMap.add((Object)state)) >= 1 << this.bits) {
            i = this.paletteResizer.onResize(this.bits + 1, state);
        }
        return i;
    }

    @Override
    @Nullable
    public BlockState getBlockState(int indexKey) {
        return (BlockState)this.statePaletteMap.byId(indexKey);
    }

    @Override
    public int getPaletteSize() {
        return this.statePaletteMap.size();
    }

    private void requestNewId(BlockState state) {
        int newId;
        int origId = this.statePaletteMap.add((Object)state);
        if (origId >= 1 << this.bits && (newId = this.paletteResizer.onResize(this.bits + 1, LitematicaBlockStateContainer.AIR_BLOCK_STATE)) <= origId) {
            this.statePaletteMap.add((Object)state);
        }
    }

    @Override
    public void readFromNBT(ListTag tagList) {
        Registry lookup = DataProviderManager.INSTANCE.getRegistryManager().lookupOrThrow(Registries.BLOCK);
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            CompoundTag tag = tagList.getCompound(i);
            BlockState state = NbtUtils.readBlockState((HolderGetter)lookup, (CompoundTag)tag);
            if (i <= 0 && state == LitematicaBlockStateContainer.AIR_BLOCK_STATE) continue;
            this.requestNewId(state);
        }
    }

    @Override
    public ListTag writeToNBT() {
        ListTag tagList = new ListTag();
        for (int id = 0; id < this.statePaletteMap.size(); ++id) {
            BlockState state = (BlockState)this.statePaletteMap.byId(id);
            if (state == null) {
                state = LitematicaBlockStateContainer.AIR_BLOCK_STATE;
            }
            CompoundTag tag = NbtUtils.writeBlockState((BlockState)state);
            tagList.add((Object)tag);
        }
        return tagList;
    }

    @Override
    public boolean setMapping(List<BlockState> list) {
        this.statePaletteMap.clear();
        for (BlockState blockState : list) {
            this.statePaletteMap.add((Object)blockState);
        }
        return true;
    }
}

