/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.schematic.placement;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import fi.dy.masa.servux.Servux;
import fi.dy.masa.servux.schematic.LitematicaSchematic;
import fi.dy.masa.servux.schematic.placement.SubRegionPlacement;
import fi.dy.masa.servux.schematic.selection.Box;
import fi.dy.masa.servux.util.IntBoundingBox;
import fi.dy.masa.servux.util.LayerRange;
import fi.dy.masa.servux.util.PasteLayerBehavior;
import fi.dy.masa.servux.util.ReplaceBehavior;
import fi.dy.masa.servux.util.SchematicPlacingUtils;
import fi.dy.masa.servux.util.position.PositionUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;

public class SchematicPlacement {
    private static final Set<Integer> USED_COLORS = new HashSet<Integer>();
    private final Map<String, SubRegionPlacement> relativeSubRegionPlacements = new HashMap<String, SubRegionPlacement>();
    private final int subRegionCount;
    private final LitematicaSchematic schematic;
    private BlockPos origin;
    private String name;
    private Rotation rotation = Rotation.NONE;
    private Mirror mirror = Mirror.NONE;
    private boolean ignoreEntities;
    private boolean regionPlacementsModified;
    private int coordinateLockMask;
    @Nullable
    private Box enclosingBox;

    private SchematicPlacement(LitematicaSchematic schematic, BlockPos origin, String name, boolean ignoreEntities) {
        this.schematic = schematic;
        this.origin = origin;
        this.name = name;
        this.subRegionCount = schematic.getSubRegionCount();
        this.ignoreEntities = ignoreEntities;
    }

    public static SchematicPlacement createFor(LitematicaSchematic schematic, BlockPos origin, String name, boolean ignoreEntities) {
        SchematicPlacement placement = new SchematicPlacement(schematic, origin, name, ignoreEntities);
        placement.resetAllSubRegionsToSchematicValues();
        return placement;
    }

    public static SchematicPlacement createFromNbt(CompoundTag tags) {
        try {
            SchematicPlacement placement = new SchematicPlacement(new LitematicaSchematic(tags.getCompound("Schematics")), (BlockPos)NbtUtils.readBlockPos((CompoundTag)tags, (String)"Origin").orElseThrow(), tags.getString("Name"), false);
            placement.mirror = Mirror.values()[tags.getInt("Mirror")];
            placement.rotation = Rotation.values()[tags.getInt("Rotation")];
            for (String name : tags.getCompound("SubRegions").getAllKeys()) {
                CompoundTag compound = tags.getCompound("SubRegions").getCompound(name);
                SubRegionPlacement sub = new SubRegionPlacement((BlockPos)NbtUtils.readBlockPos((CompoundTag)compound, (String)"Pos").orElseThrow(), compound.getString("Name"));
                sub.mirror = Mirror.values()[compound.getInt("Mirror")];
                sub.rotation = Rotation.values()[compound.getInt("Rotation")];
                sub.ignoreEntities = compound.getBoolean("IgnoreEntities");
                sub.enabled = compound.getBoolean("Enabled");
                placement.relativeSubRegionPlacements.put(name, sub);
            }
            return placement;
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean shouldRenderEnclosingBox() {
        return false;
    }

    public boolean isRegionPlacementModified() {
        return this.regionPlacementsModified;
    }

    public boolean ignoreEntities() {
        return this.ignoreEntities;
    }

    public String getName() {
        return this.name;
    }

    public LitematicaSchematic getSchematic() {
        return this.schematic;
    }

    @Nullable
    public Box getEclosingBox() {
        return this.enclosingBox;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BlockPos getOrigin() {
        return this.origin;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public Mirror getMirror() {
        return this.mirror;
    }

    public int getSubRegionCount() {
        return this.subRegionCount;
    }

    @Nullable
    public SubRegionPlacement getRelativeSubRegionPlacement(String areaName) {
        return this.relativeSubRegionPlacements.get(areaName);
    }

    public Collection<SubRegionPlacement> getAllSubRegionsPlacements() {
        return this.relativeSubRegionPlacements.values();
    }

    public ImmutableMap<String, SubRegionPlacement> getEnabledRelativeSubRegionPlacements() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, SubRegionPlacement> entry : this.relativeSubRegionPlacements.entrySet()) {
            SubRegionPlacement placement = entry.getValue();
            if (!placement.matchesRequirement(SubRegionPlacement.RequiredEnabled.PLACEMENT_ENABLED)) continue;
            builder.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        return builder.build();
    }

    private void updateEnclosingBox() {
        if (this.shouldRenderEnclosingBox()) {
            ImmutableMap<String, Box> boxes = this.getSubRegionBoxes(SubRegionPlacement.RequiredEnabled.ANY);
            BlockPos pos1 = null;
            BlockPos pos2 = null;
            for (Box box : boxes.values()) {
                BlockPos tmp = PositionUtils.getMinCorner(box.getPos1(), box.getPos2());
                if (pos1 == null) {
                    pos1 = tmp;
                } else if (tmp.getX() < pos1.getX() || tmp.getY() < pos1.getY() || tmp.getZ() < pos1.getZ()) {
                    pos1 = PositionUtils.getMinCorner(tmp, pos1);
                }
                tmp = PositionUtils.getMaxCorner(box.getPos1(), box.getPos2());
                if (pos2 == null) {
                    pos2 = tmp;
                    continue;
                }
                if (tmp.getX() <= pos2.getX() && tmp.getY() <= pos2.getY() && tmp.getZ() <= pos2.getZ()) continue;
                pos2 = PositionUtils.getMaxCorner(tmp, pos2);
            }
            if (pos1 != null && pos2 != null) {
                this.enclosingBox = new Box(pos1, pos2, "Enclosing Box");
            }
        }
    }

    public ImmutableMap<String, Box> getSubRegionBoxes(SubRegionPlacement.RequiredEnabled required) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Map<String, BlockPos> areaSizes = this.schematic.getAreaSizes();
        for (Map.Entry<String, SubRegionPlacement> entry : this.relativeSubRegionPlacements.entrySet()) {
            String name = entry.getKey();
            BlockPos areaSize = areaSizes.get(name);
            if (areaSize == null) {
                Servux.LOGGER.warn("SchematicPlacement.getSubRegionBoxes(): Size for sub-region '{}' not found in the schematic '{}'", (Object)name, (Object)this.schematic.getMetadata().getName());
                continue;
            }
            SubRegionPlacement placement = entry.getValue();
            if (!placement.matchesRequirement(required)) continue;
            BlockPos boxOriginRelative = placement.getPos();
            BlockPos boxOriginAbsolute = PositionUtils.getTransformedBlockPos(boxOriginRelative, this.mirror, this.rotation).offset((Vec3i)this.origin);
            BlockPos pos2 = PositionUtils.getRelativeEndPositionFromAreaSize((Vec3i)areaSize);
            pos2 = PositionUtils.getTransformedBlockPos(pos2, this.mirror, this.rotation);
            pos2 = PositionUtils.getTransformedBlockPos(pos2, placement.getMirror(), placement.getRotation()).offset((Vec3i)boxOriginAbsolute);
            builder.put((Object)name, (Object)new Box(boxOriginAbsolute, pos2, name));
        }
        return builder.build();
    }

    public ImmutableMap<String, Box> getSubRegionBoxFor(String regionName, SubRegionPlacement.RequiredEnabled required) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Map<String, BlockPos> areaSizes = this.schematic.getAreaSizes();
        SubRegionPlacement placement = this.relativeSubRegionPlacements.get(regionName);
        if (placement != null && placement.matchesRequirement(required)) {
            BlockPos areaSize = areaSizes.get(regionName);
            if (areaSize != null) {
                BlockPos boxOriginRelative = placement.getPos();
                BlockPos boxOriginAbsolute = PositionUtils.getTransformedBlockPos(boxOriginRelative, this.mirror, this.rotation).offset((Vec3i)this.origin);
                BlockPos pos2 = PositionUtils.getRelativeEndPositionFromAreaSize((Vec3i)areaSize);
                pos2 = PositionUtils.getTransformedBlockPos(pos2, this.mirror, this.rotation);
                pos2 = PositionUtils.getTransformedBlockPos(pos2, placement.getMirror(), placement.getRotation()).offset((Vec3i)boxOriginAbsolute);
                builder.put((Object)regionName, (Object)new Box(boxOriginAbsolute, pos2, regionName));
            } else {
                Servux.LOGGER.warn("SchematicPlacement.getSubRegionBoxFor(): Size for sub-region '{}' not found in the schematic '{}'", (Object)regionName, (Object)this.schematic.getMetadata().getName());
            }
        }
        return builder.build();
    }

    public Set<String> getRegionsTouchingChunk(int chunkX, int chunkZ) {
        ImmutableMap<String, Box> map = this.getSubRegionBoxes(SubRegionPlacement.RequiredEnabled.PLACEMENT_ENABLED);
        int chunkXMin = chunkX << 4;
        int chunkZMin = chunkZ << 4;
        int chunkXMax = chunkXMin + 15;
        int chunkZMax = chunkZMin + 15;
        HashSet<String> set = new HashSet<String>();
        for (Map.Entry entry : map.entrySet()) {
            Box box = (Box)entry.getValue();
            int boxXMin = Math.min(box.getPos1().getX(), box.getPos2().getX());
            int boxZMin = Math.min(box.getPos1().getZ(), box.getPos2().getZ());
            int boxXMax = Math.max(box.getPos1().getX(), box.getPos2().getX());
            int boxZMax = Math.max(box.getPos1().getZ(), box.getPos2().getZ());
            boolean notOverlapping = boxXMin > chunkXMax || boxZMin > chunkZMax || boxXMax < chunkXMin || boxZMax < chunkZMin;
            if (notOverlapping) continue;
            set.add((String)entry.getKey());
        }
        return set;
    }

    public ImmutableMap<String, IntBoundingBox> getBoxesWithinChunk(int chunkX, int chunkZ) {
        ImmutableMap<String, Box> subRegions = this.getSubRegionBoxes(SubRegionPlacement.RequiredEnabled.PLACEMENT_ENABLED);
        return PositionUtils.getBoxesWithinChunk(chunkX, chunkZ, subRegions);
    }

    @Nullable
    public IntBoundingBox getBoxWithinChunkForRegion(String regionName, int chunkX, int chunkZ) {
        Box box = (Box)this.getSubRegionBoxFor(regionName, SubRegionPlacement.RequiredEnabled.PLACEMENT_ENABLED).get((Object)regionName);
        return box != null ? PositionUtils.getBoundsWithinChunkForBox(box, chunkX, chunkZ) : null;
    }

    public Set<ChunkPos> getTouchedChunks() {
        return PositionUtils.getTouchedChunks(this.getSubRegionBoxes(SubRegionPlacement.RequiredEnabled.PLACEMENT_ENABLED));
    }

    public Set<ChunkPos> getTouchedChunksForRegion(String regionName) {
        return PositionUtils.getTouchedChunks(this.getSubRegionBoxFor(regionName, SubRegionPlacement.RequiredEnabled.PLACEMENT_ENABLED));
    }

    private void checkAreSubRegionsModified() {
        Map<String, BlockPos> areaPositions = this.schematic.getAreaPositions();
        if (areaPositions.size() != this.relativeSubRegionPlacements.size()) {
            this.regionPlacementsModified = true;
            return;
        }
        for (Map.Entry<String, BlockPos> entry : areaPositions.entrySet()) {
            SubRegionPlacement placement = this.relativeSubRegionPlacements.get(entry.getKey());
            if (placement != null && !placement.isRegionPlacementModified(entry.getValue())) continue;
            this.regionPlacementsModified = true;
            return;
        }
        this.regionPlacementsModified = false;
    }

    public void moveSubRegionTo(String regionName, BlockPos newPos) {
        if (this.relativeSubRegionPlacements.containsKey(regionName)) {
            newPos = newPos.subtract((Vec3i)this.origin);
            newPos = PositionUtils.getReverseTransformedBlockPos(newPos, this.mirror, this.rotation);
            this.relativeSubRegionPlacements.get(regionName).setPos(newPos);
            this.onModified();
        }
    }

    public void setSubRegionRotation(String regionName, Rotation rotation) {
        if (this.relativeSubRegionPlacements.containsKey(regionName)) {
            this.relativeSubRegionPlacements.get(regionName).setRotation(rotation);
            this.onModified();
        }
    }

    public void setSubRegionMirror(String regionName, Mirror mirror) {
        if (this.relativeSubRegionPlacements.containsKey(regionName)) {
            this.relativeSubRegionPlacements.get(regionName).setMirror(mirror);
            this.onModified();
        }
    }

    public void resetAllSubRegionsToSchematicValues() {
        this.resetAllSubRegionsToSchematicValues(true);
    }

    public void resetAllSubRegionsToSchematicValues(boolean updatePlacementManager) {
        if (updatePlacementManager) {
            // empty if block
        }
        Map<String, BlockPos> areaPositions = this.schematic.getAreaPositions();
        this.relativeSubRegionPlacements.clear();
        this.regionPlacementsModified = false;
        for (Map.Entry<String, BlockPos> entry : areaPositions.entrySet()) {
            String name = entry.getKey();
            this.relativeSubRegionPlacements.put(name, new SubRegionPlacement(entry.getValue(), name));
        }
        if (updatePlacementManager) {
            this.updateEnclosingBox();
        }
    }

    public void resetSubRegionToSchematicValues(String regionName) {
        BlockPos pos = this.schematic.getSubRegionPosition(regionName);
        SubRegionPlacement placement = this.relativeSubRegionPlacements.get(regionName);
        if (pos != null && placement != null) {
            placement.resetToOriginalValues();
            this.onModified();
        }
    }

    public SchematicPlacement setOrigin(BlockPos origin) {
        if (!this.origin.equals((Object)(origin = PositionUtils.getModifiedPartiallyLockedPosition(this.origin, origin, this.coordinateLockMask)))) {
            this.origin = origin;
            this.updateEnclosingBox();
        }
        return this;
    }

    public SchematicPlacement setRotation(Rotation rotation) {
        if (this.rotation != rotation) {
            this.rotation = rotation;
            this.updateEnclosingBox();
        }
        return this;
    }

    public SchematicPlacement setMirror(Mirror mirror) {
        if (this.mirror != mirror) {
            this.mirror = mirror;
            this.updateEnclosingBox();
        }
        return this;
    }

    private void onModified() {
        this.checkAreSubRegionsModified();
        this.updateEnclosingBox();
    }

    public void onRemoved() {
        if (USED_COLORS.isEmpty()) {
            // empty if block
        }
    }

    private Box getEnclosingBox() {
        ImmutableMap<String, Box> boxes = this.getSubRegionBoxes(SubRegionPlacement.RequiredEnabled.ANY);
        BlockPos pos1 = null;
        BlockPos pos2 = null;
        for (Box box : boxes.values()) {
            BlockPos tmp = PositionUtils.getMinCorner(box.getPos1(), box.getPos2());
            if (pos1 == null) {
                pos1 = tmp;
            } else if (tmp.getX() < pos1.getX() || tmp.getY() < pos1.getY() || tmp.getZ() < pos1.getZ()) {
                pos1 = PositionUtils.getMinCorner(tmp, pos1);
            }
            tmp = PositionUtils.getMaxCorner(box.getPos1(), box.getPos2());
            if (pos2 == null) {
                pos2 = tmp;
                continue;
            }
            if (tmp.getX() <= pos2.getX() && tmp.getY() <= pos2.getY() && tmp.getZ() <= pos2.getZ()) continue;
            pos2 = PositionUtils.getMaxCorner(tmp, pos2);
        }
        if (pos1 != null && pos2 != null) {
            return new Box(pos1, pos2, "Enclosing Box (Servux)");
        }
        return null;
    }

    public void pasteTo(ServerLevel serverWorld, ReplaceBehavior replaceBehavior, PasteLayerBehavior layerBehavior, @Nullable LayerRange layerRange) {
        this.getEnclosingBox().toVanilla().intersectingChunks().forEach(chunkPos -> SchematicPlacingUtils.placeToWorldWithinChunk((Level)serverWorld, chunkPos, this, replaceBehavior, layerBehavior, layerRange, false));
    }
}

