/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.command.api;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.boxadactle.boxlib.command.BCommandManager;
import dev.boxadactle.boxlib.command.BCommandSourceStack;
import dev.boxadactle.boxlib.command.api.BClientSubcommand;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class BClientCommand {
    protected String commandName;
    protected Function<CommandContext<BCommandSourceStack>, Integer> rootCommand;
    protected List<BClientSubcommand> subcommands;

    public static BClientCommand create(String commandName, Function<CommandContext<BCommandSourceStack>, Integer> rootCommand) {
        return new BClientCommand(commandName, rootCommand);
    }

    public static BClientCommand create(String commandName) {
        return new BClientCommand(commandName, context -> 0);
    }

    protected BClientCommand(String commandName, Function<CommandContext<BCommandSourceStack>, Integer> rootCommand) {
        this.commandName = commandName;
        this.rootCommand = rootCommand;
        this.subcommands = new ArrayList<BClientSubcommand>();
    }

    public void register(CommandDispatcher<BCommandSourceStack> dispatcher) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)BCommandManager.literal(this.commandName).executes(this.rootCommand::apply);
        for (BClientSubcommand subcommand : this.subcommands) {
            root.then(subcommand.buildSubcommand());
        }
        dispatcher.register(root);
    }

    public BClientCommand registerSubcommand(BClientSubcommand subcommand) {
        this.subcommands.add(subcommand);
        return this;
    }

    public BClientCommand registerSubcommand(final String name, final Function<CommandContext<BCommandSourceStack>, Integer> executor) {
        BClientSubcommand command = new BClientSubcommand(){

            @Override
            public ArgumentBuilder<BCommandSourceStack, ?> getSubcommand() {
                return BCommandManager.literal(name);
            }

            @Override
            public void build(ArgumentBuilder<BCommandSourceStack, ?> builder) {
                builder.executes(executor::apply);
            }
        };
        return this.registerSubcommand(command);
    }
}

