/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.gui.config;

import dev.boxadactle.boxlib.function.Converter;
import dev.boxadactle.boxlib.gui.config.BOptionEntry;
import dev.boxadactle.boxlib.gui.config.BOptionHelper;
import dev.boxadactle.boxlib.math.mathutils.Mappers;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;

public abstract class BOptionSlider<T extends Number>
extends AbstractSliderButton
implements BOptionEntry<T>,
Converter<T, Double> {
    protected T min;
    protected T max;
    protected String key;
    protected Consumer<T> function;

    public BOptionSlider(String key, T min, T max, T value, Consumer<T> function) {
        super(0, 0, 10, BOptionHelper.buttonHeight(), (Component)Component.translatable((String)key, (Object[])new Object[]{value}), 0.0);
        this.min = min;
        this.max = max;
        this.key = key;
        this.function = function;
        this.value = this.calculateSliderPos((Double)this.from(value));
    }

    private Double calculateSliderPos(Double value) {
        double newMax = (Double)this.from(this.max);
        double newMin = (Double)this.from(this.min);
        return Mappers.normalizeMap(value, newMin, newMax);
    }

    private Double calculateValue() {
        double newMax = (Double)this.from(this.max);
        double newMin = (Double)this.from(this.min);
        return Mappers.map(this.value, newMin, newMax);
    }

    @Override
    public T handleInput(T input) {
        Number newVal = (Number)this.to(this.calculateValue());
        this.function.accept(newVal);
        return (T)newVal;
    }

    protected abstract String roundNumber(T var1);

    protected void updateMessage() {
        this.setMessage((Component)Component.translatable((String)this.key, (Object[])new Object[]{this.roundNumber((Number)this.to(this.calculateValue()))}));
    }

    protected void applyValue() {
        this.handleInput((T)((Number)this.to(this.value)));
    }
}

