/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.gui.config;

import dev.boxadactle.boxlib.function.Converter;
import dev.boxadactle.boxlib.gui.config.BOptionEntry;
import dev.boxadactle.boxlib.gui.config.BOptionHelper;
import dev.boxadactle.boxlib.math.geometry.Rect;
import dev.boxadactle.boxlib.util.GuiUtils;
import dev.boxadactle.boxlib.util.MouseUtils;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;

public abstract class BOptionTextField<T>
extends EditBox
implements BOptionEntry<T>,
BOptionHelper,
Converter<T, String> {
    protected T currentValue;
    protected Consumer<T> function;
    protected boolean hasInvalidValue = false;

    public BOptionTextField(T value, Consumer<T> function) {
        super(GuiUtils.getTextRenderer(), 0, 0, 200, 18, (Component)Component.literal((String)"ConfigWidget"));
        this.currentValue = value;
        this.function = function;
        super.setResponder(this::onInput);
        super.insertText((String)this.from(value));
    }

    public void renderWidget(GuiGraphics p_93657_, int mouseX, int mouseY, float delta) {
        super.renderWidget(p_93657_, mouseX, mouseY, delta);
        if (this.isInvalid()) {
            this.setTextColor(0xFF5555);
        } else {
            this.setTextColor(0xE0E0E0);
        }
    }

    private void onInput(String input) {
        Object a = this.to(input);
        if (a == null) {
            return;
        }
        this.handleInput(a);
    }

    protected void setInvalid(boolean a) {
        this.hasInvalidValue = a;
    }

    @Override
    public boolean isInvalid() {
        return this.hasInvalidValue;
    }

    @Override
    public T handleInput(T input) {
        this.function.accept(input);
        return input;
    }

    public void setX(int x) {
        super.setX(x);
    }

    public void setY(int y) {
        super.setY(y);
    }

    public void setWidth(int width) {
        super.setWidth(width);
    }

    public boolean isHovered() {
        return super.isHovered();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public Component getMessage() {
        return super.getMessage();
    }

    public void onClick(double mouseX, double mouseY) {
        if (!MouseUtils.isMouseHovering(new Rect<Integer>(this.getX(), this.getY(), this.width, this.height))) {
            super.setFocused(false);
        }
        super.onClick(mouseX, mouseY);
    }
}

