/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.http;

import dev.boxadactle.boxlib.core.BoxLib;
import dev.boxadactle.boxlib.http.InvalidHttpRequestException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URI;

public interface HttpRequest<T> {
    default public URI getRequestURI() throws InvalidHttpRequestException {
        try {
            String url = this.getRequestUrlString();
            return new URI(url);
        }
        catch (Exception e) {
            throw new InvalidHttpRequestException(e);
        }
    }

    default public String getRequestUrlString() throws InvalidHttpRequestException {
        throw new InvalidHttpRequestException("No request URL was specified.");
    }

    default public void setRequestHeaders(HttpURLConnection c) throws ProtocolException {
        c.setConnectTimeout(5000);
        c.setReadTimeout(5000);
    }

    public T handleResponse(String var1);

    default public void onOtherResponse(int code) {
        BoxLib.LOGGER.warn("Server responded with an unexpected response: " + code, new Object[0]);
    }

    default public void onException(Exception e) {
        BoxLib.LOGGER.error("Error occurred when sending http request:", new Object[0]);
        BoxLib.LOGGER.printStackTrace(e);
    }

    default public T onResponseCode(HttpURLConnection c, int responseCode) {
        try {
            if (responseCode == 200) {
                String string;
                BufferedReader b = new BufferedReader(new InputStreamReader(c.getInputStream()));
                StringBuilder content = new StringBuilder();
                while ((string = b.readLine()) != null) {
                    content.append(string).append("\n");
                }
                b.close();
                return this.handleResponse(content.toString().trim());
            }
            return null;
        }
        catch (Exception e) {
            this.onException(e);
            return null;
        }
    }
}

