/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.math.geometry;

public class Line<T extends Number> {
    private T slope;
    private T yIntercept;

    public Line(T slope, T yIntercept) {
        this.slope = slope;
        this.yIntercept = yIntercept;
    }

    public T getSlope() {
        return this.slope;
    }

    public T getYIntercept() {
        return this.yIntercept;
    }

    public boolean intersects(Line<T> otherLine) {
        return !this.slope.equals(otherLine.getSlope());
    }

    public T intersectionX(Line<T> otherLine) {
        if (!this.intersects(otherLine)) {
            throw new IllegalArgumentException("Lines are parallel and do not intersect.");
        }
        return (T)Double.valueOf(((Double)otherLine.getYIntercept() - (Double)this.yIntercept) / ((Double)this.slope - (Double)otherLine.getSlope()));
    }

    public T intersectionY(Line<T> otherLine) {
        if (!this.intersects(otherLine)) {
            throw new IllegalArgumentException("Lines are parallel and do not intersect.");
        }
        return (T)Double.valueOf((Double)this.slope * (Double)this.intersectionX(otherLine) + (Double)this.yIntercept);
    }

    protected Line<T> clone() {
        return new Line<T>(this.slope, this.yIntercept);
    }
}

