/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.prompt.gui;

import dev.boxadactle.boxlib.prompt.PromptScreen;
import dev.boxadactle.boxlib.util.RenderUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public abstract class NumberScreen<T extends Number>
extends PromptScreen<T> {
    EditBox inputBox;
    Component message;

    public NumberScreen(Screen parent, Component message) {
        super(parent);
        this.message = message;
    }

    @Nullable
    protected abstract T parse(String var1);

    @Override
    protected T getData() {
        return this.parse(this.inputBox.getValue());
    }

    @Override
    protected boolean allowContinue() {
        try {
            return this.inputBox != null && !this.inputBox.getValue().isBlank() && this.parse(this.inputBox.getValue()) != null;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.inputBox != null) {
            if (!this.allowContinue()) {
                this.inputBox.setTextColor(0xFF5555);
            } else {
                this.inputBox.setTextColor(0xFFFFFF);
            }
        }
    }

    @Override
    protected void init() {
        super.init();
        this.inputBox = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.width / 2 - 150, this.height / 2 - 10, 300, 20, (Component)Component.literal((String)"Input box")));
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        super.render(guiGraphics, i, j, f);
        RenderUtils.drawTextCentered(guiGraphics, this.message, this.width / 2, this.height / 2 - 50);
    }
}

