/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.translate;

import com.google.common.html.HtmlEscapers;
import dev.boxadactle.boxlib.http.Request;
import dev.boxadactle.boxlib.translate.Language;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Translator {
    static String regex = "<div class=\"result-container\">([^<]+)</div>";

    private static String getUrl(String text, String sourceLang, String targetLang) {
        return "https://translate.google.com/m?hl=en&sl=" + sourceLang + "&tl=" + targetLang + "&ie=UTF-8&prev=_m&q=" + URLEncoder.encode(text, StandardCharsets.UTF_8).replace("+", "%20");
    }

    private static String decodeHTMLText(String text) {
        return HtmlEscapers.htmlEscaper().escape(text);
    }

    public static String translate(String text, Language sourceLang, Language targetLang) {
        String url = Translator.getUrl(text, sourceLang.getCode(), targetLang.getCode());
        String html = Request.sendPlainGetRequest(url);
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(html);
        if (matcher.find()) {
            return Translator.decodeHTMLText(matcher.group(1));
        }
        return text;
    }

    public static String translate(String text, Language targetLang) {
        return Translator.translate(text, Language.AUTO, targetLang);
    }
}

