/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.gui.config;

import dev.boxadactle.boxlib.util.ClientUtils;
import dev.boxadactle.boxlib.util.GuiUtils;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;

public interface BOptionHelper {
    default public Button createCancelButton(int startX, int startY, Screen parent) {
        return this.createCancelButton(startX, startY, (Button b) -> ClientUtils.setScreen(parent));
    }

    default public Button createCancelButton(int startX, int startY, Consumer<Button> ButtonConsumer) {
        return new Button.Builder(GuiUtils.CANCEL, ButtonConsumer::accept).bounds(startX, startY, this.getButtonWidth(ButtonType.NORMAL), this.getButtonHeight()).build();
    }

    default public Button createDoneButton(int startX, int startY, Screen parent) {
        return this.createDoneButton(startX, startY, (Button b) -> ClientUtils.setScreen(parent));
    }

    default public Button createDoneButton(int startX, int startY, Consumer<Button> ButtonConsumer) {
        return new Button.Builder(GuiUtils.DONE, ButtonConsumer::accept).bounds(startX, startY, this.getButtonWidth(ButtonType.NORMAL), this.getButtonHeight()).build();
    }

    default public Button createBackButton(int startX, int startY, Screen parent) {
        return new Button.Builder(GuiUtils.BACK, b -> ClientUtils.setScreen(parent)).bounds(startX, startY, this.getButtonWidth(ButtonType.NORMAL), this.getButtonHeight()).build();
    }

    default public Button createSaveButton(int startX, int startY, Consumer<Button> saveConsumer) {
        return new Button.Builder(GuiUtils.SAVE, saveConsumer::accept).bounds(startX, startY, this.getButtonWidth(ButtonType.NORMAL), this.getButtonHeight()).build();
    }

    default public Button createHalfCancelButton(int startX, int startY, Screen parent) {
        return this.createHalfCancelButton(startX, startY, (Button b) -> ClientUtils.setScreen(parent));
    }

    default public Button createHalfCancelButton(int startX, int startY, Consumer<Button> ButtonConsumer) {
        return new Button.Builder(GuiUtils.CANCEL, ButtonConsumer::accept).bounds(startX, startY, this.getButtonWidth(ButtonType.SMALL), this.getButtonHeight()).build();
    }

    default public Button createHalfDoneButton(int startX, int startY, Screen parent) {
        return this.createHalfDoneButton(startX, startY, (Button b) -> ClientUtils.setScreen(parent));
    }

    default public Button createHalfDoneButton(int startX, int startY, Consumer<Button> ButtonConsumer) {
        return new Button.Builder(GuiUtils.DONE, ButtonConsumer::accept).bounds(startX, startY, this.getButtonWidth(ButtonType.SMALL), this.getButtonHeight()).build();
    }

    default public Button createHalfSaveButton(int startX, int startY, Consumer<Button> saveConsumer) {
        return new Button.Builder(GuiUtils.SAVE, saveConsumer::accept).bounds(startX + this.getButtonWidth(ButtonType.SMALL) + this.getPadding(), startY, this.getButtonWidth(ButtonType.SMALL), this.getButtonHeight()).build();
    }

    default public Button createOkButton(int startX, int startY, Consumer<Button> saveConsumer) {
        return new Button.Builder(GuiUtils.OK, saveConsumer::accept).bounds(startX, startY, this.getButtonWidth(ButtonType.NORMAL), this.getButtonHeight()).build();
    }

    default public Button createHalfOkButton(int startX, int startY, Consumer<Button> saveConsumer) {
        return new Button.Builder(GuiUtils.OK, saveConsumer::accept).bounds(startX + this.getButtonWidth(ButtonType.SMALL) + this.getPadding(), startY, this.getButtonWidth(ButtonType.SMALL), this.getButtonHeight()).build();
    }

    @Deprecated
    default public Button[] createSaveAndCancelButton(int startX, int startY, Screen parent, Consumer<Button> saveConsumer) {
        Button[] buttonArray = new Button[2];
        buttonArray[0] = new Button.Builder(GuiUtils.CANCEL, b -> ClientUtils.setScreen(parent)).bounds(startX, startY, this.getButtonWidth(ButtonType.SMALL), this.getButtonHeight()).build();
        buttonArray[1] = new Button.Builder(GuiUtils.SAVE, saveConsumer::accept).bounds(startX + this.getButtonWidth(ButtonType.SMALL) + this.getButtonHeight(), startY, this.getButtonWidth(ButtonType.SMALL), this.getButtonHeight()).build();
        return buttonArray;
    }

    default public int getButtonHeight() {
        return BOptionHelper.buttonHeight();
    }

    default public int getButtonWidth(ButtonType type) throws IllegalStateException {
        return BOptionHelper.buttonWidth(type);
    }

    default public int getPadding() {
        return BOptionHelper.padding();
    }

    public static int buttonHeight() {
        return 20;
    }

    public static int buttonWidth(ButtonType type) throws IllegalStateException {
        switch (type.ordinal()) {
            case 0: {
                return 250;
            }
            case 1: {
                return 123;
            }
            case 2: {
                return 75;
            }
        }
        throw new IllegalStateException("Could not find button type" + type.name());
    }

    public static int padding() {
        return 2;
    }

    public static enum ButtonType {
        NORMAL,
        SMALL,
        TINY;

    }
}

