/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.gui.config;

import com.google.common.collect.ImmutableList;
import dev.boxadactle.boxlib.gui.config.BOptionEntry;
import dev.boxadactle.boxlib.gui.config.BOptionHelper;
import dev.boxadactle.boxlib.gui.config.BOptionScreen;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;

public class BOptionList
extends ContainerObjectSelectionList<ConfigEntry> {
    public BOptionList(Minecraft minecraft, BOptionScreen screen) {
        super(minecraft, screen.width, screen.height - 54, 24, 20);
    }

    public int addEntry(ConfigEntry entry) {
        return super.addEntry((AbstractSelectionList.Entry)entry);
    }

    public boolean hasInvalidEntry() {
        AtomicBoolean a = new AtomicBoolean(false);
        this.children().forEach(configWidgetEntry -> {
            if (configWidgetEntry.isInvalid()) {
                a.set(true);
            }
        });
        return a.get();
    }

    protected int getScrollbarPosition() {
        return super.getScrollbarPosition() + 35;
    }

    public int getRowWidth() {
        return super.getRowWidth() + 30;
    }

    public static abstract class ConfigEntry
    extends ContainerObjectSelectionList.Entry<ConfigEntry> {
        public List<? extends NarratableEntry> narratables() {
            return this.getWidgets();
        }

        public List<? extends GuiEventListener> children() {
            return this.getWidgets();
        }

        abstract List<? extends AbstractWidget> getWidgets();

        public abstract boolean isInvalid();
    }

    public static class DoubleEntry
    extends ConfigEntry {
        BOptionEntry<?> widget1;
        BOptionEntry<?> widget2;

        public DoubleEntry(BOptionEntry<?> widget1, BOptionEntry<?> widget2) {
            this.widget1 = widget1;
            this.widget2 = widget2;
        }

        @Override
        List<? extends AbstractWidget> getWidgets() {
            return ImmutableList.of((Object)((AbstractWidget)this.widget1), (Object)((AbstractWidget)this.widget2));
        }

        @Override
        public boolean isInvalid() {
            return this.widget1.isInvalid() || this.widget2.isInvalid();
        }

        public void render(GuiGraphics p_93523_, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            AbstractWidget w1 = (AbstractWidget)this.widget1;
            AbstractWidget w2 = (AbstractWidget)this.widget2;
            int p1 = BOptionHelper.padding() / 2;
            int p2 = BOptionHelper.padding() / 2;
            w1.setX(x);
            w1.setY(y);
            w1.setWidth(entryWidth / 2 - p1);
            w2.setX(x + entryWidth / 2 + p2);
            w2.setY(y);
            w2.setWidth(entryWidth / 2 - p2);
            w1.render(p_93523_, mouseX, mouseY, tickDelta);
            w2.render(p_93523_, mouseX, mouseY, tickDelta);
        }
    }

    public static class SingleEntry
    extends ConfigEntry {
        BOptionEntry<?> widget;

        public SingleEntry(BOptionEntry<?> widget) {
            this.widget = widget;
        }

        public void render(GuiGraphics p_93523_, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            AbstractWidget w = (AbstractWidget)this.widget;
            w.setX(x);
            w.setY(y);
            w.setWidth(entryWidth);
            w.render(p_93523_, mouseX, mouseY, tickDelta);
        }

        @Override
        List<? extends AbstractWidget> getWidgets() {
            return ImmutableList.of((Object)((AbstractWidget)this.widget));
        }

        @Override
        public boolean isInvalid() {
            return this.widget.isInvalid();
        }
    }
}

