/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.gui.config;

import com.google.common.collect.ImmutableList;
import dev.boxadactle.boxlib.gui.config.BOptionEntry;
import dev.boxadactle.boxlib.gui.config.BOptionHelper;
import dev.boxadactle.boxlib.util.ClientUtils;
import dev.boxadactle.boxlib.util.RenderUtils;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public abstract class BOptionScreen
extends Screen
implements BOptionHelper {
    protected Screen parent;
    protected ConfigList configList;
    protected Button saveButton;

    public BOptionScreen(Screen parent) {
        super((Component)Component.literal((String)"Config Screen"));
        this.parent = parent;
    }

    protected void init() {
        this.configList = new ConfigList(ClientUtils.getClient());
        this.addWidget((GuiEventListener)this.configList);
        this.initConfigButtons();
        this.initFooter(this.width / 2 - BOptionHelper.padding() / 2 - BOptionHelper.buttonWidth(BOptionHelper.ButtonType.SMALL), this.height - this.getButtonHeight() - this.getPadding());
    }

    public void onClose() {
        ClientUtils.getClient().setScreen(this.parent);
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        super.render(guiGraphics, i, j, f);
        if (this.shouldRenderScrollingWidget()) {
            this.configList.render(guiGraphics, i, j, f);
        }
        RenderUtils.drawTextCentered(guiGraphics, this.getName(), this.width / 2, 5);
    }

    public void tick() {
        super.tick();
        if (this.saveButton != null) {
            boolean a;
            boolean bl = a = !this.configList.hasInvalidEntry();
            if (this.saveButton.active != a) {
                this.saveButton.active = a;
            }
        }
    }

    protected abstract Component getName();

    protected abstract void initFooter(int var1, int var2);

    protected abstract void initConfigButtons();

    protected boolean shouldRenderScrollingWidget() {
        return true;
    }

    protected int getRowWidth() {
        return 220;
    }

    protected int getRowHeight() {
        return BOptionHelper.buttonHeight() + BOptionHelper.padding() * 2;
    }

    protected int getScrollbarPosition() {
        return this.width / 2 + 124;
    }

    protected int getScrollingWidgetStart() {
        return 20;
    }

    protected int getScrollingWidgetEnd() {
        return this.height - 30;
    }

    @Deprecated
    protected BOptionEntry<?> addConfigOption(BOptionEntry<?> entry) {
        this.configList.addEntry(new ConfigList.SingleEntry(entry));
        return entry;
    }

    protected <T extends BOptionEntry<?>> T addConfigLine(T entry) {
        this.configList.addEntry(new ConfigList.SingleEntry(entry));
        return entry;
    }

    protected <T extends BOptionEntry<?>> BOptionEntry<?>[] addConfigLine(T entry, T entry2) {
        this.configList.addEntry(new ConfigList.DoubleEntry(entry, entry2));
        return new BOptionEntry[]{entry, entry2};
    }

    protected <T extends ConfigList.ConfigEntry> T addConfigLine(T entry) {
        this.configList.addEntry(entry);
        return entry;
    }

    protected void setWiki(Component label, String link) {
        this.addRenderableWidget((GuiEventListener)new Button.Builder(label, b -> ClientUtils.openLinkConfirmScreen(link, this)).bounds(3, 3, BOptionHelper.buttonWidth(BOptionHelper.ButtonType.TINY), BOptionHelper.buttonHeight() - 3).build());
    }

    protected Button setSaveButton(Button saveButton) {
        this.saveButton = saveButton;
        return (Button)this.addRenderableWidget((GuiEventListener)saveButton);
    }

    public class ConfigList
    extends ContainerObjectSelectionList<ConfigEntry> {
        public ConfigList(Minecraft minecraft) {
            super(minecraft, BOptionScreen.this.width, BOptionScreen.this.getScrollingWidgetEnd() - BOptionScreen.this.getScrollingWidgetStart(), BOptionScreen.this.getScrollingWidgetStart(), BOptionScreen.this.getRowHeight());
        }

        public int getRowWidth() {
            return BOptionScreen.this.getRowWidth();
        }

        protected int getScrollbarPosition() {
            return BOptionScreen.this.getScrollbarPosition();
        }

        public int addEntry(ConfigEntry entry) {
            return super.addEntry((AbstractSelectionList.Entry)entry);
        }

        public boolean hasInvalidEntry() {
            AtomicBoolean a = new AtomicBoolean(false);
            this.children().forEach(configWidgetEntry -> {
                if (configWidgetEntry.isInvalid()) {
                    a.set(true);
                }
            });
            return a.get();
        }

        public static abstract class ConfigEntry
        extends ContainerObjectSelectionList.Entry<ConfigEntry> {
            public List<? extends NarratableEntry> narratables() {
                return this.getWidgets();
            }

            public List<? extends GuiEventListener> children() {
                return this.getWidgets();
            }

            public abstract List<? extends AbstractWidget> getWidgets();

            public abstract boolean isInvalid();
        }

        public static class DoubleEntry
        extends ConfigEntry {
            BOptionEntry<?> widget1;
            BOptionEntry<?> widget2;

            public DoubleEntry(BOptionEntry<?> widget1, BOptionEntry<?> widget2) {
                this.widget1 = widget1;
                this.widget2 = widget2;
            }

            @Override
            public List<? extends AbstractWidget> getWidgets() {
                return ImmutableList.of((Object)((AbstractWidget)this.widget1), (Object)((AbstractWidget)this.widget2));
            }

            @Override
            public boolean isInvalid() {
                return this.widget1.isInvalid() || this.widget2.isInvalid();
            }

            public void render(GuiGraphics p_93523_, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                AbstractWidget w1 = (AbstractWidget)this.widget1;
                AbstractWidget w2 = (AbstractWidget)this.widget2;
                int p1 = BOptionHelper.padding() / 2;
                int p2 = BOptionHelper.padding() / 2;
                w1.setX(x);
                w1.setY(y);
                w1.setWidth(entryWidth / 2 - p1);
                w2.setX(x + entryWidth / 2 + p2);
                w2.setY(y);
                w2.setWidth(entryWidth / 2 - p2);
                w1.render(p_93523_, mouseX, mouseY, tickDelta);
                w2.render(p_93523_, mouseX, mouseY, tickDelta);
            }
        }

        public static class SingleEntry
        extends ConfigEntry {
            BOptionEntry<?> widget;

            public SingleEntry(BOptionEntry<?> widget) {
                this.widget = widget;
            }

            public void render(GuiGraphics p_93523_, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                AbstractWidget w = (AbstractWidget)this.widget;
                w.setX(x);
                w.setY(y);
                w.setWidth(entryWidth);
                w.render(p_93523_, mouseX, mouseY, tickDelta);
            }

            @Override
            public List<? extends AbstractWidget> getWidgets() {
                return ImmutableList.of((Object)((AbstractWidget)this.widget));
            }

            @Override
            public boolean isInvalid() {
                return this.widget.isInvalid();
            }
        }
    }

    public static interface Provider<T extends Screen> {
        public T createScreen(Screen var1);
    }
}

