/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.math.geometry;

import dev.boxadactle.boxlib.math.geometry.Vec3;

public class Box<T extends Number> {
    public T x;
    public T y;
    public T z;
    public T width;
    public T height;
    public T depth;

    public Box(T x, T y, T z, T width, T height, T depth) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.width = width;
        this.height = height;
        this.depth = depth;
    }

    public Box<T> setX(T x) {
        this.x = x;
        return this;
    }

    public Box<T> setY(T y) {
        this.y = y;
        return this;
    }

    public Box<T> setZ(T z) {
        this.z = z;
        return this;
    }

    public Box<T> setWidth(T width) {
        this.width = width;
        return this;
    }

    public Box<T> setHeight(T height) {
        this.height = height;
        return this;
    }

    public Box<T> setDepth(T depth) {
        this.depth = depth;
        return this;
    }

    public T getX() {
        return this.x;
    }

    public T getY() {
        return this.y;
    }

    public T getZ() {
        return this.z;
    }

    public double getWidth() {
        return ((Number)this.maxX()).doubleValue() - ((Number)this.minX()).doubleValue();
    }

    public double getHeight() {
        return ((Number)this.maxY()).doubleValue() - ((Number)this.minY()).doubleValue();
    }

    public double getDepth() {
        return ((Number)this.maxZ()).doubleValue() - ((Number)this.minZ()).doubleValue();
    }

    public T minX() {
        return this.x;
    }

    public T minY() {
        return this.y;
    }

    public T minZ() {
        return this.z;
    }

    public T maxX() {
        return (T)Double.valueOf(((Number)this.x).doubleValue() + ((Number)this.width).doubleValue());
    }

    public T maxY() {
        return (T)Double.valueOf(((Number)this.y).doubleValue() + ((Number)this.height).doubleValue());
    }

    public T maxZ() {
        return (T)Double.valueOf(((Number)this.z).doubleValue() + ((Number)this.depth).doubleValue());
    }

    public boolean contains(Vec3<T> point) {
        return ((Number)point.x).doubleValue() >= ((Number)this.minX()).doubleValue() && ((Number)point.x).doubleValue() <= ((Number)this.maxX()).doubleValue() && ((Number)point.y).doubleValue() >= ((Number)this.minY()).doubleValue() && ((Number)point.y).doubleValue() <= ((Number)this.maxY()).doubleValue() && ((Number)point.z).doubleValue() >= ((Number)this.minZ()).doubleValue() && ((Number)point.z).doubleValue() <= ((Number)this.maxZ()).doubleValue();
    }

    public boolean contains(Box<T> box) {
        return ((Number)box.minX()).doubleValue() >= ((Number)this.minX()).doubleValue() && ((Number)box.maxX()).doubleValue() <= ((Number)this.maxX()).doubleValue() && ((Number)box.minY()).doubleValue() >= ((Number)this.minY()).doubleValue() && ((Number)box.maxY()).doubleValue() <= ((Number)this.maxY()).doubleValue() && ((Number)box.minZ()).doubleValue() >= ((Number)this.minZ()).doubleValue() && ((Number)box.maxZ()).doubleValue() <= ((Number)this.maxZ()).doubleValue();
    }

    public boolean intersects(Box<T> box) {
        return ((Number)this.maxX()).doubleValue() > ((Number)box.minX()).doubleValue() && ((Number)this.minX()).doubleValue() < ((Number)box.maxX()).doubleValue() && ((Number)this.maxY()).doubleValue() > ((Number)box.minY()).doubleValue() && ((Number)this.minY()).doubleValue() < ((Number)box.maxY()).doubleValue() && ((Number)this.maxZ()).doubleValue() > ((Number)box.minZ()).doubleValue() && ((Number)this.minZ()).doubleValue() < ((Number)box.maxZ()).doubleValue();
    }

    public Box<T> clone() {
        return new Box<T>(this.minX(), this.minY(), this.minZ(), this.maxX(), this.maxY(), this.maxZ());
    }

    public String toString() {
        return "Box{x=" + String.valueOf(this.x) + ", y=" + String.valueOf(this.y) + ", z=" + String.valueOf(this.z) + ", width=" + String.valueOf(this.width) + ", height=" + String.valueOf(this.height) + ", depth=" + String.valueOf(this.depth) + "}";
    }
}

