/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.util;

import dev.boxadactle.boxlib.util.ClientUtils;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;

public class GuiUtils {
    public static final int BLACK = 0;
    public static final int DARK_BLUE = 170;
    public static final int DARK_GREEN = 43520;
    public static final int DARK_AQUA = 43690;
    public static final int DARK_RED = 0xAA0000;
    public static final int DARK_PURPLE = 0xAA00AA;
    public static final int GOLD = 0xFFAA00;
    public static final int GRAY = 0xAAAAAA;
    public static final int DARK_GRAY = 0x555555;
    public static final int BLUE = 0x5555FF;
    public static final int GREEN = 0x55FF55;
    public static final int AQUA = 0x55FFFF;
    public static final int RED = 0xFF5555;
    public static final int LIGHT_PURPLE = 0xFF55FF;
    public static final int YELLOW = 0xFFFF55;
    public static final int WHITE = 0xFFFFFF;
    public static Component ON;
    public static Component OFF;
    public static Component DONE;
    public static Component CANCEL;
    public static Component YES;
    public static Component NO;
    public static Component OK;
    public static Component ALL;
    public static Component BACK;
    public static Component SAVE;
    public static Component LOAD;
    public static Component REFRESH;
    public static Component ACCEPT;
    public static Component REJECT;
    public static Component ERROR_OCCURED;
    public static Component TRUE;
    public static Component FALSE;

    public static void init() {
        ON = Component.translatable((String)"options.on");
        OFF = Component.translatable((String)"options.off");
        DONE = Component.translatable((String)"gui.done");
        CANCEL = Component.translatable((String)"gui.cancel");
        YES = Component.translatable((String)"gui.yes");
        NO = Component.translatable((String)"gui.no");
        OK = Component.translatable((String)"mco.gui.ok");
        ALL = Component.translatable((String)"gui.all");
        BACK = Component.translatable((String)"gui.back");
        SAVE = Component.translatable((String)"structure_block.mode.save");
        LOAD = Component.translatable((String)"structure_block.mode.load");
        REFRESH = Component.translatable((String)"selectServer.refresh");
        ACCEPT = Component.translatable((String)"mco.invites.button.accept");
        REJECT = Component.translatable((String)"mco.invites.button.reject");
        ERROR_OCCURED = Component.translatable((String)"selectWorld.futureworld.error.title");
        TRUE = GuiUtils.colorize(YES, 0x55FF55);
        FALSE = GuiUtils.colorize(NO, 0xFF5555);
    }

    public static String getTranslatable(String key) {
        return Language.getInstance().getOrDefault(key);
    }

    public static Component colorize(Component text, int color) {
        return text.copy().withStyle(style -> style.withColor(color));
    }

    @Deprecated
    public static int getColorDecimal(String color) {
        String c;
        return switch (c = color.toLowerCase(Locale.ROOT)) {
            case "dark_red" -> 0xAA0000;
            case "red" -> 0xFF5555;
            case "gold" -> 0xFFAA00;
            case "yellow" -> 0xFFFF55;
            case "dark_green" -> 43520;
            case "green" -> 0x55FF55;
            case "aqua" -> 0x55FFFF;
            case "dark_aqua" -> 43690;
            case "dark_blue" -> 170;
            case "blue" -> 0x5555FF;
            case "light_purple" -> 0xFF55FF;
            case "dark_purple" -> 0xAA00AA;
            case "white" -> 0xFFFFFF;
            case "gray" -> 0xAAAAAA;
            case "dark_gray" -> 0x555555;
            case "black" -> 0;
            default -> 0xFFFFFF;
        };
    }

    public static int getTextSize(Component text) {
        return GuiUtils.getTextRenderer().width((FormattedText)text);
    }

    public static int getTextHeight() {
        Objects.requireNonNull(ClientUtils.getClient().font);
        return 9;
    }

    public static int getLongestLength(Component ... text) {
        int largest = 0;
        Font textRenderer = GuiUtils.getTextRenderer();
        for (Component value : text) {
            int t = textRenderer.width((FormattedText)value);
            if (t <= largest) continue;
            largest = t;
        }
        return largest;
    }

    public static int getShortestLength(Component ... text) {
        int shortest = 0;
        Font textRenderer = GuiUtils.getTextRenderer();
        shortest = textRenderer.width((FormattedText)text[0]);
        for (Component value : text) {
            int t = textRenderer.width((FormattedText)value);
            if (t >= shortest) continue;
            shortest = t;
        }
        return shortest;
    }

    public static int getLongestWidget(AbstractWidget ... widgets) {
        int longest = 0;
        for (AbstractWidget widget : widgets) {
            int t = widget.getWidth();
            if (t <= longest) continue;
            longest = t;
        }
        return longest;
    }

    public static Component createHyperLink(Component text, String link) {
        return text.copy().withStyle(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.BLUE}).withStyle(a1 -> a1.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, link)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"chat.link.open"))));
    }

    public static int getTallestWidget(AbstractWidget ... widgets) {
        int tallest = 0;
        for (AbstractWidget widget : widgets) {
            int t = widget.getHeight();
            if (t <= tallest) continue;
            tallest = t;
        }
        return tallest;
    }

    public static int nonZeroGuiScale() {
        int scale = (Integer)ClientUtils.getOptions().guiScale().get();
        Minecraft client = ClientUtils.getClient();
        if (scale == 0) {
            return (int)Math.max(1.0, Math.min(Math.floor(client.getWindow().getGuiScaledWidth() / 320), Math.floor(client.getWindow().getGuiScaledHeight() / 240)));
        }
        return scale;
    }

    public static Component surround(String str1, String str2, Component input) {
        return Component.literal((String)str1).append(input).append((Component)Component.literal((String)str2));
    }

    public static Component parentheses(Component input) {
        return GuiUtils.surround("(", ")", input);
    }

    public static Component brackets(Component input) {
        return GuiUtils.surround("[", "]", input);
    }

    public static Component quotes(Component input) {
        return GuiUtils.surround("\"", "\"", input);
    }

    public static Font getTextRenderer() {
        return ClientUtils.getClient().font;
    }
}

