/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.util;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import dev.boxadactle.boxlib.util.ClientUtils;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.PlayerTeam;

public class WorldUtils {
    public static Entity getCamera() {
        return ClientUtils.getClient().getCameraEntity();
    }

    public static Player getPlayer() {
        return ClientUtils.getClient().player;
    }

    public static Level getWorld() {
        return ClientUtils.getClient().level;
    }

    public static String getCurrentDimension() {
        ResourceKey registry = WorldUtils.getPlayer().level().dimension();
        return registry.location().toString();
    }

    public static List<PlayerInfo> getTabListUnordered() {
        ClientPacketListener clientPlayNetworkHandler = ClientUtils.getClient().getConnection();
        return clientPlayNetworkHandler.getOnlinePlayers().stream().toList();
    }

    public static List<PlayerInfo> getTabList() {
        return Ordering.from((Comparator)new EntryOrderComparator()).sortedCopy(WorldUtils.getTabListUnordered());
    }

    static class EntryOrderComparator
    implements Comparator<PlayerInfo> {
        EntryOrderComparator() {
        }

        @Override
        public int compare(PlayerInfo playerListEntry, PlayerInfo playerListEntry2) {
            PlayerTeam team = playerListEntry.getTeam();
            PlayerTeam team2 = playerListEntry2.getTeam();
            return ComparisonChain.start().compareTrueFirst(playerListEntry.getGameMode() != GameType.SPECTATOR, playerListEntry2.getGameMode() != GameType.SPECTATOR).compare((Comparable)((Object)(team != null ? team.getName() : "")), (Comparable)((Object)(team2 != null ? team2.getName() : ""))).compare((Object)playerListEntry.getProfile().getName(), (Object)playerListEntry2.getProfile().getName(), String::compareToIgnoreCase).result();
        }
    }
}

