/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.gui.config;

import dev.boxadactle.boxlib.util.ClientUtils;
import dev.boxadactle.boxlib.util.GuiUtils;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;

public interface BOptionHelper {
    default public Button createCancelButton(Screen parent) {
        return this.createCancelButton((Button b) -> ClientUtils.setScreen(parent));
    }

    default public Button createCancelButton(Consumer<Button> ButtonConsumer) {
        return new Button.Builder(GuiUtils.CANCEL, ButtonConsumer::accept).build();
    }

    default public Button createDoneButton(Screen parent) {
        return this.createDoneButton((Button b) -> ClientUtils.setScreen(parent));
    }

    default public Button createDoneButton(Consumer<Button> ButtonConsumer) {
        return new Button.Builder(GuiUtils.DONE, ButtonConsumer::accept).build();
    }

    default public Button createBackButton(Screen parent) {
        return new Button.Builder(GuiUtils.BACK, b -> ClientUtils.setScreen(parent)).build();
    }

    default public Button createSaveButton(Consumer<Button> saveConsumer) {
        return new Button.Builder(GuiUtils.SAVE, saveConsumer::accept).build();
    }

    default public Button createOkButton(Consumer<Button> saveConsumer) {
        return new Button.Builder(GuiUtils.OK, saveConsumer::accept).build();
    }

    default public int getButtonHeight() {
        return BOptionHelper.buttonHeight();
    }

    default public int getButtonWidth(ButtonType type) throws IllegalStateException {
        return BOptionHelper.buttonWidth(type);
    }

    default public int getPadding() {
        return BOptionHelper.padding();
    }

    public static int buttonHeight() {
        return 20;
    }

    public static int buttonWidth(ButtonType type) throws IllegalStateException {
        switch (type.ordinal()) {
            case 0: {
                return 250;
            }
            case 1: {
                return 123;
            }
            case 2: {
                return 75;
            }
        }
        throw new IllegalStateException("Could not find button type" + type.name());
    }

    public static int padding() {
        return 2;
    }

    public static enum ButtonType {
        NORMAL,
        SMALL,
        TINY;

    }
}

