/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.boxadactle.boxlib.config.BConfig;
import dev.boxadactle.boxlib.core.BoxLib;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.function.Supplier;

public class BConfigClass<T extends BConfig>
implements Supplier<T> {
    Class<T> configClass;
    File filePath;
    Gson serializer;
    T config;
    T cached;

    public BConfigClass(Class<T> configClass, File configFile) {
        this.configClass = configClass;
        this.filePath = configFile;
        this.serializer = new GsonBuilder().setPrettyPrinting().create();
        this.config = (BConfig)BoxLib.initializeClass(configClass);
    }

    @Override
    public T get() {
        return this.config;
    }

    public void reload() {
        this.load();
    }

    public void resetConfig() {
        this.config = (BConfig)BoxLib.initializeClass(this.configClass);
        this.save();
    }

    public void cacheConfig() {
        try {
            this.cached = BConfig.copy(this.config);
            BoxLib.LOGGER.info("Cached config for class %s", this.configClass.getSimpleName());
        }
        catch (Exception e) {
            BoxLib.LOGGER.error("Could not cache config for class %s", this.configClass.getSimpleName());
            BoxLib.LOGGER.printStackTrace(e);
        }
    }

    public void clearCache() {
        this.cached = null;
    }

    public void restoreCache() {
        if (this.cached == null) {
            throw new NullPointerException("No config cache was found for class " + this.configClass.getSimpleName());
        }
        BoxLib.LOGGER.info("Restoring cached config for class %s", this.config.getClass().getSimpleName());
        this.config = this.cached;
        this.clearCache();
        this.save();
    }

    public void load() {
        try {
            this.config.onConfigLoadPre();
            BufferedReader r = new BufferedReader(new FileReader(this.filePath));
            this.config = (BConfig)this.serializer.fromJson((Reader)r, this.configClass);
            BoxLib.LOGGER.info("Successfully loaded config class %s", this.configClass.getSimpleName());
            this.config.onConfigLoadPost();
        }
        catch (FileNotFoundException ignored) {
            BoxLib.LOGGER.warn("Could not find file %s so creating it", this.filePath.getName());
            this.config = (BConfig)BoxLib.initializeClass(this.configClass);
            this.save();
        }
    }

    public void save() {
        try {
            this.config.onConfigSavePre();
            String json = this.serializer.toJson(this.config);
            FileWriter writer = new FileWriter(this.filePath);
            writer.write(json);
            writer.flush();
            writer.close();
            BoxLib.LOGGER.info("Successfully saved config for class %s", this.configClass.getSimpleName());
            this.config.onConfigSavePost();
        }
        catch (IOException e) {
            BoxLib.LOGGER.error("Could not save config for class %s", this.configClass.getSimpleName());
            BoxLib.LOGGER.printStackTrace(e);
        }
    }
}

