/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.scheduling;

import dev.boxadactle.boxlib.function.EmptyMethod;
import dev.boxadactle.boxlib.scheduling.ScheduleAction;
import java.util.List;
import org.apache.commons.compress.utils.Lists;

public class Scheduling {
    static List<ScheduleAction> actions = Lists.newArrayList();
    static List<ScheduleAction> finishedActions = Lists.newArrayList();

    public static void schedule(ScheduleAction action) {
        actions.add(action);
    }

    public static ScheduleAction schedule(final int ticks, final EmptyMethod method) {
        ScheduleAction action = new ScheduleAction(){

            @Override
            public int getWaitTime() {
                return ticks;
            }

            @Override
            public void run() {
                method.accept();
            }
        };
        actions.add(action);
        return action;
    }

    public static ScheduleAction nextTick(EmptyMethod method) {
        return Scheduling.schedule(1, method);
    }

    public static void cancel(ScheduleAction action) {
        finishedActions.add(action);
    }

    public static void tick() {
        if (actions.isEmpty()) {
            return;
        }
        actions.forEach(a -> {
            if (a.tick()) {
                finishedActions.add((ScheduleAction)a);
            }
        });
        finishedActions.forEach(completed -> actions.remove(completed));
        finishedActions.clear();
    }
}

