/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.gui.config;

import dev.boxadactle.boxlib.gui.config.BConfigList;
import dev.boxadactle.boxlib.gui.config.BOptionEntry;
import dev.boxadactle.boxlib.gui.config.BOptionHelper;
import dev.boxadactle.boxlib.util.ClientUtils;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.OptionsSubScreen;
import net.minecraft.network.chat.Component;

public abstract class BOptionScreen
extends OptionsSubScreen
implements BOptionHelper {
    protected Screen parent;
    protected BConfigList configList;
    protected Button saveButton;

    public BOptionScreen(Screen parent, Component name) {
        super(parent, ClientUtils.getOptions(), name);
    }

    protected void addContents() {
        this.configList = new BConfigList(ClientUtils.getClient(), this);
        if (this.shouldRenderScrollingWidget()) {
            this.layout.addToContents((LayoutElement)this.configList);
        }
        this.addOptions();
    }

    protected void addFooter() {
        LinearLayout linearLayout = (LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.horizontal().spacing(BOptionHelper.padding()));
        this.initFooter(linearLayout);
    }

    protected void repositionElements() {
        this.layout.setHeaderHeight(this.getHeaderHeight());
        this.layout.setFooterHeight(this.getFooterHeight());
        this.layout.arrangeElements();
        this.configList.updateSize(this.width, this.layout);
    }

    public void tick() {
        super.tick();
        if (this.saveButton != null) {
            boolean a;
            boolean bl = a = !this.configList.hasInvalidEntry();
            if (this.saveButton.active != a) {
                this.saveButton.active = a;
            }
        }
    }

    protected abstract void initFooter(LinearLayout var1);

    protected boolean shouldRenderScrollingWidget() {
        return true;
    }

    protected int getRowWidth() {
        return 220;
    }

    protected int getRowHeight() {
        return BOptionHelper.buttonHeight() + BOptionHelper.padding() * 2;
    }

    protected int getScrollbarX() {
        return this.width / 2 + 124;
    }

    protected int getHeaderHeight() {
        return 30;
    }

    protected int getFooterHeight() {
        return 30;
    }

    @Deprecated
    protected BOptionEntry<?> addConfigOption(BOptionEntry<?> entry) {
        this.configList.addEntry(new BConfigList.SingleEntry(entry));
        return entry;
    }

    protected <T extends BOptionEntry<?>> T addConfigLine(T entry) {
        this.configList.addEntry(new BConfigList.SingleEntry(entry));
        return entry;
    }

    protected <T extends BOptionEntry<?>> BOptionEntry<?>[] addConfigLine(T entry, T entry2) {
        this.configList.addEntry(new BConfigList.DoubleEntry(entry, entry2));
        return new BOptionEntry[]{entry, entry2};
    }

    protected <T extends BConfigList.ConfigEntry> T addConfigLine(T entry) {
        this.configList.addEntry(entry);
        return entry;
    }

    protected void setWiki(Component label, String link) {
        this.addRenderableWidget((GuiEventListener)new Button.Builder(label, b -> ClientUtils.openLinkConfirmScreen(link, (Screen)this)).bounds(3, 3, BOptionHelper.buttonWidth(BOptionHelper.ButtonType.TINY), BOptionHelper.buttonHeight() - 3).build());
    }

    protected Button setSaveButton(Button saveButton) {
        this.saveButton = saveButton;
        return saveButton;
    }

    public static interface Provider<T extends Screen> {
        public T createScreen(Screen var1) throws IllegalAccessException;
    }
}

