/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.gui.config.widget.button;

import dev.boxadactle.boxlib.gui.config.BOptionButton;
import dev.boxadactle.boxlib.gui.config.BOptionTextField;
import dev.boxadactle.boxlib.gui.config.widget.slider.BIntegerSlider;
import dev.boxadactle.boxlib.util.ClientUtils;
import dev.boxadactle.boxlib.util.GuiUtils;
import dev.boxadactle.boxlib.util.RenderUtils;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.layouts.SpacerElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class BColorPickerButton
extends BOptionButton<Integer> {
    Screen parent;
    boolean alpha;

    public BColorPickerButton(String key, Screen parent, boolean alpha, Integer value, Consumer<Integer> function) {
        super((Component)Component.translatable((String)key, (Object[])new Object[]{Component.literal((String)" ")}), value, function);
        this.parent = parent;
        this.alpha = alpha;
    }

    @Override
    protected Integer changeValue(Integer input) {
        return null;
    }

    public void updateColor(int newColor) {
        this.currentValue = newColor;
        this.function.accept(newColor);
    }

    @Override
    public void renderWidget(GuiGraphics p_93657_, int mouseX, int mouseY, float delta) {
        super.renderWidget(p_93657_, mouseX, mouseY, delta);
        int textWidth = GuiUtils.getTextRenderer().width((FormattedText)this.getMessage());
        int r = this.getWidth() / 2 + textWidth / 2;
        RenderUtils.drawSquare(p_93657_, this.getX() + r + 5, this.getY() + 3, 20, this.getButtonHeight() - 6, this.alpha ? (Integer)this.currentValue : GuiUtils.applyAlpha((Integer)this.currentValue, 1.0f));
    }

    @Override
    public void onClick(MouseButtonEvent mouseButtonEvent, boolean bl) {
        ClientUtils.setScreen(new ColorPickerScreen(this.getMessage(), (Integer)this.currentValue));
    }

    public class ColorPickerScreen
    extends Screen {
        HeaderAndFooterLayout layout;
        int r;
        int g;
        int b;
        int a;
        BIntegerSlider as;
        BIntegerSlider gs;
        BIntegerSlider bs;
        BIntegerSlider rs;
        BOptionTextField<Integer> colorField;

        protected ColorPickerScreen(Component component, int color) {
            super(component);
            this.layout = new HeaderAndFooterLayout((Screen)this);
            this.r = color >> 16 & 0xFF;
            this.g = color >> 8 & 0xFF;
            this.b = color & 0xFF;
            this.a = BColorPickerButton.this.alpha ? color >> 24 & 0xFF : 255;
        }

        private int getColor() {
            return this.a << 24 | this.r << 16 | this.g << 8 | this.b;
        }

        protected void init() {
            this.layout.addTitleHeader(this.title, GuiUtils.getTextRenderer());
            LinearLayout linearLayout = LinearLayout.vertical().spacing(BColorPickerButton.this.getPadding());
            linearLayout.addChild((LayoutElement)new SpacerElement(50, 130));
            this.as = (BIntegerSlider)linearLayout.addChild((LayoutElement)this.slider(new BIntegerSlider("boxlib.color.red", 0, 255, this.r, v -> {
                this.r = v;
            })));
            this.gs = (BIntegerSlider)linearLayout.addChild((LayoutElement)this.slider(new BIntegerSlider("boxlib.color.green", 0, 255, this.g, v -> {
                this.g = v;
            })));
            this.bs = (BIntegerSlider)linearLayout.addChild((LayoutElement)this.slider(new BIntegerSlider("boxlib.color.blue", 0, 255, this.b, v -> {
                this.b = v;
            })));
            this.rs = (BIntegerSlider)linearLayout.addChild((LayoutElement)this.slider(new BIntegerSlider("boxlib.color.alpha", 0, 255, this.a, v -> {
                this.a = v;
            })));
            this.rs.active = BColorPickerButton.this.alpha;
            this.layout.addToContents((LayoutElement)linearLayout);
            this.layout.addToFooter((LayoutElement)BColorPickerButton.this.createDoneButton(this::close));
            this.layout.visitWidgets(x$0 -> {
                AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
            });
            this.layout.arrangeElements();
        }

        public void render(GuiGraphics guiGraphics, int i, int j, float f) {
            super.render(guiGraphics, i, j, f);
            RenderUtils.drawSquare(guiGraphics, this.width / 2 - 50, 35, 100, 60, this.getColor());
        }

        private BIntegerSlider slider(BIntegerSlider slider) {
            slider.setWidth(200);
            slider.setHeight(20);
            return slider;
        }

        private void close(Button b) {
            BColorPickerButton.this.updateColor(this.getColor());
            ClientUtils.setScreen(BColorPickerButton.this.parent);
        }

        public boolean shouldCloseOnEsc() {
            return false;
        }
    }
}

