/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.http;

import dev.boxadactle.boxlib.http.HttpRequest;
import dev.boxadactle.boxlib.http.InvalidHttpRequestException;
import dev.boxadactle.boxlib.http.get.PlainGetRequest;
import java.net.HttpURLConnection;
import java.net.URI;

public class Request {
    public static <T> T sendRequest(HttpRequest<T> request) {
        try {
            URI uri = request.getRequestURI();
            HttpURLConnection connection = (HttpURLConnection)uri.toURL().openConnection();
            request.setRequestHeaders(connection);
            T response = request.onResponseCode(connection, connection.getResponseCode());
            connection.disconnect();
            return response;
        }
        catch (Exception e) {
            request.onException(e);
            return null;
        }
    }

    public static String sendPlainGetRequest(final String url) {
        return Request.sendRequest(new PlainGetRequest(){

            @Override
            public String getRequestUrlString() throws InvalidHttpRequestException {
                return url;
            }

            @Override
            public String handleResponse(String response) {
                return PlainGetRequest.super.handleResponse(response);
            }
        });
    }
}

