/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.layouts;

import dev.boxadactle.boxlib.layouts.LayoutComponent;
import dev.boxadactle.boxlib.math.geometry.Rect;
import dev.boxadactle.boxlib.math.geometry.Vec3;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;

public abstract class RenderingLayout {
    protected int x;
    protected int y;
    protected int padding;
    protected List<LayoutComponent<?>> components;

    protected abstract int getWidth();

    protected abstract int getHeight();

    public abstract void render(GuiGraphics var1);

    protected void orderComponents() {
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setPosition(Vec3<Integer> position) {
        this.x = position.getX();
        this.y = position.getY();
    }

    public Rect<Integer> calculateRect() {
        return new Rect<Integer>(this.x, this.y, this.getWidth(), this.getHeight());
    }

    public void addComponent(LayoutComponent<?> component) {
        this.components.add(component);
    }

    public void removeComponent(LayoutComponent<?> component) {
        this.components.remove(component);
    }

    public RenderingLayout(int x, int y, int padding) {
        this.x = x;
        this.y = y;
        this.padding = padding;
        this.components = new ArrayList();
    }

    public RenderingLayout(int x, int y) {
        this(x, y, 0);
    }
}

