/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.math.geometry;

import dev.boxadactle.boxlib.math.geometry.Vec2;
import java.util.List;

public class Polygon<T extends Number> {
    public List<Vec2<T>> vertices;

    public Polygon(List<Vec2<T>> vertices) {
        this.vertices = vertices;
    }

    public List<Vec2<T>> getVertices() {
        return this.vertices;
    }

    public T getPerimeter() {
        double perimeter = 0.0;
        int numVertices = this.vertices.size();
        for (int i = 0; i < numVertices; ++i) {
            Vec2<T> p1 = this.vertices.get(i);
            Vec2<T> p2 = this.vertices.get((i + 1) % numVertices);
            perimeter += ((Double)this.calculateDistance(p1, p2)).doubleValue();
        }
        return (T)Double.valueOf(perimeter);
    }

    public T getArea() {
        double area = 0.0;
        int numVertices = this.vertices.size();
        for (int i = 0; i < numVertices; ++i) {
            Vec2<T> p1 = this.vertices.get(i);
            Vec2<T> p2 = this.vertices.get((i + 1) % numVertices);
            area += ((Number)p1.getX()).doubleValue() * ((Number)p2.getY()).doubleValue() - ((Number)p2.getX()).doubleValue() * ((Number)p1.getY()).doubleValue();
        }
        return (T)Double.valueOf(Math.abs(area) / 2.0);
    }

    public boolean containsPoint(Vec2<T> point) {
        int wn = 0;
        int numVertices = this.vertices.size();
        for (int i = 0; i < numVertices; ++i) {
            Vec2<T> p1 = this.vertices.get(i);
            Vec2<T> p2 = this.vertices.get((i + 1) % numVertices);
            if (((Number)p1.getY()).doubleValue() <= ((Number)point.getY()).doubleValue()) {
                if (!(((Number)p2.getY()).doubleValue() > ((Number)point.getY()).doubleValue()) || !((Double)this.isLeft(p1, p2, point) > 0.0)) continue;
                ++wn;
                continue;
            }
            if (!(((Number)p2.getY()).doubleValue() <= ((Number)point.getY()).doubleValue()) || !((Double)this.isLeft(p1, p2, point) < 0.0)) continue;
            --wn;
        }
        return wn != 0;
    }

    private T isLeft(Vec2<T> p1, Vec2<T> p2, Vec2<T> point) {
        return (T)Double.valueOf((((Number)p2.getX()).doubleValue() - ((Number)p1.getX()).doubleValue()) * (((Number)point.getY()).doubleValue() - ((Number)p1.getY()).doubleValue()) - (((Number)point.getX()).doubleValue() - ((Number)p1.getX()).doubleValue()) * (((Number)p2.getY()).doubleValue() - ((Number)p1.getY()).doubleValue()));
    }

    private T calculateDistance(Vec2<T> p1, Vec2<T> p2) {
        double dx = ((Number)p2.getX()).doubleValue() - ((Number)p1.getX()).doubleValue();
        double dy = ((Number)p2.getY()).doubleValue() - ((Number)p1.getY()).doubleValue();
        return (T)Double.valueOf(Math.sqrt(dx * dx + dy * dy));
    }

    protected Polygon<T> clone() {
        return new Polygon<T>(this.vertices);
    }
}

